/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.tasks.states;

import com.fasterxml.jackson.core.type.TypeReference;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.utils.MapUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractState
extends Task {
    private static final TypeReference<Map<String, Object>> TYPE_REFERENCE = new TypeReference<Map<String, Object>>(){};
    @Schema(title="The name of state file")
    @PluginProperty(dynamic=true)
    @NotNull
    protected String name;
    @Schema(title="Share state for the current namespace", description="By default, the state is isolated by namespace **and** flow, setting to `true` will allow to share the state between the **same** namespace")
    @PluginProperty(dynamic=true)
    private final Boolean namespace;
    @Schema(title="Isolate with `taskrun.value` the state", description="By default, the `taskrun.value` (during iteration with each) will isolated the state, setting to `false` will allow to use the same one for iteration.")
    @PluginProperty(dynamic=true)
    private final Boolean taskrunValue;

    protected Map<String, Object> get(RunContext runContext) throws IllegalVariableEvaluationException, IOException {
        InputStream taskStateFile = runContext.getTaskStateFile("tasks-states", runContext.render(this.name), this.namespace, this.taskrunValue);
        return (Map)JacksonMapper.ofJson(false).readValue(taskStateFile, TYPE_REFERENCE);
    }

    protected Pair<URI, Map<String, Object>> merge(RunContext runContext, Map<String, Object> map) throws IllegalVariableEvaluationException, IOException {
        Map<String, Object> current;
        try {
            current = this.get(runContext);
        }
        catch (FileNotFoundException e) {
            current = Map.of();
        }
        Map<String, Object> merge = MapUtils.merge(current, runContext.render(map));
        URI uri = runContext.putTaskStateFile(JacksonMapper.ofJson(false).writeValueAsBytes(merge), "tasks-states", runContext.render(this.name), this.namespace, this.taskrunValue);
        return Pair.of((Object)uri, merge);
    }

    protected boolean delete(RunContext runContext) throws IllegalVariableEvaluationException, IOException {
        return runContext.deleteTaskStateFile("tasks-states", runContext.render(this.name), this.namespace, this.taskrunValue);
    }

    @Generated
    private static String $default$name() {
        return "default";
    }

    @Generated
    private static Boolean $default$namespace() {
        return false;
    }

    @Generated
    private static Boolean $default$taskrunValue() {
        return true;
    }

    @Generated
    protected AbstractState(AbstractStateBuilder<?, ?> b) {
        super(b);
        this.name = b.name$set ? b.name$value : AbstractState.$default$name();
        this.namespace = b.namespace$set ? b.namespace$value : AbstractState.$default$namespace();
        this.taskrunValue = b.taskrunValue$set ? b.taskrunValue$value : AbstractState.$default$taskrunValue();
    }

    @Generated
    public String toString() {
        return "AbstractState(super=" + super.toString() + ", name=" + this.getName() + ", namespace=" + this.getNamespace() + ", taskrunValue=" + this.getTaskrunValue() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractState)) {
            return false;
        }
        AbstractState other = (AbstractState)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$namespace = this.getNamespace();
        Boolean other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !((Object)this$namespace).equals(other$namespace)) {
            return false;
        }
        Boolean this$taskrunValue = this.getTaskrunValue();
        Boolean other$taskrunValue = other.getTaskrunValue();
        if (this$taskrunValue == null ? other$taskrunValue != null : !((Object)this$taskrunValue).equals(other$taskrunValue)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractState;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : ((Object)$namespace).hashCode());
        Boolean $taskrunValue = this.getTaskrunValue();
        result = result * 59 + ($taskrunValue == null ? 43 : ((Object)$taskrunValue).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getNamespace() {
        return this.namespace;
    }

    @Generated
    public Boolean getTaskrunValue() {
        return this.taskrunValue;
    }

    @Generated
    public AbstractState() {
        this.name = AbstractState.$default$name();
        this.namespace = AbstractState.$default$namespace();
        this.taskrunValue = AbstractState.$default$taskrunValue();
    }

    @Generated
    public static abstract class AbstractStateBuilder<C extends AbstractState, B extends AbstractStateBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private boolean name$set;
        @Generated
        private String name$value;
        @Generated
        private boolean namespace$set;
        @Generated
        private Boolean namespace$value;
        @Generated
        private boolean taskrunValue$set;
        @Generated
        private Boolean taskrunValue$value;

        @Generated
        public B name(String name) {
            this.name$value = name;
            this.name$set = true;
            return (B)this.self();
        }

        @Generated
        public B namespace(Boolean namespace) {
            this.namespace$value = namespace;
            this.namespace$set = true;
            return (B)this.self();
        }

        @Generated
        public B taskrunValue(Boolean taskrunValue) {
            this.taskrunValue$value = taskrunValue;
            this.taskrunValue$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "AbstractState.AbstractStateBuilder(super=" + super.toString() + ", name$value=" + this.name$value + ", namespace$value=" + this.namespace$value + ", taskrunValue$value=" + this.taskrunValue$value + ")";
        }
    }
}

