/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.tasks.storages;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.tasks.Output;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.kestra.core.tasks.scripts.BashService;
import io.kestra.core.utils.ListUtils;
import io.kestra.core.utils.Rethrow;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

@Schema(title="Allow to create files in the local filesystem or to send files from the local filesystem to the internal storage.", description="This task should be used with the WorkingDirectory task to be able to access the same local filesystem within multiple tasks.")
@Plugin(examples={@Example(full=true, title="Create a local file that will be accessible to a bash task", code={"id: \"local-files\"\nnamespace: \"io.kestra.tests\"\n\ntasks:\n  - id: workingDir\n    type: io.kestra.core.tasks.flows.WorkingDirectory\n    tasks:\n    - id: inputFiles\n      type: io.kestra.core.tasks.storages.LocalFiles\n      inputs:\n        hello.txt: \"Hello World\\n\"\n        address.json: \"{{ outputs.myTaskId.uri }}\"\n    - id: bash\n      type: io.kestra.core.tasks.scripts.Bash\n      commands:\n        - cat hello.txt\n"}), @Example(full=true, title="Send local files to Kestra's internal storage", code={"id: \"local-files\"\nnamespace: \"io.kestra.tests\"\n\ntasks:\n  - id: workingDir\n    type: io.kestra.core.tasks.flows.WorkingDirectory\n    tasks:\n    - id: bash\n      type: io.kestra.core.tasks.scripts.Bash\n      commands:\n        - mkdir -p sub/dir\n        - echo \"Hello from Bash\" >> sub/dir/bash1.txt\n        - echo \"Hello from Bash\" >> sub/dir/bash2.txt\n    - id: outputFiles\n      type: io.kestra.core.tasks.storages.LocalFiles\n      outputs:\n        - sub/**\n"})})
public class LocalFiles
extends Task
implements RunnableTask<LocalFilesOutput> {
    @Schema(title="The files to create on the local filesystem. Can be a map or a JSON object.", anyOf={Map.class, String.class})
    @PluginProperty(dynamic=true)
    private Object inputs;
    @Schema(title="The files from the local filesystem to send to the internal storage.", description="Must be a list of [Glob](https://en.wikipedia.org/wiki/Glob_(programming)) expressions relative to the current working directory, some examples: `my-dir/**`, `my-dir/*/**` or `my-dir/my-file.txt`")
    @PluginProperty(dynamic=true)
    private List<String> outputs;

    @Override
    public LocalFilesOutput run(RunContext runContext) throws Exception {
        Logger logger = runContext.logger();
        Map<String, String> inputFiles = this.inputs == null ? Map.of() : BashService.transformInputFiles(runContext, this.inputs);
        inputFiles.forEach(Rethrow.throwBiConsumer((fileName, input) -> {
            block14: {
                String fileContent;
                File file = new File(runContext.tempDir().toString(), (String)fileName);
                if (file.exists()) {
                    throw new IllegalVariableEvaluationException("File '" + fileName + "' already exist!");
                }
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                if ((fileContent = runContext.render((String)input)).startsWith("kestra://")) {
                    try (InputStream is = runContext.uriToInputStream(URI.create(fileContent));
                         FileOutputStream out = new FileOutputStream(file);){
                        IOUtils.copyLarge((InputStream)is, (OutputStream)out);
                        break block14;
                    }
                }
                Files.write(file.toPath(), fileContent.getBytes(), new OpenOption[0]);
            }
        }));
        Map<String, URI> outputFiles = ListUtils.emptyOnNull(this.outputs).stream().flatMap(Rethrow.throwFunction(output -> this.outputMatcher(runContext, (String)output))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        logger.info("Provided {} input(s) and captured {} output(s).", (Object)inputFiles.size(), (Object)outputFiles.size());
        return LocalFilesOutput.builder().uris(outputFiles).build();
    }

    private Stream<AbstractMap.SimpleEntry<String, URI>> outputMatcher(RunContext runContext, String output) throws IllegalVariableEvaluationException, IOException {
        String glob = runContext.render(output);
        PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:" + glob);
        try (Stream<Path> walk = Files.walk(runContext.tempDir(), new FileVisitOption[0]);){
            Stream<AbstractMap.SimpleEntry<String, URI>> stream = walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> pathMatcher.matches(runContext.tempDir().relativize((Path)path))).map(Rethrow.throwFunction(path -> new AbstractMap.SimpleEntry<String, URI>(runContext.tempDir().relativize((Path)path).toString(), runContext.putTempFile(path.toFile())))).toList().stream();
            return stream;
        }
    }

    @Generated
    protected LocalFiles(LocalFilesBuilder<?, ?> b) {
        super(b);
        this.inputs = b.inputs;
        this.outputs = b.outputs;
    }

    @Generated
    public static LocalFilesBuilder<?, ?> builder() {
        return new LocalFilesBuilderImpl();
    }

    @Generated
    public String toString() {
        return "LocalFiles(super=" + super.toString() + ", inputs=" + this.getInputs() + ", outputs=" + this.getOutputs() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocalFiles)) {
            return false;
        }
        LocalFiles other = (LocalFiles)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Object this$inputs = this.getInputs();
        Object other$inputs = other.getInputs();
        if (this$inputs == null ? other$inputs != null : !this$inputs.equals(other$inputs)) {
            return false;
        }
        List<String> this$outputs = this.getOutputs();
        List<String> other$outputs = other.getOutputs();
        return !(this$outputs == null ? other$outputs != null : !((Object)this$outputs).equals(other$outputs));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LocalFiles;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Object $inputs = this.getInputs();
        result = result * 59 + ($inputs == null ? 43 : $inputs.hashCode());
        List<String> $outputs = this.getOutputs();
        result = result * 59 + ($outputs == null ? 43 : ((Object)$outputs).hashCode());
        return result;
    }

    @Generated
    public Object getInputs() {
        return this.inputs;
    }

    @Generated
    public List<String> getOutputs() {
        return this.outputs;
    }

    @Generated
    public LocalFiles() {
    }

    public static class LocalFilesOutput
    implements Output {
        @Schema(title="The URI of the files that have been sent to the internal storage")
        private Map<String, URI> uris;

        @ConstructorProperties(value={"uris"})
        @Generated
        LocalFilesOutput(Map<String, URI> uris) {
            this.uris = uris;
        }

        @Generated
        public static LocalFilesOutputBuilder builder() {
            return new LocalFilesOutputBuilder();
        }

        @Generated
        public Map<String, URI> getUris() {
            return this.uris;
        }

        @Generated
        public static class LocalFilesOutputBuilder {
            @Generated
            private Map<String, URI> uris;

            @Generated
            LocalFilesOutputBuilder() {
            }

            @Generated
            public LocalFilesOutputBuilder uris(Map<String, URI> uris) {
                this.uris = uris;
                return this;
            }

            @Generated
            public LocalFilesOutput build() {
                return new LocalFilesOutput(this.uris);
            }

            @Generated
            public String toString() {
                return "LocalFiles.LocalFilesOutput.LocalFilesOutputBuilder(uris=" + this.uris + ")";
            }
        }
    }

    @Generated
    public static abstract class LocalFilesBuilder<C extends LocalFiles, B extends LocalFilesBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private Object inputs;
        @Generated
        private List<String> outputs;

        @Generated
        public B inputs(Object inputs) {
            this.inputs = inputs;
            return (B)this.self();
        }

        @Generated
        public B outputs(List<String> outputs) {
            this.outputs = outputs;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "LocalFiles.LocalFilesBuilder(super=" + super.toString() + ", inputs=" + this.inputs + ", outputs=" + this.outputs + ")";
        }
    }

    @Generated
    private static final class LocalFilesBuilderImpl
    extends LocalFilesBuilder<LocalFiles, LocalFilesBuilderImpl> {
        @Generated
        private LocalFilesBuilderImpl() {
        }

        @Override
        @Generated
        protected LocalFilesBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public LocalFiles build() {
            return new LocalFiles(this);
        }
    }
}

