/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;

public class MapUtils {
    public static Map<String, Object> merge(Map<String, Object> a, Map<String, Object> b) {
        if (a == null && b == null) {
            return null;
        }
        if (a == null || a.size() == 0) {
            return MapUtils.copyMap(b);
        }
        if (b == null || b.size() == 0) {
            return MapUtils.copyMap(a);
        }
        Map copy = MapUtils.copyMap(a);
        copy.putAll(b.keySet().stream().collect(Collectors.toMap(key -> key, key -> {
            Object original = copy.get(key);
            Object value = b.get(key);
            if (value == null && original == null) {
                return null;
            }
            if (value == null) {
                return original;
            }
            if (original == null) {
                return value;
            }
            if (value instanceof Map && original instanceof Map) {
                return MapUtils.merge((Map)original, (Map)value);
            }
            if (value instanceof Collection && original instanceof Collection) {
                try {
                    Collection merge = MapUtils.copyCollection((Collection)original, Lists.newArrayList((Object[])new Collection[]{(Collection)original, (Collection)value}).stream().flatMap(Collection::stream).collect(Collectors.toList()));
                    return merge;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return value;
        })));
        return copy;
    }

    private static Map copyMap(Map original) {
        return original.keySet().stream().collect(Collectors.toMap(key -> key, key -> {
            Object value = original.get(key);
            if (value instanceof Map) {
                return MapUtils.copyMap((Map)value);
            }
            if (value instanceof Collection) {
                return MapUtils.copyCollection((Collection)value, (Collection)value);
            }
            return value;
        }));
    }

    private static Collection copyCollection(Collection collection, Collection elements) {
        try {
            Collection newInstance = (Collection)collection.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            newInstance.addAll(elements);
            return newInstance;
        }
        catch (Exception e) {
            return new ArrayList(elements);
        }
    }
}

