/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.docs;

import com.github.jknack.handlebars.EscapingStrategy;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.helper.ConditionalHelpers;
import com.github.jknack.handlebars.helper.EachHelper;
import com.github.jknack.handlebars.helper.LogHelper;
import com.github.jknack.handlebars.helper.StringHelpers;
import com.github.jknack.handlebars.helper.UnlessHelper;
import com.github.jknack.handlebars.helper.WithHelper;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import io.kestra.core.docs.AbstractClassDocumentation;
import io.kestra.core.docs.ClassPluginDocumentation;
import io.kestra.core.docs.Document;
import io.kestra.core.docs.JsonSchemaGenerator;
import io.kestra.core.models.annotations.PluginSubGroup;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.plugins.RegisteredPlugin;
import io.kestra.core.runners.handlebars.helpers.DateHelper;
import io.kestra.core.runners.handlebars.helpers.JsonHelper;
import io.kestra.core.runners.handlebars.helpers.OtherBooleansHelper;
import io.kestra.core.runners.handlebars.helpers.OtherStringsHelper;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.utils.Rethrow;
import io.kestra.core.utils.Slugify;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

@Singleton
public class DocumentationGenerator {
    private static final Handlebars handlebars = new Handlebars().with(EscapingStrategy.NOOP).registerHelpers(ConditionalHelpers.class).registerHelpers(EachHelper.class).registerHelpers(LogHelper.class).registerHelpers(StringHelpers.class).registerHelpers(OtherStringsHelper.class).registerHelpers(OtherBooleansHelper.class).registerHelper("definitionName", (context, options) -> {
        String s = StringUtils.substringAfterLast((String)context.toString(), (String)".");
        if (s.contains("-")) {
            String s1 = StringUtils.substringAfter((String)s, (String)"-");
            try {
                Integer.parseInt(s1);
            }
            catch (NumberFormatException e) {
                s = s1;
            }
        }
        return s;
    }).registerHelpers(UnlessHelper.class).registerHelpers(WithHelper.class).registerHelpers(DateHelper.class).registerHelpers(JsonHelper.class);
    @Inject
    JsonSchemaGenerator jsonSchemaGenerator;

    public List<Document> generate(RegisteredPlugin registeredPlugin) throws Exception {
        ArrayList<Document> result = new ArrayList<Document>();
        result.addAll(DocumentationGenerator.index(registeredPlugin));
        result.addAll(this.generate(registeredPlugin, registeredPlugin.getTasks(), Task.class, "tasks"));
        result.addAll(this.generate(registeredPlugin, registeredPlugin.getTriggers(), AbstractTrigger.class, "triggers"));
        result.addAll(this.generate(registeredPlugin, registeredPlugin.getConditions(), Condition.class, "conditions"));
        result.addAll(DocumentationGenerator.guides(registeredPlugin));
        return result;
    }

    private static List<Document> index(RegisteredPlugin plugin) throws IOException {
        Map<SubGroup, Map<String, List<ClassPlugin>>> groupedClass = DocumentationGenerator.indexGroupedClass(plugin);
        if (groupedClass.isEmpty()) {
            return Collections.emptyList();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"title", (Object)plugin.title().replace("plugin-", ""));
        if (plugin.description() != null) {
            builder.put((Object)"description", (Object)plugin.description());
        }
        if (plugin.longDescription() != null) {
            builder.put((Object)"longDescription", (Object)plugin.longDescription());
        }
        builder.put((Object)"group", (Object)plugin.group());
        builder.put((Object)"classPlugins", groupedClass);
        if (plugin.icon("plugin-icon") != null) {
            builder.put((Object)"icon", (Object)plugin.icon("plugin-icon"));
        }
        if (!plugin.getGuides().isEmpty()) {
            builder.put((Object)"guides", plugin.getGuides());
        }
        return Collections.singletonList(new Document(DocumentationGenerator.docPath(plugin), DocumentationGenerator.render("index", (Map<String, Object>)builder.build()), plugin.icon("plugin-icon")));
    }

    private static Map<SubGroup, Map<String, List<ClassPlugin>>> indexGroupedClass(RegisteredPlugin plugin) {
        return plugin.allClassGrouped().entrySet().stream().filter(r -> !((String)r.getKey()).equals("controllers") && !((String)r.getKey()).equals("storages")).flatMap(entry -> ((List)entry.getValue()).stream().map(cls -> {
            ClassPlugin.ClassPluginBuilder builder = ClassPlugin.builder().name(cls.getName()).simpleName(cls.getSimpleName()).type((String)entry.getKey());
            if (cls.getPackageName().startsWith(plugin.group())) {
                PluginSubGroup pluginSubGroup = cls.getPackage().getDeclaredAnnotation(PluginSubGroup.class);
                String subGroupName = cls.getPackageName().length() > plugin.group().length() ? cls.getPackageName().substring(plugin.group().length() + 1) : "";
                String subGroupTitle = pluginSubGroup != null ? pluginSubGroup.title() : subGroupName;
                String subGroupDescription = pluginSubGroup != null ? pluginSubGroup.description() : null;
                boolean subgroupIsGroup = cls.getPackageName().length() <= plugin.group().length();
                String subGroupIcon = plugin.icon(cls.getPackageName());
                SubGroup subgroup = new SubGroup(subGroupName, subGroupTitle, subGroupDescription, subGroupIcon, subgroupIsGroup);
                builder.subgroup(subgroup);
            } else {
                builder.subgroup(new SubGroup(""));
            }
            return builder.build();
        })).filter(Objects::nonNull).distinct().sorted(Comparator.comparing(ClassPlugin::getSubgroup).thenComparing(ClassPlugin::getType).thenComparing(ClassPlugin::getName)).collect(Collectors.groupingBy(ClassPlugin::getSubgroup, Collectors.groupingBy(ClassPlugin::getType)));
    }

    private static List<Document> guides(RegisteredPlugin plugin) throws Exception {
        String pluginName = Slugify.of(plugin.title());
        return plugin.guides().entrySet().stream().map(Rethrow.throwFunction(e -> new Document(pluginName + "/guides/" + (String)e.getKey() + ".md", (String)e.getValue(), null))).collect(Collectors.toList());
    }

    private <T> List<Document> generate(RegisteredPlugin registeredPlugin, List<Class<? extends T>> cls, Class<T> baseCls, String type) {
        return cls.stream().map(r -> ClassPluginDocumentation.of(this.jsonSchemaGenerator, registeredPlugin, r, baseCls)).map(pluginDocumentation -> {
            try {
                return new Document(DocumentationGenerator.docPath(registeredPlugin, type, pluginDocumentation), DocumentationGenerator.render(pluginDocumentation), pluginDocumentation.getIcon());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    private static String docPath(RegisteredPlugin registeredPlugin) {
        String pluginName = Slugify.of(registeredPlugin.path());
        return pluginName + "/index.md";
    }

    private static <T> String docPath(RegisteredPlugin registeredPlugin, String type, ClassPluginDocumentation<T> classPluginDocumentation) {
        String pluginName = Slugify.of(registeredPlugin.path());
        return pluginName + "/" + type + "/" + (String)(classPluginDocumentation.getSubGroup() != null ? classPluginDocumentation.getSubGroup() + "/" : "") + classPluginDocumentation.getCls() + ".md";
    }

    public static <T> String render(ClassPluginDocumentation<T> classPluginDocumentation) throws IOException {
        return DocumentationGenerator.render("task", JacksonMapper.toMap(classPluginDocumentation));
    }

    public static <T> String render(AbstractClassDocumentation<T> classInputDocumentation) throws IOException {
        return DocumentationGenerator.render("task", JacksonMapper.toMap(classInputDocumentation));
    }

    public static <T> String render(String templateName, Map<String, Object> vars) throws IOException {
        String hbsTemplate = IOUtils.toString((InputStream)Objects.requireNonNull(DocumentationGenerator.class.getClassLoader().getResourceAsStream("docs/" + templateName + ".hbs")), (Charset)Charsets.UTF_8);
        Template template = handlebars.compileInline(hbsTemplate);
        String renderer = template.apply(vars);
        Pattern pattern = Pattern.compile("`\\{\\{(.*?)\\}\\}`", 8);
        renderer = pattern.matcher(renderer).replaceAll("<code v-pre>{{ $1 }}</code>");
        renderer = renderer.replaceAll("\n::alert\\{type=\"(.*)\"\\}\n", "\n::: $1\n");
        renderer = renderer.replaceAll("\n::\n", "\n:::\n");
        return renderer;
    }

    public static class ClassPlugin {
        String name;
        String simpleName;
        SubGroup subgroup;
        String group;
        String type;

        @Generated
        public static ClassPluginBuilder builder() {
            return new ClassPluginBuilder();
        }

        @ConstructorProperties(value={"name", "simpleName", "subgroup", "group", "type"})
        @Generated
        public ClassPlugin(String name, String simpleName, SubGroup subgroup, String group, String type) {
            this.name = name;
            this.simpleName = simpleName;
            this.subgroup = subgroup;
            this.group = group;
            this.type = type;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getSimpleName() {
            return this.simpleName;
        }

        @Generated
        public SubGroup getSubgroup() {
            return this.subgroup;
        }

        @Generated
        public String getGroup() {
            return this.group;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public static class ClassPluginBuilder {
            @Generated
            private String name;
            @Generated
            private String simpleName;
            @Generated
            private SubGroup subgroup;
            @Generated
            private String group;
            @Generated
            private String type;

            @Generated
            ClassPluginBuilder() {
            }

            @Generated
            public ClassPluginBuilder name(String name) {
                this.name = name;
                return this;
            }

            @Generated
            public ClassPluginBuilder simpleName(String simpleName) {
                this.simpleName = simpleName;
                return this;
            }

            @Generated
            public ClassPluginBuilder subgroup(SubGroup subgroup) {
                this.subgroup = subgroup;
                return this;
            }

            @Generated
            public ClassPluginBuilder group(String group) {
                this.group = group;
                return this;
            }

            @Generated
            public ClassPluginBuilder type(String type) {
                this.type = type;
                return this;
            }

            @Generated
            public ClassPlugin build() {
                return new ClassPlugin(this.name, this.simpleName, this.subgroup, this.group, this.type);
            }

            @Generated
            public String toString() {
                return "DocumentationGenerator.ClassPlugin.ClassPluginBuilder(name=" + this.name + ", simpleName=" + this.simpleName + ", subgroup=" + this.subgroup + ", group=" + this.group + ", type=" + this.type + ")";
            }
        }
    }

    public static class SubGroup
    implements Comparable<SubGroup> {
        String name;
        String title;
        String description;
        String icon;
        boolean subgroupIsGroup;

        SubGroup(String name) {
            this.name = name;
        }

        @Override
        public int compareTo(SubGroup o) {
            return this.name.compareTo(o.getName());
        }

        @ConstructorProperties(value={"name", "title", "description", "icon", "subgroupIsGroup"})
        @Generated
        public SubGroup(String name, String title, String description, String icon, boolean subgroupIsGroup) {
            this.name = name;
            this.title = title;
            this.description = description;
            this.icon = icon;
            this.subgroupIsGroup = subgroupIsGroup;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getTitle() {
            return this.title;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public String getIcon() {
            return this.icon;
        }

        @Generated
        public boolean isSubgroupIsGroup() {
            return this.subgroupIsGroup;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SubGroup)) {
                return false;
            }
            SubGroup other = (SubGroup)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SubGroup;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }
    }
}

