/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.conditions.types;

import io.kestra.core.exceptions.IllegalConditionEvaluation;
import io.kestra.core.exceptions.InternalException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.conditions.ConditionContext;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.validation.constraints.NotNull;
import lombok.Generated;

@Schema(title="Condition for a specific flow of an execution")
@Plugin(examples={@Example(full=true, code={"- conditions:", "    - type: io.kestra.core.models.conditions.types.ExecutionFlowCondition", "      namespace: io.kestra.tests", "      flowId: my-current-flow"})})
public class ExecutionFlowCondition
extends Condition {
    @NotNull
    @Schema(title="The namespace of the flow")
    @PluginProperty
    private String namespace;
    @NotNull
    @Schema(title="The flow id")
    @PluginProperty
    private String flowId;

    @Override
    public boolean test(ConditionContext conditionContext) throws InternalException {
        if (conditionContext.getExecution() == null) {
            throw new IllegalConditionEvaluation("Invalid condition with execution null");
        }
        return conditionContext.getExecution().getNamespace().equals(this.namespace) && conditionContext.getExecution().getFlowId().equals(this.flowId);
    }

    @Generated
    protected ExecutionFlowCondition(ExecutionFlowConditionBuilder<?, ?> b) {
        super(b);
        this.namespace = b.namespace;
        this.flowId = b.flowId;
    }

    @Generated
    public static ExecutionFlowConditionBuilder<?, ?> builder() {
        return new ExecutionFlowConditionBuilderImpl();
    }

    @Generated
    public String toString() {
        return "ExecutionFlowCondition(super=" + super.toString() + ", namespace=" + this.getNamespace() + ", flowId=" + this.getFlowId() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExecutionFlowCondition)) {
            return false;
        }
        ExecutionFlowCondition other = (ExecutionFlowCondition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$flowId = this.getFlowId();
        String other$flowId = other.getFlowId();
        return !(this$flowId == null ? other$flowId != null : !this$flowId.equals(other$flowId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExecutionFlowCondition;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $flowId = this.getFlowId();
        result = result * 59 + ($flowId == null ? 43 : $flowId.hashCode());
        return result;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public String getFlowId() {
        return this.flowId;
    }

    @Generated
    public ExecutionFlowCondition() {
    }

    @Generated
    public static abstract class ExecutionFlowConditionBuilder<C extends ExecutionFlowCondition, B extends ExecutionFlowConditionBuilder<C, B>>
    extends Condition.ConditionBuilder<C, B> {
        @Generated
        private String namespace;
        @Generated
        private String flowId;

        @Generated
        public B namespace(String namespace) {
            this.namespace = namespace;
            return (B)this.self();
        }

        @Generated
        public B flowId(String flowId) {
            this.flowId = flowId;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "ExecutionFlowCondition.ExecutionFlowConditionBuilder(super=" + super.toString() + ", namespace=" + this.namespace + ", flowId=" + this.flowId + ")";
        }
    }

    @Generated
    private static final class ExecutionFlowConditionBuilderImpl
    extends ExecutionFlowConditionBuilder<ExecutionFlowCondition, ExecutionFlowConditionBuilderImpl> {
        @Generated
        private ExecutionFlowConditionBuilderImpl() {
        }

        @Override
        @Generated
        protected ExecutionFlowConditionBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ExecutionFlowCondition build() {
            return new ExecutionFlowCondition(this);
        }
    }
}

