/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.conditions.types;

import io.kestra.core.exceptions.IllegalConditionEvaluation;
import io.kestra.core.exceptions.InternalException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.conditions.ConditionContext;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.validation.constraints.NotNull;
import lombok.Generated;

@Schema(title="Condition for an execution namespace")
@Plugin(examples={@Example(full=true, code={"- conditions:", "    - type: io.kestra.core.models.conditions.types.ExecutionNamespaceCondition", "      namespace: io.kestra.tests", "      prefix: true"})})
public class ExecutionNamespaceCondition
extends Condition {
    @NotNull
    @Schema(description="The namespace of the flow or the prefix if `prefix` is true")
    @PluginProperty
    private String namespace;
    @Schema(description="If we must look at the flow namespace by prefix (simple startWith case sensitive)")
    @PluginProperty
    private final Boolean prefix;

    @Override
    public boolean test(ConditionContext conditionContext) throws InternalException {
        if (conditionContext.getExecution() == null) {
            throw new IllegalConditionEvaluation("Invalid condition with execution null");
        }
        if (!this.prefix.booleanValue() && conditionContext.getExecution().getNamespace().equals(this.namespace)) {
            return true;
        }
        return this.prefix != false && conditionContext.getExecution().getNamespace().startsWith(this.namespace);
    }

    @Generated
    private static Boolean $default$prefix() {
        return false;
    }

    @Generated
    protected ExecutionNamespaceCondition(ExecutionNamespaceConditionBuilder<?, ?> b) {
        super(b);
        this.namespace = b.namespace;
        this.prefix = b.prefix$set ? b.prefix$value : ExecutionNamespaceCondition.$default$prefix();
    }

    @Generated
    public static ExecutionNamespaceConditionBuilder<?, ?> builder() {
        return new ExecutionNamespaceConditionBuilderImpl();
    }

    @Generated
    public String toString() {
        return "ExecutionNamespaceCondition(super=" + super.toString() + ", namespace=" + this.getNamespace() + ", prefix=" + this.getPrefix() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExecutionNamespaceCondition)) {
            return false;
        }
        ExecutionNamespaceCondition other = (ExecutionNamespaceCondition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$prefix = this.getPrefix();
        Boolean other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        return !(this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExecutionNamespaceCondition;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        return result;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public Boolean getPrefix() {
        return this.prefix;
    }

    @Generated
    public ExecutionNamespaceCondition() {
        this.prefix = ExecutionNamespaceCondition.$default$prefix();
    }

    @Generated
    public static abstract class ExecutionNamespaceConditionBuilder<C extends ExecutionNamespaceCondition, B extends ExecutionNamespaceConditionBuilder<C, B>>
    extends Condition.ConditionBuilder<C, B> {
        @Generated
        private String namespace;
        @Generated
        private boolean prefix$set;
        @Generated
        private Boolean prefix$value;

        @Generated
        public B namespace(String namespace) {
            this.namespace = namespace;
            return (B)this.self();
        }

        @Generated
        public B prefix(Boolean prefix) {
            this.prefix$value = prefix;
            this.prefix$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "ExecutionNamespaceCondition.ExecutionNamespaceConditionBuilder(super=" + super.toString() + ", namespace=" + this.namespace + ", prefix$value=" + this.prefix$value + ")";
        }
    }

    @Generated
    private static final class ExecutionNamespaceConditionBuilderImpl
    extends ExecutionNamespaceConditionBuilder<ExecutionNamespaceCondition, ExecutionNamespaceConditionBuilderImpl> {
        @Generated
        private ExecutionNamespaceConditionBuilderImpl() {
        }

        @Override
        @Generated
        protected ExecutionNamespaceConditionBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ExecutionNamespaceCondition build() {
            return new ExecutionNamespaceCondition(this);
        }
    }
}

