/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.executions;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.kestra.core.models.DeletedInterface;
import io.kestra.core.models.executions.AbstractMetricEntry;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.executions.metrics.Counter;
import io.kestra.core.models.executions.metrics.Timer;
import io.micronaut.core.annotation.Nullable;
import java.beans.ConstructorProperties;
import java.time.Instant;
import java.util.Map;
import javax.validation.constraints.NotNull;
import lombok.Generated;

public final class MetricEntry
implements DeletedInterface {
    @NotNull
    private final String namespace;
    @NotNull
    private final String flowId;
    @Nullable
    private final String taskId;
    @Nullable
    private final String executionId;
    @Nullable
    private final String taskRunId;
    @NotNull
    private final String type;
    @NotNull
    private final String name;
    @NotNull
    @JsonInclude
    private final Double value;
    @NotNull
    private final Instant timestamp;
    @Nullable
    private final Map<String, String> tags;
    @NotNull
    private final boolean deleted;

    public static MetricEntry of(TaskRun taskRun, AbstractMetricEntry<?> metricEntry) {
        return MetricEntry.builder().namespace(taskRun.getNamespace()).flowId(taskRun.getFlowId()).executionId(taskRun.getExecutionId()).taskId(taskRun.getTaskId()).taskRunId(taskRun.getId()).type(metricEntry.getType()).name(metricEntry.name).tags(metricEntry.getTags()).value(MetricEntry.computeValue(metricEntry)).timestamp(metricEntry.getTimestamp()).build();
    }

    private static Double computeValue(AbstractMetricEntry<?> metricEntry) {
        if (metricEntry instanceof Counter) {
            return ((Counter)metricEntry).getValue();
        }
        if (metricEntry instanceof Timer) {
            return ((Timer)metricEntry).getValue().toMillis();
        }
        throw new IllegalArgumentException("Unknown metric type: " + metricEntry.getClass());
    }

    @Generated
    private static boolean $default$deleted() {
        return false;
    }

    @ConstructorProperties(value={"namespace", "flowId", "taskId", "executionId", "taskRunId", "type", "name", "value", "timestamp", "tags", "deleted"})
    @Generated
    MetricEntry(String namespace, String flowId, String taskId, String executionId, String taskRunId, String type, String name, Double value, Instant timestamp, Map<String, String> tags, boolean deleted) {
        this.namespace = namespace;
        this.flowId = flowId;
        this.taskId = taskId;
        this.executionId = executionId;
        this.taskRunId = taskRunId;
        this.type = type;
        this.name = name;
        this.value = value;
        this.timestamp = timestamp;
        this.tags = tags;
        this.deleted = deleted;
    }

    @Generated
    public static MetricEntryBuilder builder() {
        return new MetricEntryBuilder();
    }

    @Generated
    public MetricEntryBuilder toBuilder() {
        return new MetricEntryBuilder().namespace(this.namespace).flowId(this.flowId).taskId(this.taskId).executionId(this.executionId).taskRunId(this.taskRunId).type(this.type).name(this.name).value(this.value).timestamp(this.timestamp).tags(this.tags).deleted(this.deleted);
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public String getFlowId() {
        return this.flowId;
    }

    @Generated
    public String getTaskId() {
        return this.taskId;
    }

    @Generated
    public String getExecutionId() {
        return this.executionId;
    }

    @Generated
    public String getTaskRunId() {
        return this.taskRunId;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Double getValue() {
        return this.value;
    }

    @Generated
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public Map<String, String> getTags() {
        return this.tags;
    }

    @Override
    @Generated
    public boolean isDeleted() {
        return this.deleted;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetricEntry)) {
            return false;
        }
        MetricEntry other = (MetricEntry)o;
        if (this.isDeleted() != other.isDeleted()) {
            return false;
        }
        Double this$value = this.getValue();
        Double other$value = other.getValue();
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$flowId = this.getFlowId();
        String other$flowId = other.getFlowId();
        if (this$flowId == null ? other$flowId != null : !this$flowId.equals(other$flowId)) {
            return false;
        }
        String this$taskId = this.getTaskId();
        String other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId)) {
            return false;
        }
        String this$executionId = this.getExecutionId();
        String other$executionId = other.getExecutionId();
        if (this$executionId == null ? other$executionId != null : !this$executionId.equals(other$executionId)) {
            return false;
        }
        String this$taskRunId = this.getTaskRunId();
        String other$taskRunId = other.getTaskRunId();
        if (this$taskRunId == null ? other$taskRunId != null : !this$taskRunId.equals(other$taskRunId)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Instant this$timestamp = this.getTimestamp();
        Instant other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        Map<String, String> this$tags = this.getTags();
        Map<String, String> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDeleted() ? 79 : 97);
        Double $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $flowId = this.getFlowId();
        result = result * 59 + ($flowId == null ? 43 : $flowId.hashCode());
        String $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
        String $executionId = this.getExecutionId();
        result = result * 59 + ($executionId == null ? 43 : $executionId.hashCode());
        String $taskRunId = this.getTaskRunId();
        result = result * 59 + ($taskRunId == null ? 43 : $taskRunId.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Instant $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        Map<String, String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MetricEntry(namespace=" + this.getNamespace() + ", flowId=" + this.getFlowId() + ", taskId=" + this.getTaskId() + ", executionId=" + this.getExecutionId() + ", taskRunId=" + this.getTaskRunId() + ", type=" + this.getType() + ", name=" + this.getName() + ", value=" + this.getValue() + ", timestamp=" + this.getTimestamp() + ", tags=" + this.getTags() + ", deleted=" + this.isDeleted() + ")";
    }

    @Generated
    public static class MetricEntryBuilder {
        @Generated
        private String namespace;
        @Generated
        private String flowId;
        @Generated
        private String taskId;
        @Generated
        private String executionId;
        @Generated
        private String taskRunId;
        @Generated
        private String type;
        @Generated
        private String name;
        @Generated
        private Double value;
        @Generated
        private Instant timestamp;
        @Generated
        private Map<String, String> tags;
        @Generated
        private boolean deleted$set;
        @Generated
        private boolean deleted$value;

        @Generated
        MetricEntryBuilder() {
        }

        @Generated
        public MetricEntryBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Generated
        public MetricEntryBuilder flowId(String flowId) {
            this.flowId = flowId;
            return this;
        }

        @Generated
        public MetricEntryBuilder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        @Generated
        public MetricEntryBuilder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        @Generated
        public MetricEntryBuilder taskRunId(String taskRunId) {
            this.taskRunId = taskRunId;
            return this;
        }

        @Generated
        public MetricEntryBuilder type(String type) {
            this.type = type;
            return this;
        }

        @Generated
        public MetricEntryBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public MetricEntryBuilder value(Double value) {
            this.value = value;
            return this;
        }

        @Generated
        public MetricEntryBuilder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Generated
        public MetricEntryBuilder tags(Map<String, String> tags) {
            this.tags = tags;
            return this;
        }

        @Generated
        public MetricEntryBuilder deleted(boolean deleted) {
            this.deleted$value = deleted;
            this.deleted$set = true;
            return this;
        }

        @Generated
        public MetricEntry build() {
            boolean deleted$value = this.deleted$value;
            if (!this.deleted$set) {
                deleted$value = MetricEntry.$default$deleted();
            }
            return new MetricEntry(this.namespace, this.flowId, this.taskId, this.executionId, this.taskRunId, this.type, this.name, this.value, this.timestamp, this.tags, deleted$value);
        }

        @Generated
        public String toString() {
            return "MetricEntry.MetricEntryBuilder(namespace=" + this.namespace + ", flowId=" + this.flowId + ", taskId=" + this.taskId + ", executionId=" + this.executionId + ", taskRunId=" + this.taskRunId + ", type=" + this.type + ", name=" + this.name + ", value=" + this.value + ", timestamp=" + this.timestamp + ", tags=" + this.tags + ", deleted$value=" + this.deleted$value + ")";
        }
    }
}

