/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.flows;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.micronaut.core.annotation.Introspected;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Introspected
public final class State {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(State.class);
    @NotNull
    @JsonInclude
    private final Type current;
    @Valid
    private final List<History> histories;

    public State() {
        this.current = Type.CREATED;
        this.histories = new ArrayList<History>();
        this.histories.add(new History(this.current, Instant.now()));
    }

    public State(Type type) {
        this.current = type;
        this.histories = new ArrayList<History>();
        this.histories.add(new History(this.current, Instant.now()));
    }

    public State(State state, Type type) {
        this.current = type;
        this.histories = state.histories;
        this.histories.add(new History(this.current, Instant.now()));
    }

    public State(Type state, State actual) {
        this.current = state;
        this.histories = new ArrayList<History>(actual.histories);
        this.histories.add(new History(this.current, Instant.now()));
    }

    public static State of(Type state, List<History> histories) {
        State result = new State(state);
        result.histories.removeIf(history -> true);
        result.histories.addAll(histories);
        return result;
    }

    public State withState(Type state) {
        if (this.current == state) {
            log.warn("Can't change state, already " + this.current);
            return this;
        }
        return new State(state, this);
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    public Duration getDuration() {
        return Duration.between(this.histories.get(0).getDate(), this.histories.size() > 1 ? this.histories.get(this.histories.size() - 1).getDate() : Instant.now());
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    public Instant getStartDate() {
        return this.histories.get(0).getDate();
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    public Optional<Instant> getEndDate() {
        if (!this.isTerminated() && !this.isPaused()) {
            return Optional.empty();
        }
        return Optional.of(this.histories.get(this.histories.size() - 1).getDate());
    }

    public String humanDuration() {
        try {
            return DurationFormatUtils.formatDurationHMS((long)this.getDuration().toMillis());
        }
        catch (Throwable e) {
            return this.getDuration().toString();
        }
    }

    public Instant maxDate() {
        if (this.histories.size() == 0) {
            return Instant.now();
        }
        return this.histories.get(this.histories.size() - 1).getDate();
    }

    @JsonIgnore
    public boolean isTerminated() {
        return this.current.isTerminated();
    }

    @JsonIgnore
    public boolean isRunning() {
        return this.current.isRunning();
    }

    @JsonIgnore
    public boolean isCreated() {
        return this.current.isCreated();
    }

    @JsonIgnore
    public static Type[] runningTypes() {
        return (Type[])Arrays.stream(Type.values()).filter(type -> type.isRunning() || type.isCreated()).toArray(Type[]::new);
    }

    @JsonIgnore
    public boolean isFailed() {
        return this.current.isFailed();
    }

    @JsonIgnore
    public boolean isPaused() {
        return this.current.isPaused();
    }

    @JsonIgnore
    public boolean isRestartable() {
        return this.current.isFailed() || this.isPaused();
    }

    @Generated
    public Type getCurrent() {
        return this.current;
    }

    @Generated
    public List<History> getHistories() {
        return this.histories;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof State)) {
            return false;
        }
        State other = (State)o;
        Type this$current = this.getCurrent();
        Type other$current = other.getCurrent();
        if (this$current == null ? other$current != null : !((Object)((Object)this$current)).equals((Object)other$current)) {
            return false;
        }
        List<History> this$histories = this.getHistories();
        List<History> other$histories = other.getHistories();
        return !(this$histories == null ? other$histories != null : !((Object)this$histories).equals(other$histories));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Type $current = this.getCurrent();
        result = result * 59 + ($current == null ? 43 : ((Object)((Object)$current)).hashCode());
        List<History> $histories = this.getHistories();
        result = result * 59 + ($histories == null ? 43 : ((Object)$histories).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "State(current=" + this.getCurrent() + ", histories=" + this.getHistories() + ")";
    }

    @Introspected
    public static enum Type {
        CREATED,
        RUNNING,
        PAUSED,
        RESTARTED,
        KILLING,
        SUCCESS,
        WARNING,
        FAILED,
        KILLED;


        public boolean isTerminated() {
            return this == FAILED || this == WARNING || this == SUCCESS || this == KILLED;
        }

        public boolean isCreated() {
            return this == CREATED || this == RESTARTED;
        }

        public boolean isRunning() {
            return this == RUNNING || this == KILLING;
        }

        public boolean isFailed() {
            return this == FAILED;
        }

        public boolean isPaused() {
            return this == PAUSED;
        }
    }

    public static final class History {
        @NotNull
        private final Type state;
        @NotNull
        private final Instant date;

        @ConstructorProperties(value={"state", "date"})
        @Generated
        public History(Type state, Instant date) {
            this.state = state;
            this.date = date;
        }

        @Generated
        public Type getState() {
            return this.state;
        }

        @Generated
        public Instant getDate() {
            return this.date;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof History)) {
                return false;
            }
            History other = (History)o;
            Type this$state = this.getState();
            Type other$state = other.getState();
            if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
                return false;
            }
            Instant this$date = this.getDate();
            Instant other$date = other.getDate();
            return !(this$date == null ? other$date != null : !((Object)this$date).equals(other$date));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Type $state = this.getState();
            result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
            Instant $date = this.getDate();
            result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "State.History(state=" + this.getState() + ", date=" + this.getDate() + ")";
        }
    }
}

