/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.flows.input;

import io.kestra.core.models.flows.Input;
import io.kestra.core.models.validations.ManualConstraintViolation;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.LocalDate;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import lombok.Generated;

public class DateInput
extends Input<LocalDate> {
    @Schema(title="Minimal value.")
    LocalDate after;
    @Schema(title="Maximal value.")
    LocalDate before;

    @Override
    public void validate(LocalDate input) throws ConstraintViolationException {
        if (this.after != null && input.isBefore(this.after)) {
            throw new ConstraintViolationException("Invalid input '" + input + "', it must be after '" + this.after + "'", Set.of(ManualConstraintViolation.of("Invalid input", this, DateInput.class, this.getName(), input)));
        }
        if (this.before != null && input.isAfter(this.before)) {
            throw new ConstraintViolationException("Invalid input '" + input + "', it must be before '" + this.before + "'", Set.of(ManualConstraintViolation.of("Invalid input", this, DateInput.class, this.getName(), input)));
        }
    }

    @Generated
    protected DateInput(DateInputBuilder<?, ?> b) {
        super((Input.InputBuilder)b);
        this.after = b.after;
        this.before = b.before;
    }

    @Generated
    public static DateInputBuilder<?, ?> builder() {
        return new DateInputBuilderImpl();
    }

    @Generated
    public LocalDate getAfter() {
        return this.after;
    }

    @Generated
    public LocalDate getBefore() {
        return this.before;
    }

    @Generated
    public DateInput() {
    }

    @Generated
    public static abstract class DateInputBuilder<C extends DateInput, B extends DateInputBuilder<C, B>>
    extends Input.InputBuilder<LocalDate, C, B> {
        @Generated
        private LocalDate after;
        @Generated
        private LocalDate before;

        @Generated
        public B after(LocalDate after) {
            this.after = after;
            return (B)this.self();
        }

        @Generated
        public B before(LocalDate before) {
            this.before = before;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "DateInput.DateInputBuilder(super=" + super.toString() + ", after=" + this.after + ", before=" + this.before + ")";
        }
    }

    @Generated
    private static final class DateInputBuilderImpl
    extends DateInputBuilder<DateInput, DateInputBuilderImpl> {
        @Generated
        private DateInputBuilderImpl() {
        }

        @Override
        @Generated
        protected DateInputBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DateInput build() {
            return new DateInput(this);
        }
    }
}

