/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.triggers;

import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.TriggerContext;
import io.micronaut.core.annotation.Nullable;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Arrays;
import javax.validation.constraints.NotNull;
import lombok.Generated;

public class Trigger
extends TriggerContext {
    @NotNull
    private String executionId;
    @Nullable
    private State.Type executionCurrentState;
    @Nullable
    private Instant updatedDate;
    @Nullable
    private ZonedDateTime evaluateRunningDate;

    @Override
    public String uid() {
        return Trigger.uid(this);
    }

    public static String uid(Trigger trigger) {
        return String.join((CharSequence)"_", Arrays.asList(trigger.getNamespace(), trigger.getFlowId(), trigger.getTriggerId()));
    }

    public static String uid(Execution execution) {
        return String.join((CharSequence)"_", Arrays.asList(execution.getNamespace(), execution.getFlowId(), execution.getTrigger().getId()));
    }

    public static String uid(Flow flow, AbstractTrigger abstractTrigger) {
        return String.join((CharSequence)"_", Arrays.asList(flow.getNamespace(), flow.getId(), abstractTrigger.getId()));
    }

    public static Trigger of(Flow flow, AbstractTrigger abstractTrigger) {
        return ((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)Trigger.builder().namespace(flow.getNamespace())).flowId(flow.getId())).flowRevision(flow.getRevision())).triggerId(abstractTrigger.getId())).build();
    }

    public static Trigger of(TriggerContext triggerContext) {
        return ((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)Trigger.builder().namespace(triggerContext.getNamespace())).flowId(triggerContext.getFlowId())).flowRevision(triggerContext.getFlowRevision())).triggerId(triggerContext.getTriggerId())).date(triggerContext.getDate())).build();
    }

    public static Trigger of(TriggerContext triggerContext, Execution execution) {
        return ((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)Trigger.builder().namespace(triggerContext.getNamespace())).flowId(triggerContext.getFlowId())).flowRevision(triggerContext.getFlowRevision())).triggerId(triggerContext.getTriggerId())).date(triggerContext.getDate())).executionId(execution.getId())).updatedDate(Instant.now())).build();
    }

    public static Trigger of(Execution execution, ZonedDateTime date) {
        return ((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)Trigger.builder().namespace(execution.getNamespace())).flowId(execution.getFlowId())).flowRevision(execution.getFlowRevision())).triggerId(execution.getTrigger().getId())).date(date)).executionId(execution.getId())).executionCurrentState(execution.getState().getCurrent())).updatedDate(Instant.now())).build();
    }

    public static Trigger of(TriggerContext triggerContext, ZonedDateTime evaluateRunningDate) {
        return ((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)Trigger.builder().namespace(triggerContext.getNamespace())).flowId(triggerContext.getFlowId())).flowRevision(triggerContext.getFlowRevision())).triggerId(triggerContext.getTriggerId())).date(triggerContext.getDate())).evaluateRunningDate(evaluateRunningDate)).updatedDate(Instant.now())).build();
    }

    public Trigger resetExecution() {
        return ((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)Trigger.builder().namespace(this.getNamespace())).flowId(this.getFlowId())).flowRevision(this.getFlowRevision())).triggerId(this.getTriggerId())).date(this.getDate())).build();
    }

    @Generated
    protected Trigger(TriggerBuilder<?, ?> b) {
        super((TriggerContext.TriggerContextBuilder)b);
        this.executionId = b.executionId;
        this.executionCurrentState = b.executionCurrentState;
        this.updatedDate = b.updatedDate;
        this.evaluateRunningDate = b.evaluateRunningDate;
    }

    @Generated
    public static TriggerBuilder<?, ?> builder() {
        return new TriggerBuilderImpl();
    }

    @Generated
    public TriggerBuilder<?, ?> toBuilder() {
        return new TriggerBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public String toString() {
        return "Trigger(super=" + super.toString() + ", executionId=" + this.getExecutionId() + ", executionCurrentState=" + this.getExecutionCurrentState() + ", updatedDate=" + this.getUpdatedDate() + ", evaluateRunningDate=" + this.getEvaluateRunningDate() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Trigger)) {
            return false;
        }
        Trigger other = (Trigger)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$executionId = this.getExecutionId();
        String other$executionId = other.getExecutionId();
        if (this$executionId == null ? other$executionId != null : !this$executionId.equals(other$executionId)) {
            return false;
        }
        State.Type this$executionCurrentState = this.getExecutionCurrentState();
        State.Type other$executionCurrentState = other.getExecutionCurrentState();
        if (this$executionCurrentState == null ? other$executionCurrentState != null : !((Object)((Object)this$executionCurrentState)).equals((Object)other$executionCurrentState)) {
            return false;
        }
        Instant this$updatedDate = this.getUpdatedDate();
        Instant other$updatedDate = other.getUpdatedDate();
        if (this$updatedDate == null ? other$updatedDate != null : !((Object)this$updatedDate).equals(other$updatedDate)) {
            return false;
        }
        ZonedDateTime this$evaluateRunningDate = this.getEvaluateRunningDate();
        ZonedDateTime other$evaluateRunningDate = other.getEvaluateRunningDate();
        return !(this$evaluateRunningDate == null ? other$evaluateRunningDate != null : !((Object)this$evaluateRunningDate).equals(other$evaluateRunningDate));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Trigger;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $executionId = this.getExecutionId();
        result = result * 59 + ($executionId == null ? 43 : $executionId.hashCode());
        State.Type $executionCurrentState = this.getExecutionCurrentState();
        result = result * 59 + ($executionCurrentState == null ? 43 : ((Object)((Object)$executionCurrentState)).hashCode());
        Instant $updatedDate = this.getUpdatedDate();
        result = result * 59 + ($updatedDate == null ? 43 : ((Object)$updatedDate).hashCode());
        ZonedDateTime $evaluateRunningDate = this.getEvaluateRunningDate();
        result = result * 59 + ($evaluateRunningDate == null ? 43 : ((Object)$evaluateRunningDate).hashCode());
        return result;
    }

    @Generated
    public String getExecutionId() {
        return this.executionId;
    }

    @Generated
    public State.Type getExecutionCurrentState() {
        return this.executionCurrentState;
    }

    @Generated
    public Instant getUpdatedDate() {
        return this.updatedDate;
    }

    @Generated
    public ZonedDateTime getEvaluateRunningDate() {
        return this.evaluateRunningDate;
    }

    @Generated
    public Trigger() {
    }

    @Generated
    public static abstract class TriggerBuilder<C extends Trigger, B extends TriggerBuilder<C, B>>
    extends TriggerContext.TriggerContextBuilder<C, B> {
        @Generated
        private String executionId;
        @Generated
        private State.Type executionCurrentState;
        @Generated
        private Instant updatedDate;
        @Generated
        private ZonedDateTime evaluateRunningDate;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            TriggerBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Trigger instance, TriggerBuilder<?, ?> b) {
            b.executionId(instance.executionId);
            b.executionCurrentState(instance.executionCurrentState);
            b.updatedDate(instance.updatedDate);
            b.evaluateRunningDate(instance.evaluateRunningDate);
        }

        @Generated
        public B executionId(String executionId) {
            this.executionId = executionId;
            return (B)this.self();
        }

        @Generated
        public B executionCurrentState(State.Type executionCurrentState) {
            this.executionCurrentState = executionCurrentState;
            return (B)this.self();
        }

        @Generated
        public B updatedDate(Instant updatedDate) {
            this.updatedDate = updatedDate;
            return (B)this.self();
        }

        @Generated
        public B evaluateRunningDate(ZonedDateTime evaluateRunningDate) {
            this.evaluateRunningDate = evaluateRunningDate;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Trigger.TriggerBuilder(super=" + super.toString() + ", executionId=" + this.executionId + ", executionCurrentState=" + this.executionCurrentState + ", updatedDate=" + this.updatedDate + ", evaluateRunningDate=" + this.evaluateRunningDate + ")";
        }
    }

    @Generated
    private static final class TriggerBuilderImpl
    extends TriggerBuilder<Trigger, TriggerBuilderImpl> {
        @Generated
        private TriggerBuilderImpl() {
        }

        @Override
        @Generated
        protected TriggerBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Trigger build() {
            return new Trigger(this);
        }
    }
}

