/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.triggers.types;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.ExecutionTrigger;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.TriggerOutput;
import io.kestra.core.runners.RunContext;
import io.kestra.core.utils.IdUtils;
import io.micronaut.core.annotation.Nullable;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.slf4j.Logger;

@Schema(title="Kestra is able to trigger flow after another one. This allows chaining flow without need to update the base flows.\nWith that, you can break responsibility between different flow to different teams.", description="::alert{type=\"warning\"}\nIf you don't provide any conditions, the flow will be triggered for **EVERY execution** of **EVERY flow** on your instance.\n::")
@Plugin(examples={@Example(title="This flow will be triggered after each successfully execution of flow `io.kestra.tests.trigger-flow` and forward the `uri` of `my-task` taskId outputs.", full=true, code={"id: trigger-flow-listener\nnamespace: io.kestra.tests\n\ninputs:\n  - name: from-parent\n    type: STRING\n\ntasks:\n  - id: only-no-input\n    type: io.kestra.core.tasks.debugs.Return\n    format: \"v1: {{trigger.executionId}}\"\n\ntriggers:\n  - id: listen-flow\n    type: io.kestra.core.models.triggers.types.Flow\n    inputs:\n      from-parent: '{{ outputs.myTask.uri }}'\n    conditions:\n      - type: io.kestra.core.models.conditions.types.ExecutionFlowCondition\n        namespace: io.kestra.tests\n        flowId: trigger-flow\n      - type: io.kestra.core.models.conditions.types.ExecutionStatusCondition\n        in:\n          - SUCCESS"})})
public class Flow
extends AbstractTrigger
implements TriggerOutput<Output> {
    @Nullable
    @Schema(title="Fill input of this flow based on output of current flow, allowing to pass data or file on the triggered flow", description="::alert{type=\"warning\"}\nIf you provide invalid input, the flow will not be created! Since there is no task started, you can't log any reason visible on the execution ui.\nSo you will need to go to Logs tabs on the ui to understand the error\n::")
    @PluginProperty
    private Map<String, Object> inputs;

    public Optional<Execution> evaluate(RunContext runContext, io.kestra.core.models.flows.Flow flow, Execution current) {
        Logger logger = runContext.logger();
        Execution.ExecutionBuilder builder = Execution.builder().id(IdUtils.create()).namespace(flow.getNamespace()).flowId(flow.getId()).flowRevision(flow.getRevision()).labels(flow.getLabels()).state(new State()).trigger(ExecutionTrigger.of((AbstractTrigger)this, Output.builder().executionId(current.getId()).namespace(current.getNamespace()).flowId(current.getFlowId()).flowRevision(current.getFlowRevision()).state(current.getState().getCurrent()).build()));
        try {
            builder.inputs(runContext.render(this.inputs == null ? new HashMap() : this.inputs));
            return Optional.of(builder.build());
        }
        catch (Exception e) {
            logger.warn("Failed to trigger flow {}.{} for trigger {}, invalid inputs", new Object[]{flow.getNamespace(), flow.getId(), this.getId(), e});
            return Optional.empty();
        }
    }

    @Generated
    protected Flow(FlowBuilder<?, ?> b) {
        super(b);
        this.inputs = b.inputs;
    }

    @Generated
    public static FlowBuilder<?, ?> builder() {
        return new FlowBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Flow(super=" + super.toString() + ", inputs=" + this.getInputs() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Flow)) {
            return false;
        }
        Flow other = (Flow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<String, Object> this$inputs = this.getInputs();
        Map<String, Object> other$inputs = other.getInputs();
        return !(this$inputs == null ? other$inputs != null : !((Object)this$inputs).equals(other$inputs));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Flow;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map<String, Object> $inputs = this.getInputs();
        result = result * 59 + ($inputs == null ? 43 : ((Object)$inputs).hashCode());
        return result;
    }

    @Generated
    public Map<String, Object> getInputs() {
        return this.inputs;
    }

    @Generated
    public Flow() {
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The execution id that trigger the current flow")
        @NotNull
        private String executionId;
        @Schema(title="The execution state")
        @NotNull
        private State.Type state;
        @Schema(title="The namespace of the flow that trigger the current flow")
        @NotNull
        private String namespace;
        @Schema(title="The execution id that trigger the current flow")
        @NotNull
        private String flowId;
        @Schema(title="The flow revision that trigger the current flow")
        @NotNull
        private Integer flowRevision;

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public String toString() {
            return "Flow.Output(executionId=" + this.getExecutionId() + ", state=" + this.getState() + ", namespace=" + this.getNamespace() + ", flowId=" + this.getFlowId() + ", flowRevision=" + this.getFlowRevision() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Output)) {
                return false;
            }
            Output other = (Output)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$flowRevision = this.getFlowRevision();
            Integer other$flowRevision = other.getFlowRevision();
            if (this$flowRevision == null ? other$flowRevision != null : !((Object)this$flowRevision).equals(other$flowRevision)) {
                return false;
            }
            String this$executionId = this.getExecutionId();
            String other$executionId = other.getExecutionId();
            if (this$executionId == null ? other$executionId != null : !this$executionId.equals(other$executionId)) {
                return false;
            }
            State.Type this$state = this.getState();
            State.Type other$state = other.getState();
            if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
                return false;
            }
            String this$namespace = this.getNamespace();
            String other$namespace = other.getNamespace();
            if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
                return false;
            }
            String this$flowId = this.getFlowId();
            String other$flowId = other.getFlowId();
            return !(this$flowId == null ? other$flowId != null : !this$flowId.equals(other$flowId));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Output;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $flowRevision = this.getFlowRevision();
            result = result * 59 + ($flowRevision == null ? 43 : ((Object)$flowRevision).hashCode());
            String $executionId = this.getExecutionId();
            result = result * 59 + ($executionId == null ? 43 : $executionId.hashCode());
            State.Type $state = this.getState();
            result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
            String $namespace = this.getNamespace();
            result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
            String $flowId = this.getFlowId();
            result = result * 59 + ($flowId == null ? 43 : $flowId.hashCode());
            return result;
        }

        @Generated
        public String getExecutionId() {
            return this.executionId;
        }

        @Generated
        public State.Type getState() {
            return this.state;
        }

        @Generated
        public String getNamespace() {
            return this.namespace;
        }

        @Generated
        public String getFlowId() {
            return this.flowId;
        }

        @Generated
        public Integer getFlowRevision() {
            return this.flowRevision;
        }

        @Generated
        public Output() {
        }

        @ConstructorProperties(value={"executionId", "state", "namespace", "flowId", "flowRevision"})
        @Generated
        public Output(String executionId, State.Type state, String namespace, String flowId, Integer flowRevision) {
            this.executionId = executionId;
            this.state = state;
            this.namespace = namespace;
            this.flowId = flowId;
            this.flowRevision = flowRevision;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private String executionId;
            @Generated
            private State.Type state;
            @Generated
            private String namespace;
            @Generated
            private String flowId;
            @Generated
            private Integer flowRevision;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder executionId(String executionId) {
                this.executionId = executionId;
                return this;
            }

            @Generated
            public OutputBuilder state(State.Type state) {
                this.state = state;
                return this;
            }

            @Generated
            public OutputBuilder namespace(String namespace) {
                this.namespace = namespace;
                return this;
            }

            @Generated
            public OutputBuilder flowId(String flowId) {
                this.flowId = flowId;
                return this;
            }

            @Generated
            public OutputBuilder flowRevision(Integer flowRevision) {
                this.flowRevision = flowRevision;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.executionId, this.state, this.namespace, this.flowId, this.flowRevision);
            }

            @Generated
            public String toString() {
                return "Flow.Output.OutputBuilder(executionId=" + this.executionId + ", state=" + this.state + ", namespace=" + this.namespace + ", flowId=" + this.flowId + ", flowRevision=" + this.flowRevision + ")";
            }
        }
    }

    @Generated
    public static abstract class FlowBuilder<C extends Flow, B extends FlowBuilder<C, B>>
    extends AbstractTrigger.AbstractTriggerBuilder<C, B> {
        @Generated
        private Map<String, Object> inputs;

        @Generated
        public B inputs(Map<String, Object> inputs) {
            this.inputs = inputs;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Flow.FlowBuilder(super=" + super.toString() + ", inputs=" + this.inputs + ")";
        }
    }

    @Generated
    private static final class FlowBuilderImpl
    extends FlowBuilder<Flow, FlowBuilderImpl> {
        @Generated
        private FlowBuilderImpl() {
        }

        @Override
        @Generated
        protected FlowBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Flow build() {
            return new Flow(this);
        }
    }
}

