/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.Hashing;
import io.kestra.core.metrics.MetricRegistry;
import io.kestra.core.models.Label;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.ExecutionKilled;
import io.kestra.core.models.executions.MetricEntry;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.executions.TaskRunAttempt;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.tasks.Output;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.tasks.retrys.AbstractRetry;
import io.kestra.core.models.triggers.PollingTriggerInterface;
import io.kestra.core.queues.QueueException;
import io.kestra.core.queues.QueueInterface;
import io.kestra.core.queues.WorkerJobQueueInterface;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.WorkerTask;
import io.kestra.core.runners.WorkerTaskResult;
import io.kestra.core.runners.WorkerTrigger;
import io.kestra.core.runners.WorkerTriggerResult;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.services.WorkerGroupService;
import io.kestra.core.tasks.flows.WorkingDirectory;
import io.kestra.core.utils.Await;
import io.kestra.core.utils.ExecutorsUtils;
import io.micronaut.context.ApplicationContext;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.io.IOException;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import net.jodah.failsafe.Timeout;
import net.jodah.failsafe.TimeoutExceededException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Introspected
public class Worker
implements Runnable,
AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Worker.class);
    private static final ObjectMapper MAPPER = JacksonMapper.ofJson();
    private final ApplicationContext applicationContext;
    private final WorkerJobQueueInterface workerJobQueue;
    private final QueueInterface<WorkerTaskResult> workerTaskResultQueue;
    private final QueueInterface<WorkerTriggerResult> workerTriggerResultQueue;
    private final QueueInterface<ExecutionKilled> executionKilledQueue;
    private final QueueInterface<MetricEntry> metricEntryQueue;
    private final MetricRegistry metricRegistry;
    private final Set<String> killedExecution = ConcurrentHashMap.newKeySet();
    final ExecutorService executors;
    private final Map<Long, AtomicInteger> metricRunningCount = new ConcurrentHashMap<Long, AtomicInteger>();
    private final Map<String, AtomicInteger> evaluateTriggerRunningCount = new ConcurrentHashMap<String, AtomicInteger>();
    private final List<WorkerThread> workerThreadReferences = new ArrayList<WorkerThread>();
    private final String workerGroup;

    public Worker(ApplicationContext applicationContext, int thread, String workerGroupKey) {
        this.applicationContext = applicationContext;
        this.workerJobQueue = (WorkerJobQueueInterface)applicationContext.getBean(WorkerJobQueueInterface.class);
        this.workerTaskResultQueue = (QueueInterface)applicationContext.getBean(QueueInterface.class, Qualifiers.byName((String)"workerTaskResultQueue"));
        this.workerTriggerResultQueue = (QueueInterface)applicationContext.getBean(QueueInterface.class, Qualifiers.byName((String)"workerTriggerResultQueue"));
        this.executionKilledQueue = (QueueInterface)applicationContext.getBean(QueueInterface.class, Qualifiers.byName((String)"executionKilledQueue"));
        this.metricEntryQueue = (QueueInterface)applicationContext.getBean(QueueInterface.class, Qualifiers.byName((String)"workerTaskMetricQueue"));
        this.metricRegistry = (MetricRegistry)applicationContext.getBean(MetricRegistry.class);
        ExecutorsUtils executorsUtils = (ExecutorsUtils)applicationContext.getBean(ExecutorsUtils.class);
        this.executors = executorsUtils.maxCachedThreadPool(thread, "worker");
        WorkerGroupService workerGroupService = (WorkerGroupService)applicationContext.getBean(WorkerGroupService.class);
        this.workerGroup = workerGroupService.resolveGroupFromKey(workerGroupKey);
    }

    @Override
    public void run() {
        this.executionKilledQueue.receive(executionKilled -> {
            if (executionKilled != null) {
                this.killedExecution.add(executionKilled.getExecutionId());
                Worker worker = this;
                synchronized (worker) {
                    this.workerThreadReferences.stream().filter(workerThread -> executionKilled.getExecutionId().equals(workerThread.getWorkerTask().getTaskRun().getExecutionId())).forEach(WorkerThread::kill);
                }
            }
        });
        this.workerJobQueue.receive(this.workerGroup, Worker.class, workerTask -> this.executors.execute(() -> {
            if (workerTask instanceof WorkerTask) {
                WorkerTask task = (WorkerTask)workerTask;
                this.handleTask(task);
            } else if (workerTask instanceof WorkerTrigger) {
                WorkerTrigger trigger = (WorkerTrigger)workerTask;
                this.handleTrigger(trigger);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTask(WorkerTask workerTask) {
        if (workerTask.getTask() instanceof RunnableTask) {
            this.run(workerTask, true);
        } else {
            Task task = workerTask.getTask();
            if (task instanceof WorkingDirectory) {
                WorkingDirectory workingDirectory = (WorkingDirectory)task;
                RunContext runContext = workerTask.getRunContext().forWorker(this.applicationContext, workerTask);
                try {
                    workingDirectory.preExecuteTasks(runContext, workerTask.getTaskRun());
                    for (Task currentTask : workingDirectory.getTasks()) {
                        WorkerTask currentWorkerTask = workingDirectory.workerTask(workerTask.getTaskRun(), currentTask, runContext);
                        WorkerTaskResult workerTaskResult = this.run(currentWorkerTask, false);
                        if (workerTaskResult.getTaskRun().getState().isFailed()) break;
                        runContext = runContext.updateVariables(workerTaskResult, workerTask.getTaskRun());
                    }
                    workingDirectory.postExecuteTasks(runContext, workerTask.getTaskRun());
                }
                finally {
                    runContext.cleanup();
                }
            } else {
                throw new RuntimeException("Unable to process the task '" + workerTask.getTask().getId() + "' as it's not a runnable task");
            }
        }
    }

    private void handleTrigger(WorkerTrigger workerTrigger) {
        this.metricRegistry.timer("worker.evaluate.trigger.duration", this.metricRegistry.tags(workerTrigger.getTriggerContext(), this.workerGroup)).record(() -> {
            this.evaluateTriggerRunningCount.computeIfAbsent(workerTrigger.getTriggerContext().uid(), s -> this.metricRegistry.gauge("worker.evaluate.trigger.running.count", new AtomicInteger(0), this.metricRegistry.tags(workerTrigger.getTriggerContext(), this.workerGroup)));
            this.evaluateTriggerRunningCount.get(workerTrigger.getTriggerContext().uid()).addAndGet(1);
            try {
                List<Label> flowLabels;
                PollingTriggerInterface pollingTrigger = (PollingTriggerInterface)((Object)workerTrigger.getTrigger());
                RunContext runContext = workerTrigger.getConditionContext().getRunContext().forWorker(this.applicationContext, workerTrigger);
                Optional<Execution> evaluate = pollingTrigger.evaluate(workerTrigger.getConditionContext().withRunContext(runContext), workerTrigger.getTriggerContext());
                if (log.isDebugEnabled()) {
                    log.debug("[namespace: {}] [flow: {}] [trigger: {}] [type: {}] {}", new Object[]{workerTrigger.getTriggerContext().getNamespace(), workerTrigger.getTriggerContext().getFlowId(), workerTrigger.getTrigger().getId(), workerTrigger.getTrigger().getType(), evaluate.map(execution -> "New execution '" + execution.getId() + "'").orElse("Empty evaluation")});
                }
                if ((flowLabels = workerTrigger.getConditionContext().getFlow().getLabels()) != null) {
                    evaluate = evaluate.map(execution -> {
                        ArrayList<Label> executionLabels = execution.getLabels() != null ? execution.getLabels() : new ArrayList<Label>();
                        executionLabels.addAll(flowLabels);
                        return execution.withLabels(executionLabels);
                    });
                }
                workerTrigger.getConditionContext().getRunContext().cleanup();
                this.workerTriggerResultQueue.emit(WorkerTriggerResult.builder().execution(evaluate).triggerContext(workerTrigger.getTriggerContext()).trigger(workerTrigger.getTrigger()).build());
            }
            catch (Exception e) {
                this.logError(workerTrigger, e);
                this.workerTriggerResultQueue.emit(WorkerTriggerResult.builder().success(false).triggerContext(workerTrigger.getTriggerContext()).trigger(workerTrigger.getTrigger()).build());
            }
            this.evaluateTriggerRunningCount.get(workerTrigger.getTriggerContext().uid()).addAndGet(-1);
        });
    }

    private static ZonedDateTime now() {
        return ZonedDateTime.now().truncatedTo(ChronoUnit.SECONDS);
    }

    private WorkerTask cleanUpTransient(WorkerTask workerTask) {
        try {
            return (WorkerTask)MAPPER.readValue(MAPPER.writeValueAsString((Object)workerTask), WorkerTask.class);
        }
        catch (JsonProcessingException e) {
            log.warn("Unable to cleanup transient", (Throwable)e);
            return workerTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WorkerTaskResult run(WorkerTask workerTask, Boolean cleanUp) throws QueueException {
        TaskRunAttempt lastAttempt;
        this.metricRegistry.counter("worker.started.count", this.metricRegistry.tags(workerTask, this.workerGroup, new String[0])).increment();
        if (workerTask.getTaskRun().getState().getCurrent() == State.Type.CREATED) {
            this.metricRegistry.timer("worker.queued.duration", this.metricRegistry.tags(workerTask, this.workerGroup, new String[0])).record(Duration.between(workerTask.getTaskRun().getState().getStartDate(), Worker.now()));
        }
        workerTask.logger().info("[namespace: {}] [flow: {}] [task: {}] [execution: {}] [taskrun: {}] [value: {}] Type {} started", new Object[]{workerTask.getTaskRun().getNamespace(), workerTask.getTaskRun().getFlowId(), workerTask.getTaskRun().getTaskId(), workerTask.getTaskRun().getExecutionId(), workerTask.getTaskRun().getId(), workerTask.getTaskRun().getValue(), workerTask.getTask().getClass().getSimpleName()});
        if (workerTask.logger().isDebugEnabled()) {
            workerTask.logger().debug("Variables\n{}", (Object)JacksonMapper.log(workerTask.getRunContext().getVariables()));
        }
        workerTask = workerTask.withTaskRun(workerTask.getTaskRun().withState(State.Type.RUNNING));
        this.workerTaskResultQueue.emit(new WorkerTaskResult(workerTask));
        if (this.killedExecution.contains(workerTask.getTaskRun().getExecutionId())) {
            workerTask = workerTask.withTaskRun(workerTask.getTaskRun().withState(State.Type.KILLED));
            WorkerTaskResult workerTaskResult = new WorkerTaskResult(workerTask);
            this.workerTaskResultQueue.emit(workerTaskResult);
            this.logTerminated(workerTask);
            return workerTaskResult;
        }
        AtomicReference<WorkerTask> current = new AtomicReference<WorkerTask>(workerTask);
        WorkerTask finalWorkerTask = (WorkerTask)Failsafe.with((Policy)((RetryPolicy)AbstractRetry.retryPolicy(workerTask.getTask().getRetry()).handleResultIf(result -> result.getTaskRun().lastAttempt() != null && Objects.requireNonNull(result.getTaskRun().lastAttempt()).getState().getCurrent() == State.Type.FAILED)).onRetry(e -> {
            WorkerTask lastResult = (WorkerTask)e.getLastResult();
            if (cleanUp.booleanValue()) {
                lastResult.getRunContext().cleanup();
            }
            lastResult = this.cleanUpTransient(lastResult);
            current.set(lastResult);
            this.metricRegistry.counter("worker.retryed.count", this.metricRegistry.tags((WorkerTask)current.get(), "attempt_count", String.valueOf(e.getAttemptCount()), "worker_group", this.workerGroup)).increment();
            this.workerTaskResultQueue.emit(new WorkerTaskResult(lastResult));
        }), (Policy[])new RetryPolicy[0]).get(() -> this.runAttempt((WorkerTask)current.get()));
        List<WorkerTaskResult> dynamicWorkerResults = finalWorkerTask.getRunContext().dynamicWorkerResults();
        if (cleanUp.booleanValue()) {
            finalWorkerTask.getRunContext().cleanup();
        }
        if ((lastAttempt = (finalWorkerTask = this.cleanUpTransient(finalWorkerTask)).getTaskRun().lastAttempt()) == null) {
            throw new IllegalStateException("Can find lastAttempt on taskRun '" + finalWorkerTask.getTaskRun().toString(true) + "'");
        }
        State.Type state = lastAttempt.getState().getCurrent();
        if (workerTask.getTask().getRetry() != null && workerTask.getTask().getRetry().getWarningOnRetry().booleanValue() && finalWorkerTask.getTaskRun().attemptNumber() > 1 && state == State.Type.SUCCESS) {
            state = State.Type.WARNING;
        }
        finalWorkerTask = finalWorkerTask.withTaskRun(finalWorkerTask.getTaskRun().withState(state));
        try {
            WorkerTaskResult workerTaskResult = new WorkerTaskResult(finalWorkerTask, dynamicWorkerResults);
            this.workerTaskResultQueue.emit(workerTaskResult);
            WorkerTaskResult workerTaskResult2 = workerTaskResult;
            return workerTaskResult2;
        }
        catch (QueueException e2) {
            finalWorkerTask = workerTask.withTaskRun(workerTask.getTaskRun().withState(State.Type.FAILED));
            WorkerTaskResult workerTaskResult = new WorkerTaskResult(finalWorkerTask, dynamicWorkerResults);
            this.workerTaskResultQueue.emit(workerTaskResult);
            WorkerTaskResult workerTaskResult3 = workerTaskResult;
            return workerTaskResult3;
        }
        finally {
            this.logTerminated(finalWorkerTask);
        }
    }

    private void logTerminated(WorkerTask workerTask) {
        this.metricRegistry.counter("worker.ended.count", this.metricRegistry.tags(workerTask, this.workerGroup, new String[0])).increment();
        this.metricRegistry.timer("worker.ended.duration", this.metricRegistry.tags(workerTask, this.workerGroup, new String[0])).record(workerTask.getTaskRun().getState().getDuration());
        workerTask.logger().info("[namespace: {}] [flow: {}] [task: {}] [execution: {}] [taskrun: {}] [value: {}] Type {} with state {} completed in {}", new Object[]{workerTask.getTaskRun().getNamespace(), workerTask.getTaskRun().getFlowId(), workerTask.getTaskRun().getTaskId(), workerTask.getTaskRun().getExecutionId(), workerTask.getTaskRun().getId(), workerTask.getTaskRun().getValue(), workerTask.getTask().getClass().getSimpleName(), workerTask.getTaskRun().getState().getCurrent(), workerTask.getTaskRun().getState().humanDuration()});
    }

    private void logError(WorkerTrigger workerTrigger, Throwable e) {
        Logger logger = workerTrigger.getConditionContext().getRunContext().logger();
        logger.warn("[namespace: {}] [flow: {}] [trigger: {}] [date: {}] Evaluate Failed with error '{}'", new Object[]{workerTrigger.getTriggerContext().getNamespace(), workerTrigger.getTriggerContext().getFlowId(), workerTrigger.getTriggerContext().getTriggerId(), workerTrigger.getTriggerContext().getDate(), e.getMessage(), e});
        if (logger.isTraceEnabled()) {
            logger.trace(Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WorkerTask runAttempt(WorkerTask workerTask) {
        State.Type state;
        RunContext runContext = workerTask.getRunContext().forWorker(this.applicationContext, workerTask);
        Logger logger = runContext.logger();
        if (!(workerTask.getTask() instanceof RunnableTask)) {
            TaskRunAttempt attempt = TaskRunAttempt.builder().state(new State().withState(State.Type.FAILED)).build();
            List<TaskRunAttempt> attempts = this.addAttempt(workerTask, attempt);
            TaskRun taskRun = workerTask.getTaskRun().withAttempts(attempts);
            logger.error("Unable to execute the task '" + workerTask.getTask().getId() + "': only runnable tasks can be executed by the worker but the task is of type " + workerTask.getTask().getClass());
            return workerTask.withTaskRun(taskRun);
        }
        RunnableTask task = (RunnableTask)((Object)workerTask.getTask());
        TaskRunAttempt.TaskRunAttemptBuilder builder = TaskRunAttempt.builder().state(new State().withState(State.Type.RUNNING));
        AtomicInteger metricRunningCount = this.getMetricRunningCount(workerTask);
        metricRunningCount.incrementAndGet();
        WorkerThread workerThread = new WorkerThread(logger, workerTask, task, runContext, this.metricRegistry, this.workerGroup);
        this.workerTaskResultQueue.emit(new WorkerTaskResult(workerTask.withTaskRun(workerTask.getTaskRun().withAttempts(this.addAttempt(workerTask, builder.build())))));
        try {
            Worker worker = this;
            synchronized (worker) {
                this.workerThreadReferences.add(workerThread);
            }
            workerThread.start();
            workerThread.join();
            state = workerThread.getTaskState();
        }
        catch (InterruptedException e) {
            logger.error("Failed to join WorkerThread {}", (Object)e.getMessage(), (Object)e);
            state = State.Type.FAILED;
        }
        finally {
            Worker e = this;
            synchronized (e) {
                this.workerThreadReferences.remove(workerThread);
            }
        }
        metricRunningCount.decrementAndGet();
        TaskRunAttempt taskRunAttempt = builder.build().withState(state);
        if (workerThread.getTaskOutput() != null && log.isDebugEnabled()) {
            log.debug("Outputs\n{}", (Object)JacksonMapper.log(workerThread.getTaskOutput()));
        }
        if (runContext.metrics().size() > 0 && log.isTraceEnabled()) {
            log.trace("Metrics\n{}", (Object)JacksonMapper.log(runContext.metrics()));
        }
        runContext.metrics().forEach(metric -> this.metricEntryQueue.emit(MetricEntry.of(workerTask.getTaskRun(), metric)));
        List<TaskRunAttempt> attempts = this.addAttempt(workerTask, taskRunAttempt);
        TaskRun taskRun = workerTask.getTaskRun().withAttempts(attempts);
        try {
            taskRun = taskRun.withOutputs(workerThread.getTaskOutput() != null ? workerThread.getTaskOutput().toMap() : ImmutableMap.of());
        }
        catch (Exception e) {
            logger.warn("Unable to save output on taskRun '{}'", (Object)taskRun, (Object)e);
        }
        return workerTask.withTaskRun(taskRun);
    }

    private List<TaskRunAttempt> addAttempt(WorkerTask workerTask, TaskRunAttempt taskRunAttempt) {
        return ImmutableList.builder().addAll(workerTask.getTaskRun().getAttempts() == null ? new ArrayList() : workerTask.getTaskRun().getAttempts()).add((Object)taskRunAttempt).build();
    }

    public AtomicInteger getMetricRunningCount(WorkerTask workerTask) {
        Object[] tags = this.metricRegistry.tags(workerTask, this.workerGroup, new String[0]);
        Arrays.sort(tags);
        long index = Hashing.goodFastHash((int)64).hashString((CharSequence)String.join((CharSequence)"-", (CharSequence[])tags), Charsets.UTF_8).asLong();
        return this.metricRunningCount.computeIfAbsent(index, l -> this.metricRegistry.gauge("worker.running.count", new AtomicInteger(0), this.metricRegistry.tags(workerTask, this.workerGroup, new String[0])));
    }

    @Override
    public void close() throws Exception {
        this.workerJobQueue.pause();
        this.executionKilledQueue.pause();
        new Thread(() -> {
            try {
                this.executors.shutdown();
                this.executors.awaitTermination(5L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                log.error("Failed to shutdown workers executors", (Throwable)e);
            }
        }, "worker-shutdown").start();
        Await.until(() -> {
            if (this.executors.isTerminated() && this.workerThreadReferences.size() == 0) {
                log.info("No more workers busy, shutting down!");
                try {
                    this.workerTaskResultQueue.close();
                }
                catch (IOException e) {
                    log.error("Failed to close workerTaskResultQueue", (Throwable)e);
                }
                return true;
            }
            log.warn("Waiting worker with still {} thread(s) running, waiting!", (Object)this.workerThreadReferences.size());
            return false;
        }, Duration.ofSeconds(1L));
        this.workerJobQueue.close();
        this.executionKilledQueue.close();
        this.workerTaskResultQueue.close();
        this.metricEntryQueue.close();
    }

    public List<WorkerTask> getWorkerThreadTasks() {
        return this.workerThreadReferences.stream().map(thread -> thread.workerTask).toList();
    }

    @Generated
    public Map<Long, AtomicInteger> getMetricRunningCount() {
        return this.metricRunningCount;
    }

    @Generated
    public String getWorkerGroup() {
        return this.workerGroup;
    }

    public static class WorkerThread
    extends Thread {
        @Generated
        private final Object $lock = new Object[0];
        Logger logger;
        WorkerTask workerTask;
        RunnableTask<?> task;
        RunContext runContext;
        MetricRegistry metricRegistry;
        String workerGroup;
        Output taskOutput;
        State.Type taskState;
        boolean killed = false;

        public WorkerThread(Logger logger, WorkerTask workerTask, RunnableTask<?> task, RunContext runContext, MetricRegistry metricRegistry, String workerGroup) {
            super("WorkerThread");
            this.setUncaughtExceptionHandler(this::exceptionHandler);
            this.logger = logger;
            this.workerTask = workerTask;
            this.task = task;
            this.runContext = runContext;
            this.metricRegistry = metricRegistry;
            this.workerGroup = workerGroup;
        }

        @Override
        public void run() {
            Thread.currentThread().setContextClassLoader(this.task.getClass().getClassLoader());
            try {
                if (this.workerTask.getTask().getTimeout() != null) {
                    Failsafe.with((Policy)((Timeout)Timeout.of((Duration)this.workerTask.getTask().getTimeout()).withInterrupt(true).onFailure(event -> this.metricRegistry.counter("worker.timeout.count", this.metricRegistry.tags(this.workerTask, "attempt_count", String.valueOf(event.getAttemptCount()), "worker_group", this.workerGroup)).increment())), (Policy[])new Timeout[0]).run(() -> {
                        this.taskOutput = this.task.run(this.runContext);
                    });
                } else {
                    this.taskOutput = this.task.run(this.runContext);
                }
                this.taskState = State.Type.SUCCESS;
                if (this.taskOutput != null && this.taskOutput.finalState().isPresent()) {
                    this.taskState = this.taskOutput.finalState().get();
                }
            }
            catch (TimeoutExceededException e) {
                this.exceptionHandler(this, new io.kestra.core.exceptions.TimeoutExceededException(this.workerTask.getTask().getTimeout(), (Exception)((Object)e)));
            }
            catch (Exception e) {
                this.exceptionHandler(this, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void kill() {
            Object object = this.$lock;
            synchronized (object) {
                this.killed = true;
                this.taskState = State.Type.KILLED;
                this.interrupt();
            }
        }

        private void exceptionHandler(Thread t, Throwable e) {
            if (!this.killed) {
                this.logger.error(e.getMessage(), e);
                this.taskState = State.Type.FAILED;
            }
        }

        @Generated
        public Logger getLogger() {
            return this.logger;
        }

        @Generated
        public WorkerTask getWorkerTask() {
            return this.workerTask;
        }

        @Generated
        public RunnableTask<?> getTask() {
            return this.task;
        }

        @Generated
        public RunContext getRunContext() {
            return this.runContext;
        }

        @Generated
        public MetricRegistry getMetricRegistry() {
            return this.metricRegistry;
        }

        @Generated
        public String getWorkerGroup() {
            return this.workerGroup;
        }

        @Generated
        public Output getTaskOutput() {
            return this.taskOutput;
        }

        @Generated
        public State.Type getTaskState() {
            return this.taskState;
        }

        @Generated
        public boolean isKilled() {
            return this.killed;
        }
    }
}

