/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.tasks.flows;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.NextTaskRun;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.hierarchies.GraphCluster;
import io.kestra.core.models.hierarchies.RelationType;
import io.kestra.core.models.tasks.FlowableTask;
import io.kestra.core.models.tasks.ResolvedTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.tasks.VoidOutput;
import io.kestra.core.runners.FlowableUtils;
import io.kestra.core.runners.RunContext;
import io.kestra.core.services.GraphService;
import io.kestra.core.utils.TruthUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import lombok.Generated;

@Schema(title="Process some tasks conditionally depending on a contextual value", description="Allow some workflow based on context variables, for example branch a flow based on a previous task.")
@Plugin(examples={@Example(full=true, code={"id: if", "namespace: io.kestra.tests", "", "inputs:", "  - name: string", "    type: STRING", "    required: true", "", "tasks:", "  - id: if", "    type: io.kestra.core.tasks.flows.If", "    condition: \"{{inputs.string == 'Condition'}}\"", "    then:", "      - id: when-true", "        type: io.kestra.core.tasks.log.Log", "        message: 'Condition was true'", "    else:", "      - id: when-false", "        type: io.kestra.core.tasks.log.Log", "        message: 'Condition was false'"})})
public class If
extends Task
implements FlowableTask<VoidOutput> {
    @PluginProperty(dynamic=true)
    @Schema(title="If condition, must coerce to a boolean.", description="Boolean coercion allows 0, -0, null and '' to coerce to false,  all other values to coerce to true.")
    private String condition;
    @Valid
    @PluginProperty
    @Schema(title="List of tasks to execute when the condition is true.")
    @NotEmpty
    private List<Task> then;
    @Valid
    @PluginProperty
    @Schema(title="List of tasks to execute when the condition is false.")
    @JsonProperty(value="else")
    private List<Task> _else;
    @Valid
    @PluginProperty
    @Schema(title="List of tasks to execute in case of errors on a child task.")
    private List<Task> errors;

    @Override
    public List<Task> getErrors() {
        return this.errors;
    }

    @Override
    public GraphCluster tasksTree(Execution execution, TaskRun taskRun, List<String> parentValues) throws IllegalVariableEvaluationException {
        GraphCluster subGraph = new GraphCluster(this, taskRun, parentValues, RelationType.CHOICE);
        GraphService.ifElse(subGraph, this.then, this._else, this.errors, taskRun, execution);
        return subGraph;
    }

    @Override
    public List<Task> allChildTasks() {
        return Stream.concat(this.then != null ? this.then.stream() : Stream.empty(), Stream.concat(this._else != null ? this._else.stream() : Stream.empty(), this.errors != null ? this.errors.stream() : Stream.empty())).collect(Collectors.toList());
    }

    @Override
    public List<ResolvedTask> childTasks(RunContext runContext, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        String rendered = runContext.render(this.condition);
        if (TruthUtils.isTruthy(rendered)) {
            return FlowableUtils.resolveTasks(this.then, parentTaskRun);
        }
        return FlowableUtils.resolveTasks(this._else, parentTaskRun);
    }

    @Override
    public List<NextTaskRun> resolveNexts(RunContext runContext, Execution execution, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        return FlowableUtils.resolveSequentialNexts(execution, this.childTasks(runContext, parentTaskRun), FlowableUtils.resolveTasks(this.errors, parentTaskRun), parentTaskRun);
    }

    @Override
    public Optional<State.Type> resolveState(RunContext runContext, Execution execution, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        List<ResolvedTask> childTask = this.childTasks(runContext, parentTaskRun);
        if (childTask == null) {
            return Optional.of(execution.guessFinalState(null, parentTaskRun));
        }
        return FlowableUtils.resolveState(execution, this.childTasks(runContext, parentTaskRun), FlowableUtils.resolveTasks(this.getErrors(), parentTaskRun), parentTaskRun, runContext);
    }

    @Generated
    protected If(IfBuilder<?, ?> b) {
        super(b);
        this.condition = b.condition;
        this.then = b.then;
        this._else = b._else;
        this.errors = b.errors;
    }

    @Generated
    public static IfBuilder<?, ?> builder() {
        return new IfBuilderImpl();
    }

    @Generated
    public String toString() {
        return "If(super=" + super.toString() + ", condition=" + this.getCondition() + ", then=" + this.getThen() + ", _else=" + this.get_else() + ", errors=" + this.getErrors() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof If)) {
            return false;
        }
        If other = (If)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$condition = this.getCondition();
        String other$condition = other.getCondition();
        if (this$condition == null ? other$condition != null : !this$condition.equals(other$condition)) {
            return false;
        }
        List<Task> this$then = this.getThen();
        List<Task> other$then = other.getThen();
        if (this$then == null ? other$then != null : !((Object)this$then).equals(other$then)) {
            return false;
        }
        List<Task> this$_else = this.get_else();
        List<Task> other$_else = other.get_else();
        if (this$_else == null ? other$_else != null : !((Object)this$_else).equals(other$_else)) {
            return false;
        }
        List<Task> this$errors = this.getErrors();
        List<Task> other$errors = other.getErrors();
        return !(this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof If;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $condition = this.getCondition();
        result = result * 59 + ($condition == null ? 43 : $condition.hashCode());
        List<Task> $then = this.getThen();
        result = result * 59 + ($then == null ? 43 : ((Object)$then).hashCode());
        List<Task> $_else = this.get_else();
        result = result * 59 + ($_else == null ? 43 : ((Object)$_else).hashCode());
        List<Task> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        return result;
    }

    @Generated
    public String getCondition() {
        return this.condition;
    }

    @Generated
    public List<Task> getThen() {
        return this.then;
    }

    @Generated
    public List<Task> get_else() {
        return this._else;
    }

    @Generated
    public If() {
    }

    @Generated
    public static abstract class IfBuilder<C extends If, B extends IfBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private String condition;
        @Generated
        private List<Task> then;
        @Generated
        private List<Task> _else;
        @Generated
        private List<Task> errors;

        @Generated
        public B condition(String condition) {
            this.condition = condition;
            return (B)this.self();
        }

        @Generated
        public B then(List<Task> then) {
            this.then = then;
            return (B)this.self();
        }

        @JsonProperty(value="else")
        @Generated
        public B _else(List<Task> _else) {
            this._else = _else;
            return (B)this.self();
        }

        @Generated
        public B errors(List<Task> errors) {
            this.errors = errors;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "If.IfBuilder(super=" + super.toString() + ", condition=" + this.condition + ", then=" + this.then + ", _else=" + this._else + ", errors=" + this.errors + ")";
        }
    }

    @Generated
    private static final class IfBuilderImpl
    extends IfBuilder<If, IfBuilderImpl> {
        @Generated
        private IfBuilderImpl() {
        }

        @Override
        @Generated
        protected IfBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public If build() {
            return new If(this);
        }
    }
}

