/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.tasks.flows;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.NextTaskRun;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.tasks.FlowableTask;
import io.kestra.core.models.tasks.VoidOutput;
import io.kestra.core.runners.FlowableUtils;
import io.kestra.core.runners.RunContext;
import io.kestra.core.tasks.flows.Sequential;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

@Schema(title="Pause the current execution and wait for a manual approval (changing the task state from the UI) or a delay")
@Plugin(examples={@Example(full=true, code={"id: pause", "namespace: io.kestra.tests", "", "tasks:", "  - id: pause", "    type: io.kestra.core.tasks.flows.Pause", "    tasks:", "     - id: ko", "       type: io.kestra.plugin.scripts.shell.Commands", "       commands:", "        - 'echo \"trigger after manual restart\"'", "  - id: last", "    type: io.kestra.core.tasks.debugs.Return", "    format: \"{{task.id}} > {{taskrun.startDate}}\""})})
public class Pause
extends Sequential
implements FlowableTask<VoidOutput> {
    @Schema(title="Duration of the pause.", description="If null and no timeout, a manual approval is needed, if not, the delay before continuing the execution")
    @PluginProperty
    private Duration delay;
    @Schema(title="Timeout of the pause.", description="If null and no delay, a manual approval is needed, else a manual approval is needed before the timeout or the task will fail")
    @PluginProperty
    private Duration timeout;

    @Override
    public List<NextTaskRun> resolveNexts(RunContext runContext, Execution execution, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        if (this.needPause(parentTaskRun) || parentTaskRun.getState().getCurrent() == State.Type.PAUSED) {
            return new ArrayList<NextTaskRun>();
        }
        return FlowableUtils.resolveSequentialNexts(execution, this.childTasks(runContext, parentTaskRun), FlowableUtils.resolveTasks(this.errors, parentTaskRun), parentTaskRun);
    }

    private boolean needPause(TaskRun parentTaskRun) {
        return parentTaskRun.getState().getCurrent() == State.Type.RUNNING && parentTaskRun.getState().getHistories().get(parentTaskRun.getState().getHistories().size() - 2).getState() != State.Type.PAUSED;
    }

    @Override
    public Optional<State.Type> resolveState(RunContext runContext, Execution execution, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        if (this.needPause(parentTaskRun)) {
            return Optional.of(State.Type.PAUSED);
        }
        return super.resolveState(runContext, execution, parentTaskRun);
    }

    @Generated
    protected Pause(PauseBuilder<?, ?> b) {
        super((Sequential.SequentialBuilder<?, ?>)b);
        this.delay = b.delay;
        this.timeout = b.timeout;
    }

    @Generated
    public static PauseBuilder<?, ?> builder() {
        return new PauseBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "Pause(super=" + super.toString() + ", delay=" + this.getDelay() + ", timeout=" + this.getTimeout() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pause)) {
            return false;
        }
        Pause other = (Pause)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Duration this$delay = this.getDelay();
        Duration other$delay = other.getDelay();
        if (this$delay == null ? other$delay != null : !((Object)this$delay).equals(other$delay)) {
            return false;
        }
        Duration this$timeout = this.getTimeout();
        Duration other$timeout = other.getTimeout();
        return !(this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Pause;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Duration $delay = this.getDelay();
        result = result * 59 + ($delay == null ? 43 : ((Object)$delay).hashCode());
        Duration $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        return result;
    }

    @Generated
    public Duration getDelay() {
        return this.delay;
    }

    @Override
    @Generated
    public Duration getTimeout() {
        return this.timeout;
    }

    @Generated
    public Pause() {
    }

    @Generated
    public static abstract class PauseBuilder<C extends Pause, B extends PauseBuilder<C, B>>
    extends Sequential.SequentialBuilder<C, B> {
        @Generated
        private Duration delay;
        @Generated
        private Duration timeout;

        @Generated
        public B delay(Duration delay) {
            this.delay = delay;
            return (B)this.self();
        }

        @Override
        @Generated
        public B timeout(Duration timeout) {
            this.timeout = timeout;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Pause.PauseBuilder(super=" + super.toString() + ", delay=" + this.delay + ", timeout=" + this.timeout + ")";
        }
    }

    @Generated
    private static final class PauseBuilderImpl
    extends PauseBuilder<Pause, PauseBuilderImpl> {
        @Generated
        private PauseBuilderImpl() {
        }

        @Override
        @Generated
        protected PauseBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Pause build() {
            return new Pause(this);
        }
    }
}

