/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.tasks.flows;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.NextTaskRun;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.tasks.ResolvedTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.WorkerTask;
import io.kestra.core.tasks.flows.Sequential;
import io.kestra.core.utils.IdUtils;
import io.kestra.core.validations.WorkingDirectoryTaskValidation;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.validation.constraints.NotNull;
import lombok.Generated;

@Schema(title="Run tasks sequentially in the same working directory", description="Tasks are stateless by default. Kestra will launch each task within a temporary working directory on a Worker. The `WorkingDirectory` task allows reusing the same file system's working directory across multiple tasks so that multiple sequential tasks can use output files from previous tasks without having to use the `outputs.taskId.outputName` syntax. Note that the `WorkingDirectory` only works with runnable tasks because those tasks are executed directly on the Worker. This means that using flowable tasks such as the `Parallel` task within the `WorkingDirectory` task will not work. The `WorkingDirectory` task requires Kestra>=0.9.0.")
@Plugin(examples={@Example(full=true, title="Clone a git repository into the Working Directory and run a Python script", code={"id: gitPython", "namespace: dev", "", "tasks:", "  - id: wdir", "    type: io.kestra.core.tasks.flows.WorkingDirectory", "    tasks:", "      - id: cloneRepository", "        type: io.kestra.plugin.git.Clone", "        url: https://github.com/kestra-io/examples", "        branch: main", "      - id: python", "        type: io.kestra.plugin.scripts.python.Commands", "        docker:", "          image: ghcr.io/kestra-io/pydata:latest", "        commands:", "          - python scripts/etl_script.py"}), @Example(full=true, title="Add input and output files within a Working Directory to use them in a Python script", code={"id: apiJSONtoMongoDB\nnamespace: dev\n\ntasks:\n- id: wdir\n    type: io.kestra.core.tasks.flows.WorkingDirectory\n    tasks:\n    - id: demoSQL\n        type: io.kestra.core.tasks.storages.LocalFiles\n        inputs:\n        query.sql: |\n            SELECT sum(total) as total, avg(quantity) as avg_quantity\n            FROM sales;\n\n    - id: inlineScript\n        type: io.kestra.plugin.scripts.python.Script\n        runner: DOCKER\n        docker:\n        image: python:3.11-slim\n        beforeCommands:\n        - pip install requests kestra > /dev/null\n        warningOnStdErr: false\n        script: |\n        import requests\n        import json\n        from kestra import Kestra\n\n        with open('query.sql', 'r') as input_file:\n            sql = input_file.read()\n\n        response = requests.get('https://api.github.com')\n        data = response.json()\n\n        with open('output.json', 'w') as output_file:\n            json.dump(data, output_file)\n\n        Kestra.outputs({'receivedSQL': sql, 'status': response.status_code})\n\n    - id: jsonFiles\n        type: io.kestra.core.tasks.storages.LocalFiles\n        outputs:\n        - output.json\n\n- id: loadToMongoDB\n    type: io.kestra.plugin.mongodb.Load\n    connection:\n    uri: mongodb://host.docker.internal:27017/\n    database: local\n    collection: github\n    from: \"{{outputs.jsonFiles.uris['output.json']}}\"\n"}), @Example(full=true, code={"id: working-directory", "namespace: io.kestra.tests", "", "tasks:", "  - id: working-directory", "    type: io.kestra.core.tasks.flows.WorkingDirectory", "    tasks:", "      - id: first", "        type: io.kestra.plugin.scripts.shell.Commands", "        commands:", "        - 'echo \"{{ taskrun.id }}\" > {{ workingDir }}/stay.txt'", "      - id: second", "        type: io.kestra.plugin.scripts.shell.Commands", "        commands:", "        - |", "          echo '::{\"outputs\": {\"stay\":\"'$(cat {{ workingDir }}/stay.txt)'\"}}::'"}), @Example(full=true, title="A working directory with a cache of the node_modules directory", code={"id: node-with-cache\nnamespace: dev\ntasks:\n  - id: working-dir\n    type: io.kestra.core.tasks.flows.WorkingDirectory\n    cache:\n      patterns:\n        - node_modules/**\n      ttl: PT1H\n    tasks:\n    - id: script\n      type: io.kestra.plugin.scripts.node.Script\n      beforeCommands:\n        - npm install colors\n      script: |\n        const colors = require(\"colors\");\n        console.log(colors.red(\"Hello\"));"})})
@WorkingDirectoryTaskValidation
public class WorkingDirectory
extends Sequential {
    @Schema(title="Cache configuration", description="When a cache is configured, an archive of the files denoted by the cache configuration is created at the end of the execution of the task and saved in Kestra's internal storage.\nThen at the beginning of the next execution of the task, the archive of the files is retrieved and the working directory initialized with it.\n")
    @PluginProperty
    private Cache cache;
    private transient long cacheDownloadedTime = 0L;

    @Override
    public List<NextTaskRun> resolveNexts(RunContext runContext, Execution execution, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        List<ResolvedTask> childTasks = this.childTasks(runContext, parentTaskRun);
        if (execution.hasFailed(childTasks, parentTaskRun)) {
            return super.resolveNexts(runContext, execution, parentTaskRun);
        }
        return Collections.emptyList();
    }

    public WorkerTask workerTask(TaskRun parent, Task task, RunContext runContext) {
        return WorkerTask.builder().task(task).taskRun(TaskRun.builder().id(IdUtils.create()).executionId(parent.getExecutionId()).namespace(parent.getNamespace()).flowId(parent.getFlowId()).taskId(task.getId()).parentTaskRunId(parent.getId()).state(new State()).build()).runContext(runContext).build();
    }

    public void preExecuteTasks(RunContext runContext, TaskRun taskRun) {
        block12: {
            if (this.cache == null) {
                return;
            }
            try {
                Optional<InputStream> maybeCacheFile;
                Optional<Long> maybeLastModifiedTime;
                if (this.cache.ttl != null && (maybeLastModifiedTime = runContext.getTaskCacheFileLastModifiedTime(taskRun.getNamespace(), taskRun.getFlowId(), this.getId(), taskRun.getValue())).isPresent() && Instant.now().isAfter(Instant.ofEpochMilli(maybeLastModifiedTime.get()).plus(this.cache.ttl))) {
                    runContext.logger().debug("Cache is expired, deleting it");
                    runContext.deleteTaskCacheFile(taskRun.getNamespace(), taskRun.getFlowId(), this.getId(), taskRun.getValue());
                }
                if (!(maybeCacheFile = runContext.getTaskCacheFile(taskRun.getNamespace(), taskRun.getFlowId(), this.getId(), taskRun.getValue())).isPresent()) break block12;
                runContext.logger().debug("Cache exist, downloading it");
                try (ZipInputStream archive = new ZipInputStream(maybeCacheFile.get());){
                    ZipEntry entry;
                    while ((entry = archive.getNextEntry()) != null) {
                        if (entry.isDirectory()) continue;
                        try {
                            Path file = runContext.tempDir().resolve(entry.getName());
                            Files.createDirectories(file.getParent(), new FileAttribute[0]);
                            Files.createFile(file, new FileAttribute[0]);
                            Files.write(file, archive.readAllBytes(), new OpenOption[0]);
                        }
                        catch (IOException e) {
                            runContext.logger().error("Unable to create the file {}", (Object)entry.getName(), (Object)e);
                        }
                    }
                }
                this.cacheDownloadedTime = System.currentTimeMillis();
            }
            catch (IOException e) {
                runContext.logger().error("Unable to execute WorkingDirectory pre actions", (Throwable)e);
            }
        }
    }

    public void postExecuteTasks(final RunContext runContext, TaskRun taskRun) {
        block15: {
            if (this.cache == null) {
                return;
            }
            final ArrayList matchesList = new ArrayList();
            SimpleFileVisitor<Path> matcherVisitor = new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attribs) throws IOException {
                    FileSystem fs = FileSystems.getDefault();
                    for (String pattern : WorkingDirectory.this.cache.getPatterns()) {
                        String fullPattern = runContext.tempDir().toString() + "/" + pattern;
                        PathMatcher matcher = fs.getPathMatcher("glob:" + fullPattern);
                        if (!matcher.matches(file)) continue;
                        matchesList.add(file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            };
            try {
                Files.walkFileTree(runContext.tempDir(), (FileVisitor<? super Path>)matcherVisitor);
                boolean cacheFilesAreUpdated = matchesList.stream().anyMatch(path -> {
                    try {
                        return Files.getLastModifiedTime(path, new LinkOption[0]).toMillis() > this.cacheDownloadedTime;
                    }
                    catch (IOException e) {
                        runContext.logger().warn("Unable to retrieve files last modified time,  will update the cache anyway", (Throwable)e);
                        return true;
                    }
                });
                if (cacheFilesAreUpdated) {
                    runContext.logger().debug("Cache files changed, we update the cache");
                    try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
                         ZipOutputStream archive = new ZipOutputStream(bos);){
                        for (Path file : matchesList) {
                            String relativeFileName = file.toFile().getPath().substring(runContext.tempDir().toString().length() + 1);
                            ZipEntry zipEntry = new ZipEntry(relativeFileName);
                            archive.putNextEntry(zipEntry);
                            archive.write(Files.readAllBytes(file));
                            archive.closeEntry();
                        }
                        archive.finish();
                        File archiveFile = File.createTempFile("archive", ".zip");
                        Files.write(archiveFile.toPath(), bos.toByteArray(), new OpenOption[0]);
                        URI uri = runContext.putTaskCacheFile(archiveFile, taskRun.getNamespace(), taskRun.getFlowId(), this.getId(), taskRun.getValue());
                        runContext.logger().debug("Caching in {}", (Object)uri);
                        break block15;
                    }
                }
                runContext.logger().debug("Cache files didn't change, skip updating it");
            }
            catch (IOException e) {
                runContext.logger().error("Unable to execute WorkingDirectory post actions", (Throwable)e);
            }
        }
    }

    @Generated
    protected WorkingDirectory(WorkingDirectoryBuilder<?, ?> b) {
        super((Sequential.SequentialBuilder<?, ?>)b);
        this.cache = b.cache;
        this.cacheDownloadedTime = b.cacheDownloadedTime;
    }

    @Generated
    public static WorkingDirectoryBuilder<?, ?> builder() {
        return new WorkingDirectoryBuilderImpl();
    }

    @Generated
    public WorkingDirectoryBuilder<?, ?> toBuilder() {
        return new WorkingDirectoryBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public String toString() {
        return "WorkingDirectory(super=" + super.toString() + ", cache=" + this.getCache() + ", cacheDownloadedTime=" + this.getCacheDownloadedTime() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkingDirectory)) {
            return false;
        }
        WorkingDirectory other = (WorkingDirectory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Cache this$cache = this.getCache();
        Cache other$cache = other.getCache();
        return !(this$cache == null ? other$cache != null : !((Object)this$cache).equals(other$cache));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WorkingDirectory;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Cache $cache = this.getCache();
        result = result * 59 + ($cache == null ? 43 : ((Object)$cache).hashCode());
        return result;
    }

    @Generated
    public Cache getCache() {
        return this.cache;
    }

    @Generated
    public WorkingDirectory() {
    }

    @Generated
    private long getCacheDownloadedTime() {
        return this.cacheDownloadedTime;
    }

    public static class Cache {
        @Schema(title="Cache TTL (Time To Live), after this duration the cache will be deleted.")
        @PluginProperty
        private Duration ttl;
        @Schema(title="List of file [glob](https://en.wikipedia.org/wiki/Glob_(programming)) patterns to include in the cache.", description="For example 'node_modules/**' will include all files of the node_modules directory including sub-directories.")
        @PluginProperty
        @NotNull
        private List<String> patterns;

        @Generated
        protected Cache(CacheBuilder<?, ?> b) {
            this.ttl = b.ttl;
            this.patterns = b.patterns;
        }

        @Generated
        public static CacheBuilder<?, ?> builder() {
            return new CacheBuilderImpl();
        }

        @Generated
        public String toString() {
            return "WorkingDirectory.Cache(ttl=" + this.getTtl() + ", patterns=" + this.getPatterns() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Cache)) {
                return false;
            }
            Cache other = (Cache)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Duration this$ttl = this.getTtl();
            Duration other$ttl = other.getTtl();
            if (this$ttl == null ? other$ttl != null : !((Object)this$ttl).equals(other$ttl)) {
                return false;
            }
            List<String> this$patterns = this.getPatterns();
            List<String> other$patterns = other.getPatterns();
            return !(this$patterns == null ? other$patterns != null : !((Object)this$patterns).equals(other$patterns));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Cache;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Duration $ttl = this.getTtl();
            result = result * 59 + ($ttl == null ? 43 : ((Object)$ttl).hashCode());
            List<String> $patterns = this.getPatterns();
            result = result * 59 + ($patterns == null ? 43 : ((Object)$patterns).hashCode());
            return result;
        }

        @Generated
        public Duration getTtl() {
            return this.ttl;
        }

        @Generated
        public List<String> getPatterns() {
            return this.patterns;
        }

        @Generated
        public Cache() {
        }

        @Generated
        public static abstract class CacheBuilder<C extends Cache, B extends CacheBuilder<C, B>> {
            @Generated
            private Duration ttl;
            @Generated
            private List<String> patterns;

            @Generated
            public B ttl(Duration ttl) {
                this.ttl = ttl;
                return this.self();
            }

            @Generated
            public B patterns(List<String> patterns) {
                this.patterns = patterns;
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "WorkingDirectory.Cache.CacheBuilder(ttl=" + this.ttl + ", patterns=" + this.patterns + ")";
            }
        }

        @Generated
        private static final class CacheBuilderImpl
        extends CacheBuilder<Cache, CacheBuilderImpl> {
            @Generated
            private CacheBuilderImpl() {
            }

            @Override
            @Generated
            protected CacheBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public Cache build() {
                return new Cache(this);
            }
        }
    }

    @Generated
    public static abstract class WorkingDirectoryBuilder<C extends WorkingDirectory, B extends WorkingDirectoryBuilder<C, B>>
    extends Sequential.SequentialBuilder<C, B> {
        @Generated
        private Cache cache;
        @Generated
        private long cacheDownloadedTime;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            WorkingDirectoryBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(WorkingDirectory instance, WorkingDirectoryBuilder<?, ?> b) {
            b.cache(instance.cache);
            b.cacheDownloadedTime(instance.cacheDownloadedTime);
        }

        @Generated
        public B cache(Cache cache) {
            this.cache = cache;
            return (B)this.self();
        }

        @Generated
        public B cacheDownloadedTime(long cacheDownloadedTime) {
            this.cacheDownloadedTime = cacheDownloadedTime;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "WorkingDirectory.WorkingDirectoryBuilder(super=" + super.toString() + ", cache=" + this.cache + ", cacheDownloadedTime=" + this.cacheDownloadedTime + ")";
        }
    }

    @Generated
    private static final class WorkingDirectoryBuilderImpl
    extends WorkingDirectoryBuilder<WorkingDirectory, WorkingDirectoryBuilderImpl> {
        @Generated
        private WorkingDirectoryBuilderImpl() {
        }

        @Override
        @Generated
        protected WorkingDirectoryBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public WorkingDirectory build() {
            return new WorkingDirectory(this);
        }
    }
}

