/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.tasks.log;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.tasks.VoidOutput;
import io.kestra.core.runners.RunContext;
import io.kestra.core.utils.Rethrow;
import io.micronaut.core.annotation.NonNull;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;
import javax.validation.constraints.NotBlank;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.event.Level;

@Schema(title="Log a message in the task logs")
@Plugin(examples={@Example(code={"level: WARN", "message: \"{{task.id}} > {{taskrun.startDate}}\""}), @Example(code={"level: WARN", "message:    - 'Task id : \"{{task.id}}\"'   - 'Start date: \"{{taskrun.startDate}}\"'"})})
public class Log
extends Task
implements RunnableTask<VoidOutput> {
    @Schema(title="The message(s) to log", description="Can be a string or an array of string", anyOf={String.class, String[].class})
    @NonNull
    @NotBlank
    @PluginProperty(dynamic=true)
    private Object message;
    @Schema(title="The log level")
    @PluginProperty
    private Level level;

    @Override
    public VoidOutput run(RunContext runContext) throws Exception {
        Logger logger = runContext.logger();
        if (this.message instanceof String) {
            String render = runContext.render((String)this.message);
            this.log(logger, this.level, render);
        } else if (this.message instanceof Collection) {
            Collection messages = (Collection)this.message;
            messages.forEach(Rethrow.throwConsumer(message -> {
                String render = runContext.render((String)message);
                this.log(logger, this.level, render);
            }));
        } else {
            throw new IllegalArgumentException("Invalid message type '" + this.message.getClass() + "'");
        }
        return null;
    }

    public void log(Logger logger, Level level, String message) {
        switch (this.level) {
            case TRACE: {
                logger.trace(message);
                break;
            }
            case DEBUG: {
                logger.debug(message);
                break;
            }
            case INFO: {
                logger.info(message);
                break;
            }
            case WARN: {
                logger.warn(message);
                break;
            }
            case ERROR: {
                logger.error(message);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid log level '" + this.level + "'");
            }
        }
    }

    @Generated
    private static Level $default$level() {
        return Level.INFO;
    }

    @Generated
    protected Log(LogBuilder<?, ?> b) {
        super(b);
        this.message = b.message;
        this.level = b.level$set ? b.level$value : Log.$default$level();
    }

    @Generated
    public static LogBuilder<?, ?> builder() {
        return new LogBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Log(super=" + super.toString() + ", message=" + this.getMessage() + ", level=" + this.getLevel() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Log)) {
            return false;
        }
        Log other = (Log)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Object this$message = this.getMessage();
        Object other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        Level this$level = this.getLevel();
        Level other$level = other.getLevel();
        return !(this$level == null ? other$level != null : !this$level.equals(other$level));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Log;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Object $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        Level $level = this.getLevel();
        result = result * 59 + ($level == null ? 43 : $level.hashCode());
        return result;
    }

    @Generated
    public Object getMessage() {
        return this.message;
    }

    @Generated
    public Level getLevel() {
        return this.level;
    }

    @Generated
    public Log() {
        this.level = Log.$default$level();
    }

    @Generated
    public static abstract class LogBuilder<C extends Log, B extends LogBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private Object message;
        @Generated
        private boolean level$set;
        @Generated
        private Level level$value;

        @Generated
        public B message(Object message) {
            this.message = message;
            return (B)this.self();
        }

        @Generated
        public B level(Level level) {
            this.level$value = level;
            this.level$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Log.LogBuilder(super=" + super.toString() + ", message=" + this.message + ", level$value=" + this.level$value + ")";
        }
    }

    @Generated
    private static final class LogBuilderImpl
    extends LogBuilder<Log, LogBuilderImpl> {
        @Generated
        private LogBuilderImpl() {
        }

        @Override
        @Generated
        protected LogBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Log build() {
            return new Log(this);
        }
    }
}

