package io.kestra.core.models.conditions.types;

import io.kestra.core.exceptions.InternalException;
import io.kestra.core.models.annotations.PluginProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.ToString;
import lombok.experimental.SuperBuilder;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.conditions.ConditionContext;

import javax.validation.constraints.NotNull;

@SuperBuilder
@ToString
@EqualsAndHashCode
@Getter
@NoArgsConstructor
@Schema(
    title = "Condition for a specific flow. Note that this condition is deprecated, use `ExecutionFlowCondition` instead."
)
@Plugin(
    examples = {
        @Example(
            full = true,
            code = {
                "- conditions:",
                "    - type: io.kestra.core.models.conditions.types.FlowCondition",
                "      namespace: io.kestra.tests",
                "      flowId: my-current-flow"
            }
        )
    }
)
@Deprecated
public class FlowCondition extends Condition {
    @NotNull
    @Schema(title = "The namespace of the flow")
    @PluginProperty
    private String namespace;

    @NotNull
    @Schema(title = "The flow id")
    @PluginProperty
    private String flowId;

    @Override
    public boolean test(ConditionContext conditionContext) throws InternalException {
        return conditionContext.getFlow().getNamespace().equals(this.namespace) && conditionContext.getFlow().getId().equals(this.flowId);
    }
}
