/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.contexts;

import io.kestra.core.contexts.KestraClassLoader;
import io.kestra.core.plugins.PluginRegistry;
import io.kestra.core.plugins.RegisteredPlugin;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanIntrospectionReference;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.io.service.SoftServiceLoader;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.validation.validator.DefaultValidator;
import io.micronaut.validation.validator.ValidatorConfiguration;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Replaces(value=DefaultValidator.class)
public class KestraValidator
extends DefaultValidator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KestraValidator.class);
    private Map<String, BeanIntrospectionReference<Object>> introspectionMap;

    protected KestraValidator(@NonNull ValidatorConfiguration configuration) {
        super(configuration);
    }

    @Nullable
    protected BeanIntrospection<Object> getBeanIntrospection(@NonNull Object object) {
        if (object == null) {
            return null;
        }
        BeanIntrospection beanIntrospection = super.getBeanIntrospection(object);
        if (beanIntrospection != null) {
            return beanIntrospection;
        }
        if (object instanceof Class) {
            return this.findIntrospection((Class)object).orElse(null);
        }
        return this.findIntrospection(object.getClass()).orElse(null);
    }

    private <T> Optional<BeanIntrospection<T>> findIntrospection(@NonNull Class<T> beanType) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        BeanIntrospectionReference<Object> reference = this.getIntrospections().get(beanType.getName());
        try {
            if (reference != null) {
                return Optional.of(reference).map(ref -> {
                    if (log.isDebugEnabled()) {
                        log.debug("Found BeanIntrospection for type: " + ref.getBeanType());
                    }
                    return ref.load();
                });
            }
            if (log.isDebugEnabled()) {
                log.debug("No BeanIntrospection found for bean type: " + beanType);
            }
            return Optional.empty();
        }
        catch (Throwable e) {
            throw new IntrospectionException("Error loading BeanIntrospection for type [" + beanType + "]: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, BeanIntrospectionReference<Object>> getIntrospections() {
        Map<String, BeanIntrospectionReference<Object>> introspectionMap = this.introspectionMap;
        if (introspectionMap == null) {
            KestraValidator kestraValidator = this;
            synchronized (kestraValidator) {
                introspectionMap = this.introspectionMap;
                if (introspectionMap == null) {
                    PluginRegistry pluginRegistry;
                    introspectionMap = new HashMap<String, BeanIntrospectionReference<Object>>(30);
                    try {
                        pluginRegistry = KestraClassLoader.instance().getPluginRegistry();
                    }
                    catch (IllegalStateException e) {
                        if (log.isDebugEnabled()) {
                            log.debug(e.getMessage());
                        }
                        return introspectionMap;
                    }
                    if (pluginRegistry != null) {
                        for (RegisteredPlugin registeredPlugin : pluginRegistry.getPlugins()) {
                            SoftServiceLoader loader = SoftServiceLoader.load(BeanIntrospectionReference.class, (ClassLoader)registeredPlugin.getClassLoader());
                            ArrayList definitions = new ArrayList(100);
                            loader.collectAll(definitions);
                            for (BeanIntrospectionReference definition : definitions) {
                                introspectionMap.put(definition.getName(), (BeanIntrospectionReference<Object>)definition);
                            }
                        }
                    }
                    this.introspectionMap = introspectionMap;
                }
            }
        }
        return introspectionMap;
    }
}

