/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.docs;

import io.kestra.core.docs.AbstractClassDocumentation;
import io.kestra.core.docs.JsonSchemaGenerator;
import io.kestra.core.plugins.RegisteredPlugin;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import lombok.Generated;

public class ClassPluginDocumentation<T>
extends AbstractClassDocumentation<T> {
    private String icon;
    private String group;
    private String pluginTitle;
    private String subGroup;
    private List<MetricDoc> docMetrics;
    private Map<String, Object> outputs = new TreeMap<String, Object>();
    private Map<String, Object> outputsSchema;

    private ClassPluginDocumentation(JsonSchemaGenerator jsonSchemaGenerator, RegisteredPlugin plugin, Class<? extends T> cls, Class<T> baseCls) {
        super(jsonSchemaGenerator, cls, baseCls);
        this.cls = cls.getName();
        this.group = plugin.group();
        this.pluginTitle = plugin.title();
        this.icon = plugin.icon(cls);
        if (this.group != null && cls.getPackageName().startsWith(this.group) && cls.getPackageName().length() > this.group.length() && cls.getPackageName().charAt(this.group.length()) == '.') {
            this.subGroup = cls.getPackageName().substring(this.group.length() + 1);
        }
        this.shortName = cls.getSimpleName();
        this.outputsSchema = jsonSchemaGenerator.outputs(baseCls, cls);
        if (this.outputsSchema.containsKey("$defs")) {
            this.defs.putAll((Map)this.outputsSchema.get("$defs"));
            this.outputsSchema.remove("$defs");
        }
        if (this.outputsSchema.containsKey("properties")) {
            this.outputs = ClassPluginDocumentation.flatten(ClassPluginDocumentation.properties(this.outputsSchema), ClassPluginDocumentation.required(this.outputsSchema));
        }
        if (this.propertiesSchema.containsKey("$metrics")) {
            List metrics = (List)this.propertiesSchema.get("$metrics");
            this.docMetrics = metrics.stream().map(r -> new MetricDoc((String)r.get("name"), (String)r.get("type"), (String)r.get("unit"), (String)r.get("description"))).collect(Collectors.toList());
        }
    }

    public static <T> ClassPluginDocumentation<T> of(JsonSchemaGenerator jsonSchemaGenerator, RegisteredPlugin plugin, Class<? extends T> cls, Class<T> baseCls) {
        return new ClassPluginDocumentation<T>(jsonSchemaGenerator, plugin, cls, baseCls);
    }

    @Generated
    public String getIcon() {
        return this.icon;
    }

    @Generated
    public String getGroup() {
        return this.group;
    }

    @Generated
    public String getPluginTitle() {
        return this.pluginTitle;
    }

    @Generated
    public String getSubGroup() {
        return this.subGroup;
    }

    @Generated
    public List<MetricDoc> getDocMetrics() {
        return this.docMetrics;
    }

    @Generated
    public Map<String, Object> getOutputs() {
        return this.outputs;
    }

    @Generated
    public Map<String, Object> getOutputsSchema() {
        return this.outputsSchema;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassPluginDocumentation)) {
            return false;
        }
        ClassPluginDocumentation other = (ClassPluginDocumentation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$icon = this.getIcon();
        String other$icon = other.getIcon();
        if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
            return false;
        }
        String this$group = this.getGroup();
        String other$group = other.getGroup();
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
            return false;
        }
        String this$pluginTitle = this.getPluginTitle();
        String other$pluginTitle = other.getPluginTitle();
        if (this$pluginTitle == null ? other$pluginTitle != null : !this$pluginTitle.equals(other$pluginTitle)) {
            return false;
        }
        String this$subGroup = this.getSubGroup();
        String other$subGroup = other.getSubGroup();
        if (this$subGroup == null ? other$subGroup != null : !this$subGroup.equals(other$subGroup)) {
            return false;
        }
        List<MetricDoc> this$docMetrics = this.getDocMetrics();
        List<MetricDoc> other$docMetrics = other.getDocMetrics();
        if (this$docMetrics == null ? other$docMetrics != null : !((Object)this$docMetrics).equals(other$docMetrics)) {
            return false;
        }
        Map<String, Object> this$outputs = this.getOutputs();
        Map<String, Object> other$outputs = other.getOutputs();
        if (this$outputs == null ? other$outputs != null : !((Object)this$outputs).equals(other$outputs)) {
            return false;
        }
        Map<String, Object> this$outputsSchema = this.getOutputsSchema();
        Map<String, Object> other$outputsSchema = other.getOutputsSchema();
        return !(this$outputsSchema == null ? other$outputsSchema != null : !((Object)this$outputsSchema).equals(other$outputsSchema));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClassPluginDocumentation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $icon = this.getIcon();
        result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
        String $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        String $pluginTitle = this.getPluginTitle();
        result = result * 59 + ($pluginTitle == null ? 43 : $pluginTitle.hashCode());
        String $subGroup = this.getSubGroup();
        result = result * 59 + ($subGroup == null ? 43 : $subGroup.hashCode());
        List<MetricDoc> $docMetrics = this.getDocMetrics();
        result = result * 59 + ($docMetrics == null ? 43 : ((Object)$docMetrics).hashCode());
        Map<String, Object> $outputs = this.getOutputs();
        result = result * 59 + ($outputs == null ? 43 : ((Object)$outputs).hashCode());
        Map<String, Object> $outputsSchema = this.getOutputsSchema();
        result = result * 59 + ($outputsSchema == null ? 43 : ((Object)$outputsSchema).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "ClassPluginDocumentation(super=" + super.toString() + ", icon=" + this.getIcon() + ", group=" + this.getGroup() + ", pluginTitle=" + this.getPluginTitle() + ", subGroup=" + this.getSubGroup() + ", docMetrics=" + this.getDocMetrics() + ", outputs=" + this.getOutputs() + ", outputsSchema=" + this.getOutputsSchema() + ")";
    }

    public static class MetricDoc {
        String name;
        String type;
        String unit;
        String description;

        @ConstructorProperties(value={"name", "type", "unit", "description"})
        @Generated
        public MetricDoc(String name, String type, String unit, String description) {
            this.name = name;
            this.type = type;
            this.unit = unit;
            this.description = description;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String getUnit() {
            return this.unit;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }
    }
}

