/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.docs;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.members.HierarchicType;
import com.fasterxml.classmate.members.ResolvedField;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.github.victools.jsonschema.generator.CustomDefinition;
import com.github.victools.jsonschema.generator.CustomDefinitionProviderV2;
import com.github.victools.jsonschema.generator.FieldScope;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.Option;
import com.github.victools.jsonschema.generator.OptionPreset;
import com.github.victools.jsonschema.generator.SchemaGenerationContext;
import com.github.victools.jsonschema.generator.SchemaGenerator;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaVersion;
import com.github.victools.jsonschema.generator.TypeContext;
import com.github.victools.jsonschema.generator.impl.DefinitionKey;
import com.github.victools.jsonschema.generator.naming.DefaultSchemaDefinitionNamingStrategy;
import com.github.victools.jsonschema.generator.naming.SchemaDefinitionNamingStrategy;
import com.github.victools.jsonschema.module.jackson.JacksonModule;
import com.github.victools.jsonschema.module.jackson.JacksonOption;
import com.github.victools.jsonschema.module.javax.validation.JavaxValidationModule;
import com.github.victools.jsonschema.module.javax.validation.JavaxValidationOption;
import com.github.victools.jsonschema.module.swagger2.Swagger2Module;
import com.google.common.collect.ImmutableMap;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.conditions.ScheduleCondition;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.tasks.Output;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.plugins.RegisteredPlugin;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.services.PluginService;
import io.micronaut.core.annotation.Nullable;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

@Singleton
public class JsonSchemaGenerator {
    @Inject
    private PluginService pluginService;
    Map<Class<?>, Object> defaultInstances = new HashMap();

    public <T> Map<String, Object> schemas(Class<? extends T> cls) {
        SchemaGeneratorConfigBuilder builder = new SchemaGeneratorConfigBuilder(SchemaVersion.DRAFT_7, OptionPreset.PLAIN_JSON);
        this.build(builder, true);
        SchemaGeneratorConfig schemaGeneratorConfig = builder.build();
        SchemaGenerator generator = new SchemaGenerator(schemaGeneratorConfig);
        try {
            ObjectNode objectNode = generator.generateSchema(cls, new Type[0]);
            Map<String, Object> map = JacksonMapper.toMap(objectNode);
            if (cls == Flow.class) {
                JsonSchemaGenerator.fixFlow(map);
                JsonSchemaGenerator.fixCondition(map);
            } else if (cls == Task.class) {
                JsonSchemaGenerator.fixTask(map);
            } else if (cls == AbstractTrigger.class) {
                JsonSchemaGenerator.fixTrigger(map);
                JsonSchemaGenerator.fixCondition(map);
            }
            return map;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unable to generate jsonschema for '" + cls.getName() + "'", e);
        }
    }

    private void mutateDescription(ObjectNode collectedTypeAttributes) {
        if (collectedTypeAttributes.has("description")) {
            collectedTypeAttributes.set("markdownDescription", collectedTypeAttributes.get("description"));
            collectedTypeAttributes.remove("description");
        }
        if (collectedTypeAttributes.has("description")) {
            collectedTypeAttributes.set("markdownDescription", collectedTypeAttributes.get("description"));
            collectedTypeAttributes.remove("description");
        }
        if (collectedTypeAttributes.has("default")) {
            StringBuilder sb = new StringBuilder();
            if (collectedTypeAttributes.has("markdownDescription")) {
                sb.append(collectedTypeAttributes.get("markdownDescription").asText());
                sb.append("\n\n");
            }
            try {
                sb.append("Default value is : `").append(JacksonMapper.ofYaml().writeValueAsString((Object)collectedTypeAttributes.get("default")).trim()).append("`");
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            collectedTypeAttributes.set("markdownDescription", (JsonNode)new TextNode(sb.toString()));
        }
    }

    private static void fixFlow(Map<String, Object> map) {
        Map definitions = (Map)map.get("definitions");
        Map flow = (Map)definitions.get("io.kestra.core.models.flows.Flow");
        List requireds = (List)flow.get("required");
        requireds.remove("deleted");
        Map properties = (Map)flow.get("properties");
        properties.remove("deleted");
    }

    private static void fixTask(Map<String, Object> map) {
        Map definitions = (Map)map.get("definitions");
        Map task = (Map)definitions.get("io.kestra.core.models.tasks.Task-2");
        List allOf = (List)task.get("allOf");
        allOf.remove(1);
    }

    private static void fixTrigger(Map<String, Object> map) {
        Map definitions = (Map)map.get("definitions");
        Map trigger = (Map)definitions.get("io.kestra.core.models.triggers.AbstractTrigger-2");
        List allOf = (List)trigger.get("allOf");
        allOf.remove(1);
    }

    private static void fixCondition(Map<String, Object> map) {
        Map definitions = (Map)map.get("definitions");
        Map condition = (Map)definitions.get("io.kestra.core.models.conditions.Condition-2");
        List allOf = (List)condition.get("allOf");
        allOf.remove(1);
    }

    public <T> Map<String, Object> properties(Class<T> base, Class<? extends T> cls) {
        return this.generate(cls, base);
    }

    public <T> Map<String, Object> outputs(Class<T> base, Class<? extends T> cls) {
        ArrayList<Class<T>> superClass = new ArrayList<Class<T>>();
        for (Class<T> c2 = cls; c2 != null && c2 != base; c2 = c2.getSuperclass()) {
            superClass.add(c2);
        }
        return superClass.stream().flatMap(r -> Arrays.stream(r.getGenericInterfaces())).filter(type -> type instanceof ParameterizedType).map(type -> (ParameterizedType)type).flatMap(parameterizedType -> Arrays.stream(parameterizedType.getActualTypeArguments())).filter(type -> type instanceof Class).map(type -> (Class)type).filter(Output.class::isAssignableFrom).findFirst().map(c -> this.generate((Class)c, null)).orElse((Map)ImmutableMap.of());
    }

    protected void build(SchemaGeneratorConfigBuilder builder, boolean draft7) {
        builder.with((Module)new JavaxValidationModule(new JavaxValidationOption[]{JavaxValidationOption.NOT_NULLABLE_METHOD_IS_REQUIRED, JavaxValidationOption.NOT_NULLABLE_FIELD_IS_REQUIRED, JavaxValidationOption.INCLUDE_PATTERN_EXPRESSIONS})).with((Module)new Swagger2Module()).with(Option.DEFINITIONS_FOR_ALL_OBJECTS, new Option[0]).with(Option.DEFINITION_FOR_MAIN_SCHEMA, new Option[0]).with(Option.PLAIN_DEFINITION_KEYS, new Option[0]).with(Option.ALLOF_CLEANUP_AT_THE_END, new Option[0]);
        if (!draft7) {
            builder.with((Module)new JacksonModule(new JacksonOption[]{JacksonOption.IGNORE_TYPE_INFO_TRANSFORM})).with(Option.MAP_VALUES_AS_ADDITIONAL_PROPERTIES, new Option[0]);
        } else {
            builder.with((Module)new JacksonModule());
        }
        builder.forFields().withDefaultResolver(this::defaults);
        builder.forTypesInGeneral().withDefinitionNamingStrategy((SchemaDefinitionNamingStrategy)new DefaultSchemaDefinitionNamingStrategy(){

            public String getDefinitionNameForKey(DefinitionKey key, SchemaGenerationContext context) {
                TypeContext typeContext = context.getTypeContext();
                ResolvedType type = key.getType();
                return typeContext.getFullTypeDescription(type);
            }

            public String adjustNullableName(DefinitionKey key, String definitionName, SchemaGenerationContext context) {
                return definitionName;
            }
        });
        builder.forTypesInGeneral().withCustomDefinitionProvider(new CustomDefinitionProviderV2(){

            public CustomDefinition provideCustomSchemaDefinition(ResolvedType javaType, SchemaGenerationContext context) {
                if (javaType.isInstanceOf(Map.class) || javaType.isInstanceOf(Enum.class)) {
                    ObjectNode definition = context.createStandardDefinition(javaType, (CustomDefinitionProviderV2)this);
                    return new CustomDefinition(definition, true);
                }
                if (javaType.isInstanceOf(Duration.class)) {
                    ObjectNode definitionReference = context.createDefinitionReference(context.getTypeContext().resolve(String.class, new Type[0])).put("format", "duration");
                    return new CustomDefinition(definitionReference, true);
                }
                return null;
            }
        });
        builder.forFields().withInstanceAttributeOverride((memberAttributes, member, context) -> {
            Schema schema;
            PluginProperty pluginPropertyAnnotation = (PluginProperty)member.getAnnotationConsideringFieldAndGetter(PluginProperty.class);
            if (pluginPropertyAnnotation != null) {
                memberAttributes.put("$dynamic", pluginPropertyAnnotation.dynamic());
            }
            if ((schema = (Schema)member.getAnnotationConsideringFieldAndGetter(Schema.class)) != null && schema.deprecated()) {
                memberAttributes.put("$deprecated", true);
            }
        });
        builder.forTypesInGeneral().withTypeAttributeOverride((collectedTypeAttributes, scope, context) -> {
            Plugin pluginAnnotation = scope.getType().getErasedType().getAnnotation(Plugin.class);
            if (pluginAnnotation != null) {
                List metrics;
                List examples = Arrays.stream(pluginAnnotation.examples()).map(example -> context.getGeneratorConfig().createObjectNode().put("full", example.full()).put("code", String.join((CharSequence)"\n", example.code())).put("lang", example.lang()).put("title", example.title())).collect(Collectors.toList());
                if (!examples.isEmpty()) {
                    collectedTypeAttributes.set("$examples", (JsonNode)context.getGeneratorConfig().createArrayNode().addAll(examples));
                }
                if (!(metrics = Arrays.stream(pluginAnnotation.metrics()).map(metric -> context.getGeneratorConfig().createObjectNode().put("name", metric.name()).put("type", metric.type()).put("unit", metric.unit()).put("description", metric.description())).collect(Collectors.toList())).isEmpty()) {
                    collectedTypeAttributes.set("$metrics", (JsonNode)context.getGeneratorConfig().createArrayNode().addAll(metrics));
                }
            }
            Schema schema = scope.getType().getErasedType().getAnnotation(Schema.class);
            Deprecated deprecated = scope.getType().getErasedType().getAnnotation(Deprecated.class);
            if (schema != null && schema.deprecated() || deprecated != null) {
                collectedTypeAttributes.put("$deprecated", "true");
            }
        });
        builder.forFields().withAdditionalPropertiesResolver(target -> {
            PluginProperty pluginPropertyAnnotation = (PluginProperty)target.getAnnotationConsideringFieldAndGetter(PluginProperty.class);
            if (pluginPropertyAnnotation != null) {
                return pluginPropertyAnnotation.additionalProperties();
            }
            return Object.class;
        });
        if (builder.build().getSchemaVersion() != SchemaVersion.DRAFT_2019_09) {
            builder.forTypesInGeneral().withSubtypeResolver((declaredType, context) -> {
                TypeContext typeContext = context.getTypeContext();
                if (declaredType.getErasedType() == Task.class) {
                    return this.getRegisteredPlugins().stream().flatMap(registeredPlugin -> registeredPlugin.getTasks().stream()).map(clz -> typeContext.resolveSubtype(declaredType, clz)).collect(Collectors.toList());
                }
                if (declaredType.getErasedType() == AbstractTrigger.class) {
                    return this.getRegisteredPlugins().stream().flatMap(registeredPlugin -> registeredPlugin.getTriggers().stream()).map(clz -> typeContext.resolveSubtype(declaredType, clz)).collect(Collectors.toList());
                }
                if (declaredType.getErasedType() == Condition.class) {
                    return this.getRegisteredPlugins().stream().flatMap(registeredPlugin -> registeredPlugin.getConditions().stream()).map(clz -> typeContext.resolveSubtype(declaredType, clz)).collect(Collectors.toList());
                }
                if (declaredType.getErasedType() == ScheduleCondition.class) {
                    return this.getRegisteredPlugins().stream().flatMap(registeredPlugin -> registeredPlugin.getConditions().stream()).filter(ScheduleCondition.class::isAssignableFrom).map(clz -> typeContext.resolveSubtype(declaredType, clz)).collect(Collectors.toList());
                }
                return null;
            });
            builder.forTypesInGeneral().withTypeAttributeOverride((collectedTypeAttributes, scope, context) -> this.mutateDescription(collectedTypeAttributes));
            builder.forFields().withInstanceAttributeOverride((collectedTypeAttributes, scope, context) -> this.mutateDescription(collectedTypeAttributes));
            builder.forTypesInGeneral().withTypeAttributeOverride((collectedTypeAttributes, scope, context) -> {
                if (collectedTypeAttributes.has("required") && collectedTypeAttributes.get("required") instanceof ArrayNode) {
                    ArrayNode required = context.getGeneratorConfig().createArrayNode();
                    collectedTypeAttributes.get("required").forEach(jsonNode -> {
                        if (!collectedTypeAttributes.get("properties").get(jsonNode.asText()).has("default") && !this.defaultInAllOf(collectedTypeAttributes.get("properties").get(jsonNode.asText()))) {
                            required.add(jsonNode.asText());
                        }
                    });
                    collectedTypeAttributes.set("required", (JsonNode)required);
                }
            });
            builder.forFields().withInstanceAttributeOverride((collectedTypeAttributes, scope, context) -> {
                if (collectedTypeAttributes.has("pattern") && collectedTypeAttributes.get("pattern").asText().contains("javaJavaIdentifier")) {
                    collectedTypeAttributes.remove("pattern");
                }
            });
            builder.forTypesInGeneral().withTypeAttributeOverride((collectedTypeAttributes, scope, context) -> {
                if (collectedTypeAttributes.has("$examples")) {
                    ArrayNode examples = (ArrayNode)collectedTypeAttributes.get("$examples");
                    String doc = StreamSupport.stream(examples.spliterator(), true).map(jsonNode -> {
                        Object description = "";
                        if (jsonNode.has("title")) {
                            description = (String)description + "> " + jsonNode.get("title").asText() + "\n";
                        }
                        description = (String)description + "```" + (jsonNode.has("lang") ? jsonNode.get("lang").asText() : "yaml") + "\n" + jsonNode.get("code").asText() + "\n```";
                        return description;
                    }).collect(Collectors.joining("\n\n"));
                    Object description = collectedTypeAttributes.has("markdownDescription") ? collectedTypeAttributes.get("markdownDescription").asText() : "";
                    description = (String)description + "##### Examples\n" + doc;
                    collectedTypeAttributes.set("markdownDescription", (JsonNode)new TextNode((String)description));
                    collectedTypeAttributes.remove("$examples");
                }
            });
        }
    }

    protected List<RegisteredPlugin> getRegisteredPlugins() {
        return this.pluginService.allPlugins();
    }

    private boolean defaultInAllOf(JsonNode property) {
        if (property.has("allOf")) {
            Iterator it = property.get("allOf").elements();
            while (it.hasNext()) {
                JsonNode child = (JsonNode)it.next();
                if (!child.has("default")) continue;
                return true;
            }
        }
        return false;
    }

    protected <T> Map<String, Object> generate(Class<? extends T> cls, @Nullable Class<T> base) {
        SchemaGeneratorConfigBuilder builder = new SchemaGeneratorConfigBuilder(SchemaVersion.DRAFT_2019_09, OptionPreset.PLAIN_JSON);
        this.build(builder, false);
        builder.forFields().withIgnoreCheck(fieldScope -> base != null && fieldScope.getAnnotation(PluginProperty.class) == null && fieldScope.getDeclaringType().getTypeName().equals(base.getName()));
        SchemaGeneratorConfig schemaGeneratorConfig = builder.build();
        SchemaGenerator generator = new SchemaGenerator(schemaGeneratorConfig);
        try {
            ObjectNode objectNode = generator.generateSchema(cls, new Type[0]);
            return JacksonMapper.toMap(this.extractMainRef(objectNode));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unable to generate jsonschema for '" + cls.getName() + "'", e);
        }
    }

    protected Object defaults(FieldScope target) {
        Object instance;
        Optional<HierarchicType> concreteCls;
        if (target.getOverriddenType() != null) {
            return null;
        }
        Class baseCls = ((ResolvedField)target.getMember()).getDeclaringType().getErasedType();
        if (Modifier.isAbstract(baseCls.getModifiers()) && (concreteCls = target.getDeclaringTypeMembers().mainTypeAndOverrides().stream().filter(type -> !type.isMixin()).findFirst()).isPresent()) {
            baseCls = concreteCls.get().getErasedType();
        }
        if (!this.defaultInstances.containsKey(baseCls)) {
            this.defaultInstances.put(baseCls, this.buildDefaultInstance(baseCls));
        }
        return (instance = this.defaultInstances.get(baseCls)) == null ? null : this.defaultValue(instance, baseCls, target.getName());
    }

    private ObjectNode extractMainRef(ObjectNode objectNode) {
        TextNode ref = (TextNode)objectNode.get("$ref");
        ObjectNode defs = (ObjectNode)objectNode.get("$defs");
        if (ref == null) {
            throw new IllegalArgumentException("Missing $ref");
        }
        String mainClassName = ref.asText().substring(ref.asText().lastIndexOf("/") + 1);
        if (mainClassName.endsWith("-2")) {
            mainClassName = mainClassName.substring(0, mainClassName.length() - 2);
            JsonNode mainClassDef = defs.get(mainClassName + "-1");
            this.addMainRefProperties(mainClassDef, objectNode);
            defs.remove(mainClassName + "-1");
            defs.remove(mainClassName + "-2");
        } else {
            JsonNode mainClassDef = defs.get(mainClassName);
            this.addMainRefProperties(mainClassDef, objectNode);
            defs.remove(mainClassName);
        }
        objectNode.remove("$ref");
        return objectNode;
    }

    private void addMainRefProperties(JsonNode mainClassDef, ObjectNode objectNode) {
        objectNode.set("properties", mainClassDef.get("properties"));
        if (mainClassDef.has("required")) {
            objectNode.set("required", mainClassDef.get("required"));
        }
        if (mainClassDef.has("title")) {
            objectNode.set("title", mainClassDef.get("title"));
        }
        if (mainClassDef.has("description")) {
            objectNode.set("description", mainClassDef.get("description"));
        }
        if (mainClassDef.has("$examples")) {
            objectNode.set("$examples", mainClassDef.get("$examples"));
        }
        if (mainClassDef.has("$metrics")) {
            objectNode.set("$metrics", mainClassDef.get("$metrics"));
        }
        if (mainClassDef.has("$deprecated")) {
            objectNode.set("$deprecated", mainClassDef.get("$deprecated"));
        }
    }

    private Object buildDefaultInstance(Class<?> cls) {
        try {
            Method builderMethod = cls.getMethod("builder", new Class[0]);
            Object builder = builderMethod.invoke(null, new Object[0]);
            Method build = builder.getClass().getMethod("build", new Class[0]);
            build.setAccessible(true);
            return build.invoke(builder, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }

    private Object defaultValue(Object instance, Class<?> cls, String fieldName) {
        try {
            Method field = cls.getMethod("get" + fieldName.substring(0, 1).toUpperCase(Locale.ROOT) + fieldName.substring(1), new Class[0]);
            field.setAccessible(true);
            return field.invoke(instance, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException field) {
            try {
                Method field2 = cls.getMethod("is" + fieldName.substring(0, 1).toUpperCase(Locale.ROOT) + fieldName.substring(1), new Class[0]);
                field2.setAccessible(true);
                return field2.invoke(instance, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException exception) {
                return null;
            }
        }
    }
}

