/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.docs;

import io.kestra.core.plugins.RegisteredPlugin;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public class Plugin {
    private String name;
    private String title;
    private String description;
    private String longDescription;
    private String group;
    private String version;
    private Map<String, String> manifest;
    private List<String> tasks;
    private List<String> triggers;
    private List<String> conditions;
    private List<String> controllers;
    private List<String> storages;
    private List<String> secrets;
    private List<String> guides;

    public static Plugin of(RegisteredPlugin registeredPlugin) {
        Plugin plugin = new Plugin();
        plugin.name = registeredPlugin.name();
        plugin.title = registeredPlugin.title();
        plugin.group = registeredPlugin.group();
        plugin.description = registeredPlugin.description();
        plugin.longDescription = registeredPlugin.longDescription();
        plugin.version = registeredPlugin.version();
        plugin.guides = registeredPlugin.getGuides();
        plugin.manifest = registeredPlugin.getManifest().getMainAttributes().entrySet().stream().map(e -> new AbstractMap.SimpleEntry<String, String>(e.getKey().toString(), e.getValue().toString())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        plugin.tasks = Plugin.className((Class[])Plugin.filter(registeredPlugin.getTasks()).toArray(Class[]::new));
        plugin.triggers = Plugin.className((Class[])Plugin.filter(registeredPlugin.getTriggers()).toArray(Class[]::new));
        plugin.conditions = Plugin.className((Class[])Plugin.filter(registeredPlugin.getConditions()).toArray(Class[]::new));
        plugin.controllers = Plugin.className((Class[])Plugin.filter(registeredPlugin.getControllers()).toArray(Class[]::new));
        plugin.storages = Plugin.className((Class[])Plugin.filter(registeredPlugin.getStorages()).toArray(Class[]::new));
        plugin.secrets = Plugin.className((Class[])Plugin.filter(registeredPlugin.getSecrets()).toArray(Class[]::new));
        return plugin;
    }

    private static <T extends Class<?>> Stream<T> filter(List<T> list) {
        return list.stream().filter(s -> !s.getName().startsWith("org.kestra."));
    }

    private static <T> List<String> className(Class[] classes) {
        return Arrays.stream(classes).map(Class::getName).collect(Collectors.toList());
    }

    @Generated
    public Plugin() {
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getLongDescription() {
        return this.longDescription;
    }

    @Generated
    public String getGroup() {
        return this.group;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public Map<String, String> getManifest() {
        return this.manifest;
    }

    @Generated
    public List<String> getTasks() {
        return this.tasks;
    }

    @Generated
    public List<String> getTriggers() {
        return this.triggers;
    }

    @Generated
    public List<String> getConditions() {
        return this.conditions;
    }

    @Generated
    public List<String> getControllers() {
        return this.controllers;
    }

    @Generated
    public List<String> getStorages() {
        return this.storages;
    }

    @Generated
    public List<String> getSecrets() {
        return this.secrets;
    }

    @Generated
    public List<String> getGuides() {
        return this.guides;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setLongDescription(String longDescription) {
        this.longDescription = longDescription;
    }

    @Generated
    public void setGroup(String group) {
        this.group = group;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setManifest(Map<String, String> manifest) {
        this.manifest = manifest;
    }

    @Generated
    public void setTasks(List<String> tasks) {
        this.tasks = tasks;
    }

    @Generated
    public void setTriggers(List<String> triggers) {
        this.triggers = triggers;
    }

    @Generated
    public void setConditions(List<String> conditions) {
        this.conditions = conditions;
    }

    @Generated
    public void setControllers(List<String> controllers) {
        this.controllers = controllers;
    }

    @Generated
    public void setStorages(List<String> storages) {
        this.storages = storages;
    }

    @Generated
    public void setSecrets(List<String> secrets) {
        this.secrets = secrets;
    }

    @Generated
    public void setGuides(List<String> guides) {
        this.guides = guides;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Plugin)) {
            return false;
        }
        Plugin other = (Plugin)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$longDescription = this.getLongDescription();
        String other$longDescription = other.getLongDescription();
        if (this$longDescription == null ? other$longDescription != null : !this$longDescription.equals(other$longDescription)) {
            return false;
        }
        String this$group = this.getGroup();
        String other$group = other.getGroup();
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        Map<String, String> this$manifest = this.getManifest();
        Map<String, String> other$manifest = other.getManifest();
        if (this$manifest == null ? other$manifest != null : !((Object)this$manifest).equals(other$manifest)) {
            return false;
        }
        List<String> this$tasks = this.getTasks();
        List<String> other$tasks = other.getTasks();
        if (this$tasks == null ? other$tasks != null : !((Object)this$tasks).equals(other$tasks)) {
            return false;
        }
        List<String> this$triggers = this.getTriggers();
        List<String> other$triggers = other.getTriggers();
        if (this$triggers == null ? other$triggers != null : !((Object)this$triggers).equals(other$triggers)) {
            return false;
        }
        List<String> this$conditions = this.getConditions();
        List<String> other$conditions = other.getConditions();
        if (this$conditions == null ? other$conditions != null : !((Object)this$conditions).equals(other$conditions)) {
            return false;
        }
        List<String> this$controllers = this.getControllers();
        List<String> other$controllers = other.getControllers();
        if (this$controllers == null ? other$controllers != null : !((Object)this$controllers).equals(other$controllers)) {
            return false;
        }
        List<String> this$storages = this.getStorages();
        List<String> other$storages = other.getStorages();
        if (this$storages == null ? other$storages != null : !((Object)this$storages).equals(other$storages)) {
            return false;
        }
        List<String> this$secrets = this.getSecrets();
        List<String> other$secrets = other.getSecrets();
        if (this$secrets == null ? other$secrets != null : !((Object)this$secrets).equals(other$secrets)) {
            return false;
        }
        List<String> this$guides = this.getGuides();
        List<String> other$guides = other.getGuides();
        return !(this$guides == null ? other$guides != null : !((Object)this$guides).equals(other$guides));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Plugin;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $longDescription = this.getLongDescription();
        result = result * 59 + ($longDescription == null ? 43 : $longDescription.hashCode());
        String $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        Map<String, String> $manifest = this.getManifest();
        result = result * 59 + ($manifest == null ? 43 : ((Object)$manifest).hashCode());
        List<String> $tasks = this.getTasks();
        result = result * 59 + ($tasks == null ? 43 : ((Object)$tasks).hashCode());
        List<String> $triggers = this.getTriggers();
        result = result * 59 + ($triggers == null ? 43 : ((Object)$triggers).hashCode());
        List<String> $conditions = this.getConditions();
        result = result * 59 + ($conditions == null ? 43 : ((Object)$conditions).hashCode());
        List<String> $controllers = this.getControllers();
        result = result * 59 + ($controllers == null ? 43 : ((Object)$controllers).hashCode());
        List<String> $storages = this.getStorages();
        result = result * 59 + ($storages == null ? 43 : ((Object)$storages).hashCode());
        List<String> $secrets = this.getSecrets();
        result = result * 59 + ($secrets == null ? 43 : ((Object)$secrets).hashCode());
        List<String> $guides = this.getGuides();
        result = result * 59 + ($guides == null ? 43 : ((Object)$guides).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Plugin(name=" + this.getName() + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ", longDescription=" + this.getLongDescription() + ", group=" + this.getGroup() + ", version=" + this.getVersion() + ", manifest=" + this.getManifest() + ", tasks=" + this.getTasks() + ", triggers=" + this.getTriggers() + ", conditions=" + this.getConditions() + ", controllers=" + this.getControllers() + ", storages=" + this.getStorages() + ", secrets=" + this.getSecrets() + ", guides=" + this.getGuides() + ")";
    }
}

