/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.conditions.types;

import io.kestra.core.exceptions.InternalException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.conditions.ScheduleCondition;
import io.kestra.core.utils.DateUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import javax.validation.constraints.NotNull;
import lombok.Generated;

@Schema(title="Condition for allows events on weekdays relative to current month (first, last, ...)")
@Plugin(examples={@Example(full=true, code={"- conditions:", "    - type: io.kestra.core.models.conditions.types.DayWeekInMonthCondition", "      dayOfWeek: MONDAY", "      dayInMonth: FIRST"})})
public class DayWeekInMonthCondition
extends Condition
implements ScheduleCondition {
    @NotNull
    @Schema(title="The date to test", description="Can be any variable or any valid ISO 8601 datetime, default will use `{{ now(format=\"iso_local_date\") }}`")
    @PluginProperty(dynamic=true)
    private final String date;
    @NotNull
    @Schema(title="The day of week")
    @PluginProperty
    private DayOfWeek dayOfWeek;
    @NotNull
    @Schema(title="Are you looking at first or last day in month")
    @PluginProperty
    private DayInMonth dayInMonth;

    @Override
    public boolean test(ConditionContext conditionContext) throws InternalException {
        LocalDate computed;
        String render = conditionContext.getRunContext().render(this.date, conditionContext.getVariables());
        LocalDate currentDate = DateUtils.parseLocalDate(render);
        if (this.dayInMonth.equals((Object)DayInMonth.FIRST)) {
            computed = currentDate.with(TemporalAdjusters.firstInMonth(this.dayOfWeek));
        } else if (this.dayInMonth.equals((Object)DayInMonth.LAST)) {
            computed = currentDate.with(TemporalAdjusters.lastInMonth(this.dayOfWeek));
        } else if (this.dayInMonth.equals((Object)DayInMonth.SECOND)) {
            computed = currentDate.with(TemporalAdjusters.firstInMonth(this.dayOfWeek)).with(TemporalAdjusters.next(this.dayOfWeek));
        } else if (this.dayInMonth.equals((Object)DayInMonth.THIRD)) {
            computed = currentDate.with(TemporalAdjusters.firstInMonth(this.dayOfWeek)).with(TemporalAdjusters.next(this.dayOfWeek)).with(TemporalAdjusters.next(this.dayOfWeek));
        } else if (this.dayInMonth.equals((Object)DayInMonth.FOURTH)) {
            computed = currentDate.with(TemporalAdjusters.firstInMonth(this.dayOfWeek)).with(TemporalAdjusters.next(this.dayOfWeek)).with(TemporalAdjusters.next(this.dayOfWeek)).with(TemporalAdjusters.next(this.dayOfWeek));
        } else {
            throw new IllegalArgumentException("Invalid dayInMonth");
        }
        return computed.isEqual(currentDate);
    }

    @Generated
    private static String $default$date() {
        return "{{ now(format=\"iso_local_date\") }}";
    }

    @Generated
    protected DayWeekInMonthCondition(DayWeekInMonthConditionBuilder<?, ?> b) {
        super(b);
        this.date = b.date$set ? b.date$value : DayWeekInMonthCondition.$default$date();
        this.dayOfWeek = b.dayOfWeek;
        this.dayInMonth = b.dayInMonth;
    }

    @Generated
    public static DayWeekInMonthConditionBuilder<?, ?> builder() {
        return new DayWeekInMonthConditionBuilderImpl();
    }

    @Generated
    public String toString() {
        return "DayWeekInMonthCondition(super=" + super.toString() + ", date=" + this.getDate() + ", dayOfWeek=" + this.getDayOfWeek() + ", dayInMonth=" + this.getDayInMonth() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DayWeekInMonthCondition)) {
            return false;
        }
        DayWeekInMonthCondition other = (DayWeekInMonthCondition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$date = this.getDate();
        String other$date = other.getDate();
        if (this$date == null ? other$date != null : !this$date.equals(other$date)) {
            return false;
        }
        DayOfWeek this$dayOfWeek = this.getDayOfWeek();
        DayOfWeek other$dayOfWeek = other.getDayOfWeek();
        if (this$dayOfWeek == null ? other$dayOfWeek != null : !this$dayOfWeek.equals(other$dayOfWeek)) {
            return false;
        }
        DayInMonth this$dayInMonth = this.getDayInMonth();
        DayInMonth other$dayInMonth = other.getDayInMonth();
        return !(this$dayInMonth == null ? other$dayInMonth != null : !((Object)((Object)this$dayInMonth)).equals((Object)other$dayInMonth));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DayWeekInMonthCondition;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : $date.hashCode());
        DayOfWeek $dayOfWeek = this.getDayOfWeek();
        result = result * 59 + ($dayOfWeek == null ? 43 : $dayOfWeek.hashCode());
        DayInMonth $dayInMonth = this.getDayInMonth();
        result = result * 59 + ($dayInMonth == null ? 43 : ((Object)((Object)$dayInMonth)).hashCode());
        return result;
    }

    @Generated
    public String getDate() {
        return this.date;
    }

    @Generated
    public DayOfWeek getDayOfWeek() {
        return this.dayOfWeek;
    }

    @Generated
    public DayInMonth getDayInMonth() {
        return this.dayInMonth;
    }

    @Generated
    public DayWeekInMonthCondition() {
        this.date = DayWeekInMonthCondition.$default$date();
    }

    public static enum DayInMonth {
        FIRST,
        LAST,
        SECOND,
        THIRD,
        FOURTH;

    }

    @Generated
    public static abstract class DayWeekInMonthConditionBuilder<C extends DayWeekInMonthCondition, B extends DayWeekInMonthConditionBuilder<C, B>>
    extends Condition.ConditionBuilder<C, B> {
        @Generated
        private boolean date$set;
        @Generated
        private String date$value;
        @Generated
        private DayOfWeek dayOfWeek;
        @Generated
        private DayInMonth dayInMonth;

        @Generated
        public B date(String date) {
            this.date$value = date;
            this.date$set = true;
            return (B)this.self();
        }

        @Generated
        public B dayOfWeek(DayOfWeek dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
            return (B)this.self();
        }

        @Generated
        public B dayInMonth(DayInMonth dayInMonth) {
            this.dayInMonth = dayInMonth;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "DayWeekInMonthCondition.DayWeekInMonthConditionBuilder(super=" + super.toString() + ", date$value=" + this.date$value + ", dayOfWeek=" + this.dayOfWeek + ", dayInMonth=" + this.dayInMonth + ")";
        }
    }

    @Generated
    private static final class DayWeekInMonthConditionBuilderImpl
    extends DayWeekInMonthConditionBuilder<DayWeekInMonthCondition, DayWeekInMonthConditionBuilderImpl> {
        @Generated
        private DayWeekInMonthConditionBuilderImpl() {
        }

        @Override
        @Generated
        protected DayWeekInMonthConditionBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DayWeekInMonthCondition build() {
            return new DayWeekInMonthCondition(this);
        }
    }
}

