/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.conditions.types;

import io.kestra.core.exceptions.InternalException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.conditions.ScheduleCondition;
import io.kestra.core.utils.Rethrow;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Generated;

@Schema(title="Condition to exclude others conditions")
@Plugin(examples={@Example(full=true, code={"- conditions:", "    - type: io.kestra.core.models.conditions.types.NotCondition", "      conditions:", "      -  type: io.kestra.core.models.conditions.types.DateBetweenCondition", "         after: \"2013-09-08T16:19:12\""})})
public class NotCondition
extends Condition
implements ScheduleCondition {
    @NotNull
    @NotEmpty
    @Schema(title="The list of conditions to exclude", description="If any conditions is true, it will prevent events execution.")
    @PluginProperty
    private List<Condition> conditions;

    @Override
    public boolean test(ConditionContext conditionContext) throws InternalException {
        return this.conditions.stream().noneMatch(Rethrow.throwPredicate(condition -> condition.test(conditionContext)));
    }

    @Generated
    protected NotCondition(NotConditionBuilder<?, ?> b) {
        super(b);
        this.conditions = b.conditions;
    }

    @Generated
    public static NotConditionBuilder<?, ?> builder() {
        return new NotConditionBuilderImpl();
    }

    @Generated
    public String toString() {
        return "NotCondition(super=" + super.toString() + ", conditions=" + this.getConditions() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NotCondition)) {
            return false;
        }
        NotCondition other = (NotCondition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<Condition> this$conditions = this.getConditions();
        List<Condition> other$conditions = other.getConditions();
        return !(this$conditions == null ? other$conditions != null : !((Object)this$conditions).equals(other$conditions));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NotCondition;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<Condition> $conditions = this.getConditions();
        result = result * 59 + ($conditions == null ? 43 : ((Object)$conditions).hashCode());
        return result;
    }

    @Generated
    public List<Condition> getConditions() {
        return this.conditions;
    }

    @Generated
    public NotCondition() {
    }

    @Generated
    public static abstract class NotConditionBuilder<C extends NotCondition, B extends NotConditionBuilder<C, B>>
    extends Condition.ConditionBuilder<C, B> {
        @Generated
        private List<Condition> conditions;

        @Generated
        public B conditions(List<Condition> conditions) {
            this.conditions = conditions;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "NotCondition.NotConditionBuilder(super=" + super.toString() + ", conditions=" + this.conditions + ")";
        }
    }

    @Generated
    private static final class NotConditionBuilderImpl
    extends NotConditionBuilder<NotCondition, NotConditionBuilderImpl> {
        @Generated
        private NotConditionBuilderImpl() {
        }

        @Override
        @Generated
        protected NotConditionBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public NotCondition build() {
            return new NotCondition(this);
        }
    }
}

