/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.flows.input;

import io.kestra.core.models.flows.Input;
import io.kestra.core.models.validations.ManualConstraintViolation;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.Duration;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import lombok.Generated;

public class DurationInput
extends Input<Duration> {
    @Schema(title="Minimal value.")
    Duration min;
    @Schema(title="Maximal value.")
    Duration max;

    @Override
    public void validate(Duration input) throws ConstraintViolationException {
        if (this.min != null && input.compareTo(this.min) < 0) {
            throw new ConstraintViolationException("Invalid input '" + input + "', it must be more than '" + this.min + "'", Set.of(ManualConstraintViolation.of("Invalid input", this, DurationInput.class, this.getName(), input)));
        }
        if (this.max != null && input.compareTo(this.max) > 0) {
            throw new ConstraintViolationException("Invalid input '" + input + "', it must be less than '" + this.max + "'", Set.of(ManualConstraintViolation.of("Invalid input", this, DurationInput.class, this.getName(), input)));
        }
    }

    @Generated
    protected DurationInput(DurationInputBuilder<?, ?> b) {
        super((Input.InputBuilder)b);
        this.min = b.min;
        this.max = b.max;
    }

    @Generated
    public static DurationInputBuilder<?, ?> builder() {
        return new DurationInputBuilderImpl();
    }

    @Generated
    public Duration getMin() {
        return this.min;
    }

    @Generated
    public Duration getMax() {
        return this.max;
    }

    @Generated
    public DurationInput() {
    }

    @Generated
    public static abstract class DurationInputBuilder<C extends DurationInput, B extends DurationInputBuilder<C, B>>
    extends Input.InputBuilder<Duration, C, B> {
        @Generated
        private Duration min;
        @Generated
        private Duration max;

        @Generated
        public B min(Duration min) {
            this.min = min;
            return (B)this.self();
        }

        @Generated
        public B max(Duration max) {
            this.max = max;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "DurationInput.DurationInputBuilder(super=" + super.toString() + ", min=" + this.min + ", max=" + this.max + ")";
        }
    }

    @Generated
    private static final class DurationInputBuilderImpl
    extends DurationInputBuilder<DurationInput, DurationInputBuilderImpl> {
        @Generated
        private DurationInputBuilderImpl() {
        }

        @Override
        @Generated
        protected DurationInputBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DurationInput build() {
            return new DurationInput(this);
        }
    }
}

