/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.tasks;

import io.kestra.core.models.annotations.PluginProperty;
import io.micronaut.core.annotation.Introspected;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.util.List;
import javax.validation.Valid;
import lombok.Generated;

@Introspected
public class NamespaceFiles {
    @Schema(title="Whether to enable namespace files to be loaded into the working directory. If explicitly set to `true` in a task, it will load all [Namespace Files](https://kestra.io/docs/developer-guide/namespace-files) into the task's working directory. Note that this property is by default set to `true` so that you can specify only the `include` and `exclude` properties to filter the files to load without having to explicitly set `enabled` to `true`.")
    @PluginProperty
    private Boolean enabled;
    @Schema(title="A list of filters to include only matching glob patterns. This allows you to only load a subset of the [Namespace Files](https://kestra.io/docs/developer-guide/namespace-files) into the working directory.")
    @PluginProperty
    @Valid
    private List<String> include;
    @Schema(title="A list of filters to exclude matching glob patterns. This allows you to exclude a subset of the [Namespace Files](https://kestra.io/docs/developer-guide/namespace-files) from being downloaded at runtime. You can combine this property together with `include` to only inject a subset of files that you need into the task's working directory.")
    @PluginProperty
    @Valid
    private List<String> exclude;

    @Generated
    private static Boolean $default$enabled() {
        return true;
    }

    @Generated
    public static NamespaceFilesBuilder builder() {
        return new NamespaceFilesBuilder();
    }

    @Generated
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Generated
    public List<String> getInclude() {
        return this.include;
    }

    @Generated
    public List<String> getExclude() {
        return this.exclude;
    }

    @Generated
    public NamespaceFiles() {
        this.enabled = NamespaceFiles.$default$enabled();
    }

    @ConstructorProperties(value={"enabled", "include", "exclude"})
    @Generated
    public NamespaceFiles(Boolean enabled, List<String> include, List<String> exclude) {
        this.enabled = enabled;
        this.include = include;
        this.exclude = exclude;
    }

    @Generated
    public static class NamespaceFilesBuilder {
        @Generated
        private boolean enabled$set;
        @Generated
        private Boolean enabled$value;
        @Generated
        private List<String> include;
        @Generated
        private List<String> exclude;

        @Generated
        NamespaceFilesBuilder() {
        }

        @Generated
        public NamespaceFilesBuilder enabled(Boolean enabled) {
            this.enabled$value = enabled;
            this.enabled$set = true;
            return this;
        }

        @Generated
        public NamespaceFilesBuilder include(List<String> include) {
            this.include = include;
            return this;
        }

        @Generated
        public NamespaceFilesBuilder exclude(List<String> exclude) {
            this.exclude = exclude;
            return this;
        }

        @Generated
        public NamespaceFiles build() {
            Boolean enabled$value = this.enabled$value;
            if (!this.enabled$set) {
                enabled$value = NamespaceFiles.$default$enabled();
            }
            return new NamespaceFiles(enabled$value, this.include, this.exclude);
        }

        @Generated
        public String toString() {
            return "NamespaceFiles.NamespaceFilesBuilder(enabled$value=" + this.enabled$value + ", include=" + this.include + ", exclude=" + this.exclude + ")";
        }
    }
}

