/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.topologies;

import io.kestra.core.models.hierarchies.Graph;
import io.kestra.core.models.topologies.FlowNode;
import io.kestra.core.models.topologies.FlowRelation;
import java.beans.ConstructorProperties;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

public final class FlowTopologyGraph {
    private final Set<FlowNode> nodes;
    private final Set<Edge> edges;

    public static FlowTopologyGraph of(Graph<FlowNode, FlowRelation> graph) {
        return FlowTopologyGraph.builder().nodes(graph.nodes()).edges(graph.edges().stream().map(flowRelationEdge -> new Edge(((FlowNode)flowRelationEdge.getSource()).getUid(), ((FlowNode)flowRelationEdge.getTarget()).getUid(), (FlowRelation)((Object)((Object)flowRelationEdge.getValue())))).collect(Collectors.toSet())).build();
    }

    @ConstructorProperties(value={"nodes", "edges"})
    @Generated
    FlowTopologyGraph(Set<FlowNode> nodes, Set<Edge> edges) {
        this.nodes = nodes;
        this.edges = edges;
    }

    @Generated
    public static FlowTopologyGraphBuilder builder() {
        return new FlowTopologyGraphBuilder();
    }

    @Generated
    public Set<FlowNode> getNodes() {
        return this.nodes;
    }

    @Generated
    public Set<Edge> getEdges() {
        return this.edges;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlowTopologyGraph)) {
            return false;
        }
        FlowTopologyGraph other = (FlowTopologyGraph)o;
        Set<FlowNode> this$nodes = this.getNodes();
        Set<FlowNode> other$nodes = other.getNodes();
        if (this$nodes == null ? other$nodes != null : !((Object)this$nodes).equals(other$nodes)) {
            return false;
        }
        Set<Edge> this$edges = this.getEdges();
        Set<Edge> other$edges = other.getEdges();
        return !(this$edges == null ? other$edges != null : !((Object)this$edges).equals(other$edges));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<FlowNode> $nodes = this.getNodes();
        result = result * 59 + ($nodes == null ? 43 : ((Object)$nodes).hashCode());
        Set<Edge> $edges = this.getEdges();
        result = result * 59 + ($edges == null ? 43 : ((Object)$edges).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FlowTopologyGraph(nodes=" + this.getNodes() + ", edges=" + this.getEdges() + ")";
    }

    @Generated
    public static class FlowTopologyGraphBuilder {
        @Generated
        private Set<FlowNode> nodes;
        @Generated
        private Set<Edge> edges;

        @Generated
        FlowTopologyGraphBuilder() {
        }

        @Generated
        public FlowTopologyGraphBuilder nodes(Set<FlowNode> nodes) {
            this.nodes = nodes;
            return this;
        }

        @Generated
        public FlowTopologyGraphBuilder edges(Set<Edge> edges) {
            this.edges = edges;
            return this;
        }

        @Generated
        public FlowTopologyGraph build() {
            return new FlowTopologyGraph(this.nodes, this.edges);
        }

        @Generated
        public String toString() {
            return "FlowTopologyGraph.FlowTopologyGraphBuilder(nodes=" + this.nodes + ", edges=" + this.edges + ")";
        }
    }

    public static class Edge {
        private final String source;
        private final String target;
        private final FlowRelation relation;

        @Generated
        public String getSource() {
            return this.source;
        }

        @Generated
        public String getTarget() {
            return this.target;
        }

        @Generated
        public FlowRelation getRelation() {
            return this.relation;
        }

        @ConstructorProperties(value={"source", "target", "relation"})
        @Generated
        public Edge(String source, String target, FlowRelation relation) {
            this.source = source;
            this.target = target;
            this.relation = relation;
        }

        @Generated
        public String toString() {
            return "FlowTopologyGraph.Edge(source=" + this.getSource() + ", target=" + this.getTarget() + ", relation=" + this.getRelation() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Edge)) {
                return false;
            }
            Edge other = (Edge)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$source = this.getSource();
            String other$source = other.getSource();
            if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
                return false;
            }
            String this$target = this.getTarget();
            String other$target = other.getTarget();
            if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
                return false;
            }
            FlowRelation this$relation = this.getRelation();
            FlowRelation other$relation = other.getRelation();
            return !(this$relation == null ? other$relation != null : !((Object)((Object)this$relation)).equals((Object)other$relation));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Edge;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $source = this.getSource();
            result = result * 59 + ($source == null ? 43 : $source.hashCode());
            String $target = this.getTarget();
            result = result * 59 + ($target == null ? 43 : $target.hashCode());
            FlowRelation $relation = this.getRelation();
            result = result * 59 + ($relation == null ? 43 : ((Object)((Object)$relation)).hashCode());
            return result;
        }
    }
}

