/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.triggers;

import io.kestra.core.models.TenantInterface;
import io.kestra.core.utils.IdUtils;
import io.micronaut.core.annotation.Introspected;
import io.swagger.v3.oas.annotations.Hidden;
import java.time.ZonedDateTime;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import lombok.Generated;

@Introspected
public class TriggerContext
implements TenantInterface {
    @Hidden
    @Pattern(regexp="^[a-z0-9][a-z0-9_-]")
    private @Pattern(regexp="^[a-z0-9][a-z0-9_-]") String tenantId;
    @NotNull
    private String namespace;
    @NotNull
    private String flowId;
    @NotNull
    private Integer flowRevision;
    @NotNull
    private String triggerId;
    @NotNull
    private ZonedDateTime date;

    public String uid() {
        return TriggerContext.uid(this);
    }

    public static String uid(TriggerContext trigger) {
        return IdUtils.fromParts(trigger.getTenantId(), trigger.getNamespace(), trigger.getFlowId(), trigger.getTriggerId());
    }

    @Generated
    protected TriggerContext(TriggerContextBuilder<?, ?> b) {
        this.tenantId = b.tenantId;
        this.namespace = b.namespace;
        this.flowId = b.flowId;
        this.flowRevision = b.flowRevision;
        this.triggerId = b.triggerId;
        this.date = b.date;
    }

    @Generated
    public static TriggerContextBuilder<?, ?> builder() {
        return new TriggerContextBuilderImpl();
    }

    @Generated
    public TriggerContextBuilder<?, ?> toBuilder() {
        return new TriggerContextBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String toString() {
        return "TriggerContext(tenantId=" + this.getTenantId() + ", namespace=" + this.getNamespace() + ", flowId=" + this.getFlowId() + ", flowRevision=" + this.getFlowRevision() + ", triggerId=" + this.getTriggerId() + ", date=" + this.getDate() + ")";
    }

    @Override
    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public String getFlowId() {
        return this.flowId;
    }

    @Generated
    public Integer getFlowRevision() {
        return this.flowRevision;
    }

    @Generated
    public String getTriggerId() {
        return this.triggerId;
    }

    @Generated
    public ZonedDateTime getDate() {
        return this.date;
    }

    @Generated
    public TriggerContext() {
    }

    @Generated
    public static abstract class TriggerContextBuilder<C extends TriggerContext, B extends TriggerContextBuilder<C, B>> {
        @Generated
        private String tenantId;
        @Generated
        private String namespace;
        @Generated
        private String flowId;
        @Generated
        private Integer flowRevision;
        @Generated
        private String triggerId;
        @Generated
        private ZonedDateTime date;

        @Generated
        protected B $fillValuesFrom(C instance) {
            TriggerContextBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(TriggerContext instance, TriggerContextBuilder<?, ?> b) {
            b.tenantId(instance.tenantId);
            b.namespace(instance.namespace);
            b.flowId(instance.flowId);
            b.flowRevision(instance.flowRevision);
            b.triggerId(instance.triggerId);
            b.date(instance.date);
        }

        @Generated
        public B tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this.self();
        }

        @Generated
        public B namespace(String namespace) {
            this.namespace = namespace;
            return this.self();
        }

        @Generated
        public B flowId(String flowId) {
            this.flowId = flowId;
            return this.self();
        }

        @Generated
        public B flowRevision(Integer flowRevision) {
            this.flowRevision = flowRevision;
            return this.self();
        }

        @Generated
        public B triggerId(String triggerId) {
            this.triggerId = triggerId;
            return this.self();
        }

        @Generated
        public B date(ZonedDateTime date) {
            this.date = date;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "TriggerContext.TriggerContextBuilder(tenantId=" + this.tenantId + ", namespace=" + this.namespace + ", flowId=" + this.flowId + ", flowRevision=" + this.flowRevision + ", triggerId=" + this.triggerId + ", date=" + this.date + ")";
        }
    }

    @Generated
    private static final class TriggerContextBuilderImpl
    extends TriggerContextBuilder<TriggerContext, TriggerContextBuilderImpl> {
        @Generated
        private TriggerContextBuilderImpl() {
        }

        @Override
        @Generated
        protected TriggerContextBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public TriggerContext build() {
            return new TriggerContext(this);
        }
    }
}

