/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.triggers.multipleflows;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.utils.IdUtils;
import java.beans.ConstructorProperties;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public final class MultipleConditionWindow {
    private final String tenantId;
    private final String namespace;
    private final String flowId;
    private final String conditionId;
    private final ZonedDateTime start;
    private final ZonedDateTime end;
    private final Map<String, Boolean> results;

    @JsonIgnore
    public String uid() {
        return IdUtils.fromParts(this.tenantId, this.namespace, this.flowId, this.conditionId);
    }

    public static String uid(Flow flow, String conditionId) {
        return IdUtils.fromParts(flow.getTenantId(), flow.getNamespace(), flow.getId(), conditionId);
    }

    public boolean isValid(ZonedDateTime now) {
        return now.isAfter(this.getStart()) && now.isBefore(this.getEnd());
    }

    public MultipleConditionWindow with(Map<String, Boolean> newResult) {
        HashMap<String, Boolean> finalResults = new HashMap<String, Boolean>();
        if (this.results != null) {
            finalResults.putAll(this.results);
        }
        newResult.entrySet().stream().filter(Map.Entry::getValue).forEach(e -> finalResults.put((String)e.getKey(), true));
        return new MultipleConditionWindow(this.tenantId, this.namespace, this.flowId, this.conditionId, this.start, this.end, finalResults);
    }

    @ConstructorProperties(value={"tenantId", "namespace", "flowId", "conditionId", "start", "end", "results"})
    @Generated
    MultipleConditionWindow(String tenantId, String namespace, String flowId, String conditionId, ZonedDateTime start, ZonedDateTime end, Map<String, Boolean> results) {
        this.tenantId = tenantId;
        this.namespace = namespace;
        this.flowId = flowId;
        this.conditionId = conditionId;
        this.start = start;
        this.end = end;
        this.results = results;
    }

    @Generated
    public static MultipleConditionWindowBuilder builder() {
        return new MultipleConditionWindowBuilder();
    }

    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public String getFlowId() {
        return this.flowId;
    }

    @Generated
    public String getConditionId() {
        return this.conditionId;
    }

    @Generated
    public ZonedDateTime getStart() {
        return this.start;
    }

    @Generated
    public ZonedDateTime getEnd() {
        return this.end;
    }

    @Generated
    public Map<String, Boolean> getResults() {
        return this.results;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultipleConditionWindow)) {
            return false;
        }
        MultipleConditionWindow other = (MultipleConditionWindow)o;
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$flowId = this.getFlowId();
        String other$flowId = other.getFlowId();
        if (this$flowId == null ? other$flowId != null : !this$flowId.equals(other$flowId)) {
            return false;
        }
        String this$conditionId = this.getConditionId();
        String other$conditionId = other.getConditionId();
        if (this$conditionId == null ? other$conditionId != null : !this$conditionId.equals(other$conditionId)) {
            return false;
        }
        ZonedDateTime this$start = this.getStart();
        ZonedDateTime other$start = other.getStart();
        if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
            return false;
        }
        ZonedDateTime this$end = this.getEnd();
        ZonedDateTime other$end = other.getEnd();
        if (this$end == null ? other$end != null : !((Object)this$end).equals(other$end)) {
            return false;
        }
        Map<String, Boolean> this$results = this.getResults();
        Map<String, Boolean> other$results = other.getResults();
        return !(this$results == null ? other$results != null : !((Object)this$results).equals(other$results));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $flowId = this.getFlowId();
        result = result * 59 + ($flowId == null ? 43 : $flowId.hashCode());
        String $conditionId = this.getConditionId();
        result = result * 59 + ($conditionId == null ? 43 : $conditionId.hashCode());
        ZonedDateTime $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
        ZonedDateTime $end = this.getEnd();
        result = result * 59 + ($end == null ? 43 : ((Object)$end).hashCode());
        Map<String, Boolean> $results = this.getResults();
        result = result * 59 + ($results == null ? 43 : ((Object)$results).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MultipleConditionWindow(tenantId=" + this.getTenantId() + ", namespace=" + this.getNamespace() + ", flowId=" + this.getFlowId() + ", conditionId=" + this.getConditionId() + ", start=" + this.getStart() + ", end=" + this.getEnd() + ", results=" + this.getResults() + ")";
    }

    @Generated
    public static class MultipleConditionWindowBuilder {
        @Generated
        private String tenantId;
        @Generated
        private String namespace;
        @Generated
        private String flowId;
        @Generated
        private String conditionId;
        @Generated
        private ZonedDateTime start;
        @Generated
        private ZonedDateTime end;
        @Generated
        private Map<String, Boolean> results;

        @Generated
        MultipleConditionWindowBuilder() {
        }

        @Generated
        public MultipleConditionWindowBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public MultipleConditionWindowBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Generated
        public MultipleConditionWindowBuilder flowId(String flowId) {
            this.flowId = flowId;
            return this;
        }

        @Generated
        public MultipleConditionWindowBuilder conditionId(String conditionId) {
            this.conditionId = conditionId;
            return this;
        }

        @Generated
        public MultipleConditionWindowBuilder start(ZonedDateTime start) {
            this.start = start;
            return this;
        }

        @Generated
        public MultipleConditionWindowBuilder end(ZonedDateTime end) {
            this.end = end;
            return this;
        }

        @Generated
        public MultipleConditionWindowBuilder results(Map<String, Boolean> results) {
            this.results = results;
            return this;
        }

        @Generated
        public MultipleConditionWindow build() {
            return new MultipleConditionWindow(this.tenantId, this.namespace, this.flowId, this.conditionId, this.start, this.end, this.results);
        }

        @Generated
        public String toString() {
            return "MultipleConditionWindow.MultipleConditionWindowBuilder(tenantId=" + this.tenantId + ", namespace=" + this.namespace + ", flowId=" + this.flowId + ", conditionId=" + this.conditionId + ", start=" + this.start + ", end=" + this.end + ", results=" + this.results + ")";
        }
    }
}

