/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.queues;

import io.kestra.core.exceptions.DeserializationException;
import io.kestra.core.queues.QueueException;
import io.kestra.core.utils.Either;
import java.io.Closeable;
import java.util.function.Consumer;

public interface QueueInterface<T>
extends Closeable {
    default public void emit(T message) throws QueueException {
        this.emit(null, message);
    }

    public void emit(String var1, T var2) throws QueueException;

    default public void emitAsync(T message) throws QueueException {
        this.emitAsync(null, message);
    }

    public void emitAsync(String var1, T var2) throws QueueException;

    default public void delete(T message) throws QueueException {
        this.delete(null, message);
    }

    public void delete(String var1, T var2) throws QueueException;

    default public Runnable receive(Consumer<Either<T, DeserializationException>> consumer) {
        return this.receive((String)null, consumer);
    }

    public Runnable receive(String var1, Consumer<Either<T, DeserializationException>> var2);

    default public Runnable receive(Class<?> queueType, Consumer<Either<T, DeserializationException>> consumer) {
        return this.receive(null, queueType, consumer);
    }

    public Runnable receive(String var1, Class<?> var2, Consumer<Either<T, DeserializationException>> var3);

    public void pause();
}

