/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import com.google.common.collect.ImmutableMap;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.exceptions.InternalException;
import io.kestra.core.models.Label;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.ExecutionTrigger;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.executions.TaskRunAttempt;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowWithException;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.tasks.ExecutableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.FlowExecutorInterface;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.RunnerUtils;
import io.kestra.core.runners.WorkerTaskExecution;
import io.kestra.core.runners.WorkerTaskResult;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class ExecutableUtils {
    private ExecutableUtils() {
    }

    public static State.Type guessState(Execution execution, boolean transmitFailed, State.Type defaultState) {
        if (transmitFailed && (execution.getState().isFailed() || execution.getState().isPaused() || execution.getState().getCurrent() == State.Type.KILLED || execution.getState().getCurrent() == State.Type.WARNING)) {
            return execution.getState().getCurrent();
        }
        return defaultState;
    }

    public static WorkerTaskResult workerTaskResult(TaskRun taskRun) {
        return WorkerTaskResult.builder().taskRun(taskRun.withAttempts(Collections.singletonList(TaskRunAttempt.builder().state(new State().withState(taskRun.getState().getCurrent())).build()))).build();
    }

    public static <T extends Task> WorkerTaskExecution<?> workerTaskExecution(RunContext runContext, FlowExecutorInterface flowExecutorInterface, Execution currentExecution, Flow currentFlow, T currentTask, TaskRun currentTaskRun, Map<String, Object> inputs, List<Label> labels, Integer iteration) throws IllegalVariableEvaluationException {
        String subflowNamespace = runContext.render(((ExecutableTask)((Object)currentTask)).subflowId().namespace());
        String subflowId = runContext.render(((ExecutableTask)((Object)currentTask)).subflowId().flowId());
        Optional<Integer> subflowRevision = ((ExecutableTask)((Object)currentTask)).subflowId().revision();
        Flow flow = flowExecutorInterface.findByIdFromFlowTask(currentExecution.getTenantId(), subflowNamespace, subflowId, subflowRevision, currentExecution.getTenantId(), currentFlow.getNamespace(), currentFlow.getId()).orElseThrow(() -> new IllegalStateException("Unable to find flow '" + subflowNamespace + "'.'" + subflowId + "' with revision + '" + subflowRevision.orElse(0) + "'"));
        if (flow.isDisabled()) {
            throw new IllegalStateException("Cannot execute a flow which is disabled");
        }
        if (flow instanceof FlowWithException) {
            FlowWithException fwe = (FlowWithException)flow;
            throw new IllegalStateException("Cannot execute an invalid flow: " + fwe.getException());
        }
        ImmutableMap variables = ImmutableMap.of((Object)"executionId", (Object)currentExecution.getId(), (Object)"namespace", (Object)currentFlow.getNamespace(), (Object)"flowId", (Object)currentFlow.getId(), (Object)"flowRevision", (Object)currentFlow.getRevision());
        RunnerUtils runnerUtils = (RunnerUtils)runContext.getApplicationContext().getBean(RunnerUtils.class);
        Execution execution = runnerUtils.newExecution(flow, (f, e) -> runnerUtils.typedInputs((Flow)f, (Execution)e, inputs), labels).withTrigger(ExecutionTrigger.builder().id(currentTask.getId()).type(currentTask.getType()).variables((Map<String, Object>)variables).build());
        return WorkerTaskExecution.builder().task(currentTask).taskRun(currentTaskRun.withState(State.Type.RUNNING)).execution(execution).iteration(iteration).build();
    }

    public static TaskRun manageIterations(TaskRun taskRun, Execution execution, boolean transmitFailed) throws InternalException {
        if (taskRun.getOutputs() != null && taskRun.getOutputs().containsKey("iterations")) {
            Map taskRunIteration = (Map)taskRun.getOutputs().get("iterations");
            int maxIterations = (Integer)taskRunIteration.get("max");
            TaskRun previousTaskRun = execution.findTaskRunByTaskRunId(taskRun.getId());
            if (previousTaskRun != null) {
                int terminatedIterations;
                Map iterations = previousTaskRun.getOutputs() != null ? (Map)previousTaskRun.getOutputs().get("iterations") : taskRunIteration;
                State.Type currentState = taskRun.getState().getCurrent();
                Optional previousState = taskRun.getState().getHistories().size() > 1 ? Optional.of(taskRun.getState().getHistories().get(taskRun.getState().getHistories().size() - 2).getState()) : Optional.empty();
                int currentStateIteration = iterations.getOrDefault(currentState.toString(), 0);
                iterations.put(currentState.toString(), currentStateIteration + 1);
                if (previousState.isPresent() && previousState.get() != currentState) {
                    int previousStateIterations = iterations.getOrDefault(((State.Type)((Object)previousState.get())).toString(), maxIterations);
                    iterations.put(((State.Type)((Object)previousState.get())).toString(), previousStateIterations - 1);
                }
                if ((terminatedIterations = iterations.getOrDefault(State.Type.SUCCESS.toString(), 0) + iterations.getOrDefault(State.Type.FAILED.toString(), 0) + iterations.getOrDefault(State.Type.KILLED.toString(), 0) + iterations.getOrDefault(State.Type.WARNING.toString(), 0) + iterations.getOrDefault(State.Type.CANCELLED.toString(), 0)) != maxIterations && taskRun.getState().isTerminated()) {
                    return previousTaskRun.withOutputs(Map.of("iterations", iterations));
                }
                if (terminatedIterations == maxIterations && taskRun.getState().isTerminated()) {
                    State.Type state = transmitFailed ? ExecutableUtils.findTerminalState(iterations) : State.Type.SUCCESS;
                    return previousTaskRun.withOutputs(Map.of("iterations", iterations)).withAttempts(Collections.singletonList(TaskRunAttempt.builder().state(new State().withState(state)).build())).withState(state);
                }
                return taskRun.withOutputs(Map.of("iterations", iterations));
            }
        }
        return taskRun;
    }

    private static State.Type findTerminalState(Map<String, Integer> iterations) {
        if (iterations.getOrDefault(State.Type.FAILED.toString(), 0) > 0) {
            return State.Type.FAILED;
        }
        if (iterations.getOrDefault(State.Type.KILLED.toString(), 0) > 0) {
            return State.Type.KILLED;
        }
        if (iterations.getOrDefault(State.Type.WARNING.toString(), 0) > 0) {
            return State.Type.WARNING;
        }
        return State.Type.SUCCESS;
    }

    private static int getIterationCounter(Map<String, Integer> iterations, State.Type state, int maxIterations) {
        return iterations.getOrDefault(state.toString(), state == State.Type.CREATED ? maxIterations : 0);
    }
}

