/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.serializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import io.kestra.core.models.Label;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class ListOrMapOfLabelDeserializer
extends JsonDeserializer<List<Label>>
implements ResolvableDeserializer {
    public List<Label> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.hasToken(JsonToken.VALUE_NULL)) {
            return null;
        }
        if (p.hasToken(JsonToken.START_ARRAY)) {
            List ret = (List)ctxt.readValue(p, List.class);
            return ret.stream().map(map -> new Label((String)map.get("key"), (String)map.get("value"))).toList();
        }
        if (p.hasToken(JsonToken.START_OBJECT)) {
            Map ret = (Map)ctxt.readValue(p, Map.class);
            return ret == null ? null : ret.entrySet().stream().map(entry -> new Label((String)entry.getKey(), (String)entry.getValue())).toList();
        }
        throw new IllegalArgumentException("Unable to deserialize value as it's neither an object neither an array");
    }

    public void resolve(DeserializationContext ctxt) throws JsonMappingException {
    }
}

