/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.serializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.InvalidTypeIdException;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.kestra.core.models.validations.ManualConstraintViolation;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.serializers.helpers.HandleBarDeserializer;
import jakarta.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

@Singleton
public class YamlFlowParser {
    public static final String CONTEXT_FLOW_DIRECTORY = "flowDirectory";
    private static final ObjectMapper mapper = JacksonMapper.ofYaml().enable(new JsonParser.Feature[]{JsonParser.Feature.STRICT_DUPLICATE_DETECTION}).disable(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE).registerModule((Module)new SimpleModule("HandleBarDeserializer").addDeserializer(String.class, (JsonDeserializer)new HandleBarDeserializer()));

    public static boolean isValidExtension(Path path) {
        return FilenameUtils.getExtension((String)path.toFile().getAbsolutePath()).equals("yaml") || FilenameUtils.getExtension((String)path.toFile().getAbsolutePath()).equals("yml");
    }

    public <T> T parse(String input, Class<T> cls) {
        return this.readFlow(mapper, input, cls, YamlFlowParser.type(cls));
    }

    public <T> T parse(Map<String, Object> input, Class<T> cls) {
        try {
            return (T)mapper.convertValue(input, cls);
        }
        catch (IllegalArgumentException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof JsonProcessingException) {
                JsonProcessingException jsonProcessingException = (JsonProcessingException)throwable;
                YamlFlowParser.jsonProcessingExceptionHandler(input, YamlFlowParser.type(cls), jsonProcessingException);
            }
            throw e;
        }
    }

    private static <T> String type(Class<T> cls) {
        return cls.getSimpleName().toLowerCase();
    }

    public <T> T parse(File file, Class<T> cls) throws ConstraintViolationException {
        try {
            String input = IOUtils.toString((URI)file.toURI(), (Charset)StandardCharsets.UTF_8);
            return this.readFlow(mapper.copy().setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(CONTEXT_FLOW_DIRECTORY, (Object)file.getAbsoluteFile().getParentFile().getAbsolutePath())), input, cls, YamlFlowParser.type(cls));
        }
        catch (IOException e) {
            throw new ConstraintViolationException("Illegal " + YamlFlowParser.type(cls) + " path:" + e.getMessage(), Collections.singleton(ManualConstraintViolation.of(e.getMessage(), file, File.class, YamlFlowParser.type(cls), file.getAbsolutePath())));
        }
    }

    private <T> T readFlow(ObjectMapper mapper, String input, Class<T> objectClass, String resource) {
        try {
            return (T)mapper.readValue(input, objectClass);
        }
        catch (JsonProcessingException e) {
            YamlFlowParser.jsonProcessingExceptionHandler(input, resource, e);
            return null;
        }
    }

    private static <T> void jsonProcessingExceptionHandler(T target, String resource, JsonProcessingException e) throws ConstraintViolationException {
        Throwable throwable = e.getCause();
        if (throwable instanceof ConstraintViolationException) {
            ConstraintViolationException constraintViolationException = (ConstraintViolationException)throwable;
            throw constraintViolationException;
        }
        if (e instanceof InvalidTypeIdException) {
            InvalidTypeIdException invalidTypeIdException = (InvalidTypeIdException)e;
            throw new ConstraintViolationException("Invalid type: " + invalidTypeIdException.getTypeId(), Set.of(ManualConstraintViolation.of("Invalid type: " + invalidTypeIdException.getTypeId(), target, target.getClass(), invalidTypeIdException.getPathReference(), null), ManualConstraintViolation.of(e.getMessage(), target, target.getClass(), invalidTypeIdException.getPathReference(), null)));
        }
        if (e instanceof UnrecognizedPropertyException) {
            UnrecognizedPropertyException unrecognizedPropertyException = (UnrecognizedPropertyException)e;
            String message = unrecognizedPropertyException.getOriginalMessage() + unrecognizedPropertyException.getMessageSuffix();
            throw new ConstraintViolationException(message, Collections.singleton(ManualConstraintViolation.of(e.getCause() == null ? message : message + "\nCaused by: " + e.getCause().getMessage(), target, target.getClass(), unrecognizedPropertyException.getPathReference(), null)));
        }
        throw new ConstraintViolationException("Illegal " + resource + " yaml: " + e.getMessage(), Collections.singleton(ManualConstraintViolation.of((String)(e.getCause() == null ? e.getMessage() : e.getMessage() + "\nCaused by: " + e.getCause().getMessage()), target, target.getClass(), "flow", null)));
    }
}

