/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.services;

import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.conditions.types.MultipleCondition;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.FlowWithException;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.multipleflows.MultipleConditionStorageInterface;
import io.kestra.core.models.triggers.multipleflows.MultipleConditionWindow;
import io.kestra.core.models.triggers.types.Flow;
import io.kestra.core.runners.RunContextFactory;
import io.kestra.core.services.ConditionService;
import io.kestra.core.services.FlowService;
import jakarta.inject.Inject;
import java.beans.ConstructorProperties;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public abstract class AbstractFlowTriggerService {
    @Inject
    private ConditionService conditionService;
    @Inject
    private RunContextFactory runContextFactory;
    @Inject
    private FlowService flowService;

    public Stream<FlowWithFlowTrigger> withFlowTriggersOnly(Stream<io.kestra.core.models.flows.Flow> allFlows) {
        return allFlows.filter(flow -> !flow.isDisabled()).filter(flow -> flow.getTriggers() != null && !flow.getTriggers().isEmpty()).flatMap(flow -> this.flowTriggers((io.kestra.core.models.flows.Flow)flow).map(trigger -> new FlowWithFlowTrigger((io.kestra.core.models.flows.Flow)flow, (Flow)trigger)));
    }

    public Stream<Flow> flowTriggers(io.kestra.core.models.flows.Flow flow) {
        return flow.getTriggers().stream().filter(Predicate.not(AbstractTrigger::isDisabled)).filter(Flow.class::isInstance).map(Flow.class::cast);
    }

    public List<Execution> computeExecutionsFromFlowTriggers(Execution execution, List<io.kestra.core.models.flows.Flow> allFlows, Optional<MultipleConditionStorageInterface> multipleConditionStorage) {
        List<FlowWithFlowTrigger> validTriggersBeforeMultipleConditionEval = allFlows.stream().filter(flow -> this.flowService.removeUnwanted((io.kestra.core.models.flows.Flow)flow, execution)).filter(flow -> !flow.isDisabled() && !(flow instanceof FlowWithException)).filter(flow -> flow.getTriggers() != null && !flow.getTriggers().isEmpty()).flatMap(flow -> this.flowTriggers((io.kestra.core.models.flows.Flow)flow).map(trigger -> new FlowWithFlowTrigger((io.kestra.core.models.flows.Flow)flow, (Flow)trigger))).filter(flowWithFlowTrigger -> this.conditionService.valid(flowWithFlowTrigger.getFlow(), Optional.ofNullable(flowWithFlowTrigger.getTrigger().getConditions()).stream().flatMap(Collection::stream).filter(Predicate.not(MultipleCondition.class::isInstance)).toList(), this.conditionService.conditionContext(this.runContextFactory.of(flowWithFlowTrigger.getFlow(), execution), flowWithFlowTrigger.getFlow(), execution))).toList();
        Map<FlowWithFlowTriggerAndMultipleCondition, MultipleConditionWindow> multipleConditionWindowsByFlow = null;
        if (multipleConditionStorage.isPresent()) {
            List flowWithMultipleConditionsToEvaluate = validTriggersBeforeMultipleConditionEval.stream().flatMap(flowWithFlowTrigger -> Optional.ofNullable(flowWithFlowTrigger.getTrigger().getConditions()).stream().flatMap(Collection::stream).filter(MultipleCondition.class::isInstance).map(MultipleCondition.class::cast).map(multipleCondition -> new FlowWithFlowTriggerAndMultipleCondition(flowWithFlowTrigger.getFlow(), ((MultipleConditionStorageInterface)multipleConditionStorage.get()).getOrCreate(flowWithFlowTrigger.getFlow(), (MultipleCondition)multipleCondition), flowWithFlowTrigger.getTrigger(), (MultipleCondition)multipleCondition))).toList();
            multipleConditionWindowsByFlow = flowWithMultipleConditionsToEvaluate.stream().map(f -> {
                Map<String, Boolean> results = f.getMultipleCondition().getConditions().entrySet().stream().map(e -> new AbstractMap.SimpleEntry<String, Boolean>((String)e.getKey(), this.conditionService.isValid((Condition)e.getValue(), f.getFlow(), execution))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                return Map.entry(f, f.getMultipleConditionWindow().with(results));
            }).filter(e -> !((MultipleConditionWindow)e.getValue()).getResults().isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            multipleConditionStorage.get().save(new ArrayList<MultipleConditionWindow>(multipleConditionWindowsByFlow.values()));
        }
        List<Execution> executions = validTriggersBeforeMultipleConditionEval.stream().filter(flowWithFlowTrigger -> this.conditionService.isValid(flowWithFlowTrigger.getTrigger(), flowWithFlowTrigger.getFlow(), execution, (MultipleConditionStorageInterface)multipleConditionStorage.orElse(null))).map(f -> f.getTrigger().evaluate(this.runContextFactory.of(f.getFlow(), execution), f.getFlow(), execution)).filter(Optional::isPresent).map(Optional::get).toList();
        if (multipleConditionStorage.isPresent() && multipleConditionWindowsByFlow != null) {
            Stream.concat(multipleConditionWindowsByFlow.keySet().stream().map(f -> Map.entry(f.getMultipleCondition().getConditions(), ((MultipleConditionStorageInterface)multipleConditionStorage.get()).getOrCreate(f.getFlow(), f.getMultipleCondition()))).filter(e -> ((Map)e.getKey()).size() == Optional.ofNullable(((MultipleConditionWindow)e.getValue()).getResults()).map(Map::size).orElse(0).intValue()).map(Map.Entry::getValue), multipleConditionStorage.get().expired(execution.getTenantId()).stream()).forEach(multipleConditionStorage.get()::delete);
        }
        return executions;
    }

    protected static class FlowWithFlowTriggerAndMultipleCondition {
        private final io.kestra.core.models.flows.Flow flow;
        private final MultipleConditionWindow multipleConditionWindow;
        private final Flow trigger;
        private final MultipleCondition multipleCondition;

        @ConstructorProperties(value={"flow", "multipleConditionWindow", "trigger", "multipleCondition"})
        @Generated
        public FlowWithFlowTriggerAndMultipleCondition(io.kestra.core.models.flows.Flow flow, MultipleConditionWindow multipleConditionWindow, Flow trigger, MultipleCondition multipleCondition) {
            this.flow = flow;
            this.multipleConditionWindow = multipleConditionWindow;
            this.trigger = trigger;
            this.multipleCondition = multipleCondition;
        }

        @Generated
        public io.kestra.core.models.flows.Flow getFlow() {
            return this.flow;
        }

        @Generated
        public MultipleConditionWindow getMultipleConditionWindow() {
            return this.multipleConditionWindow;
        }

        @Generated
        public Flow getTrigger() {
            return this.trigger;
        }

        @Generated
        public MultipleCondition getMultipleCondition() {
            return this.multipleCondition;
        }

        @Generated
        public String toString() {
            return "AbstractFlowTriggerService.FlowWithFlowTriggerAndMultipleCondition(flow=" + this.getFlow() + ", multipleConditionWindow=" + this.getMultipleConditionWindow() + ", trigger=" + this.getTrigger() + ", multipleCondition=" + this.getMultipleCondition() + ")";
        }
    }

    public static class FlowWithFlowTrigger {
        private final io.kestra.core.models.flows.Flow flow;
        private final Flow trigger;

        @ConstructorProperties(value={"flow", "trigger"})
        @Generated
        public FlowWithFlowTrigger(io.kestra.core.models.flows.Flow flow, Flow trigger) {
            this.flow = flow;
            this.trigger = trigger;
        }

        @Generated
        public io.kestra.core.models.flows.Flow getFlow() {
            return this.flow;
        }

        @Generated
        public Flow getTrigger() {
            return this.trigger;
        }

        @Generated
        public String toString() {
            return "AbstractFlowTriggerService.FlowWithFlowTrigger(flow=" + this.getFlow() + ", trigger=" + this.getTrigger() + ")";
        }
    }
}

