/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.services;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.runners.RunContextFactory;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.services.ConditionService;
import io.kestra.core.utils.ListUtils;
import io.micronaut.context.ApplicationContext;
import io.micronaut.core.annotation.Nullable;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class FlowService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FlowService.class);
    @Inject
    RunContextFactory runContextFactory;
    @Inject
    ConditionService conditionService;
    @Inject
    ApplicationContext applicationContext;

    public Stream<Flow> keepLastVersion(Stream<Flow> stream) {
        return this.keepLastVersionCollector(stream);
    }

    public List<String> deprecationPaths(Flow flow) {
        return this.deprecationTraversal("", flow).toList();
    }

    private Stream<String> deprecationTraversal(String prefix, Object object) {
        if (object == null || ClassUtils.isPrimitiveOrWrapper(object.getClass()) || String.class.equals(object.getClass())) {
            return Stream.empty();
        }
        return Stream.concat(object.getClass().isAnnotationPresent(Deprecated.class) ? Stream.of(prefix) : Stream.empty(), this.allGetters(object.getClass()).flatMap(method -> {
            try {
                Object[] fieldValue = method.invoke(object, new Object[0]);
                if (fieldValue instanceof Iterable) {
                    Iterable iterableValue = (Iterable)fieldValue;
                    fieldValue = StreamSupport.stream(iterableValue.spliterator(), false).toArray(Object[]::new);
                }
                String fieldName = method.getName().substring(3, 4).toLowerCase() + method.getName().substring(4);
                Stream<Object> additionalDeprecationPaths = Stream.empty();
                if (fieldValue instanceof Object[]) {
                    Object[] arrayValue = fieldValue;
                    additionalDeprecationPaths = IntStream.range(0, arrayValue.length).boxed().flatMap(i -> this.deprecationTraversal(fieldName + "[%d]".formatted(i), arrayValue[i]));
                }
                return Stream.concat(method.isAnnotationPresent(Deprecated.class) && fieldValue != null ? Stream.of(prefix.isEmpty() ? fieldName : prefix + "." + fieldName) : Stream.empty(), additionalDeprecationPaths);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                return Stream.empty();
            }
        }));
    }

    private Stream<Method> allGetters(Class<?> clazz) {
        return Arrays.stream(clazz.getMethods()).filter(m -> !m.getDeclaringClass().equals(Object.class)).filter(method -> method.getName().startsWith("get") && method.getName().length() > 3 && method.getParameterCount() == 0).filter(method -> !method.getReturnType().equals(Void.TYPE)).filter(method -> !Modifier.isStatic(method.getModifiers()));
    }

    public Flow keepLastVersion(Stream<Flow> stream, String namespace, String flowId) {
        return this.keepLastVersionCollector(stream.filter(flow -> flow.getNamespace().equals(namespace) && flow.getId().equals(flowId))).findFirst().orElseThrow(() -> new IllegalStateException("Unable to find flow '" + namespace + "." + flowId + "'"));
    }

    public Collection<Flow> keepLastVersion(List<Flow> flows) {
        return this.keepLastVersionCollector(flows.stream()).collect(Collectors.toList());
    }

    private Stream<Flow> keepLastVersionCollector(Stream<Flow> stream) {
        return stream.sorted((left, right) -> left.getRevision() > right.getRevision() ? -1 : (left.getRevision().equals(right.getRevision()) ? 0 : 1)).collect(Collectors.groupingBy(Flow::uidWithoutRevision)).values().stream().map(flows -> {
            Flow flow;
            Flow finalFlow = flow = (Flow)flows.stream().findFirst().orElseThrow();
            Optional<Flow> deleted = flows.stream().filter(f -> f.getRevision().equals(finalFlow.getRevision()) && f.isDeleted()).findFirst();
            if (deleted.isPresent()) {
                return null;
            }
            return flow.isDeleted() ? null : flow;
        }).filter(Objects::nonNull);
    }

    protected boolean removeUnwanted(Flow f, Execution execution) {
        return !f.uidWithoutRevision().equals(Flow.uidWithoutRevision(execution));
    }

    public static List<AbstractTrigger> findRemovedTrigger(Flow flow, Flow previous) {
        return ListUtils.emptyOnNull(previous.getTriggers()).stream().filter(p -> ListUtils.emptyOnNull(flow.getTriggers()).stream().noneMatch(c -> c.getId().equals(p.getId()))).collect(Collectors.toList());
    }

    public static String cleanupSource(String source) {
        return source.replaceFirst("(?m)^revision: \\d+\n?", "");
    }

    public static String injectDisabled(String source, Boolean disabled) {
        String regex = disabled != false ? "^disabled\\s*:\\s*false\\s*" : "^disabled\\s*:\\s*true\\s*";
        Pattern p = Pattern.compile(regex, 8);
        if (p.matcher(source).find()) {
            return p.matcher(source).replaceAll(String.format("disabled: %s\n", disabled));
        }
        return source + String.format("\ndisabled: %s", disabled);
    }

    public static String generateSource(Flow flow, @Nullable String source) {
        try {
            if (source == null) {
                return FlowService.toYamlWithoutDefault(flow);
            }
            if (JacksonMapper.ofYaml().writeValueAsString((Object)flow).equals(source)) {
                source = FlowService.toYamlWithoutDefault(flow);
            }
        }
        catch (JsonProcessingException e) {
            log.warn("Unable to convert flow json '{}' '{}'({})", new Object[]{flow.getNamespace(), flow.getId(), flow.getRevision(), e});
        }
        return source;
    }

    private static String toYamlWithoutDefault(Object object) throws JsonProcessingException {
        String json = JacksonMapper.ofJson().copy().setSerializationInclusion(JsonInclude.Include.NON_DEFAULT).writeValueAsString(object);
        Object map = FlowService.fixSnakeYaml(JacksonMapper.toMap(json));
        return JacksonMapper.ofYaml().writeValueAsString(map);
    }

    private static Object fixSnakeYaml(Object object) {
        String item;
        if (object instanceof Map) {
            return ((Map)object).entrySet().stream().map(entry -> new AbstractMap.SimpleEntry<Object, Object>(FlowService.fixSnakeYaml(entry.getKey()), FlowService.fixSnakeYaml(entry.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (u, v) -> {
                throw new IllegalStateException(String.format("Duplicate key %s", u));
            }, LinkedHashMap::new));
        }
        if (object instanceof Collection) {
            return ((Collection)object).stream().map(FlowService::fixSnakeYaml).collect(Collectors.toList());
        }
        if (object instanceof String && (item = (String)object).contains("\n")) {
            return item.replaceAll("\\s+\\n", "\\\n");
        }
        return object;
    }
}

