/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.services;

import io.kestra.core.models.hierarchies.AbstractGraph;
import io.kestra.core.models.hierarchies.Graph;
import io.kestra.core.models.hierarchies.GraphCluster;
import io.kestra.core.models.hierarchies.GraphClusterEnd;
import io.kestra.core.models.hierarchies.Relation;
import java.net.URISyntaxException;

public class Graph2DotService {
    public static String dot(Graph<AbstractGraph, Relation> graph) throws URISyntaxException {
        StringBuilder sb = new StringBuilder();
        sb.append("digraph G {\n");
        sb.append("  layout=dot;\n\n");
        sb.append(Graph2DotService.nodeAndEdges(graph, 0, null));
        sb.append("}");
        return sb.toString();
    }

    private static String subgraph(GraphCluster subGraph, int level) {
        StringBuilder sb = new StringBuilder();
        sb.append(Graph2DotService.indent(level)).append("subgraph \"cluster_").append(subGraph.getUid()).append("\"{\n");
        sb.append(Graph2DotService.indent(level)).append("  label = ").append(Graph2DotService.name(subGraph)).append(";\n");
        sb.append(Graph2DotService.nodeAndEdges(subGraph.getGraph(), level, subGraph.getUid()));
        sb.append(Graph2DotService.indent(level)).append("}");
        sb.append("\n\n");
        return sb.toString();
    }

    private static String nodeAndEdges(Graph<AbstractGraph, Relation> graph, int level, String uid) {
        StringBuilder sb = new StringBuilder();
        for (AbstractGraph abstractGraph : graph.nodes()) {
            if (abstractGraph instanceof GraphCluster) {
                GraphCluster subGraph = (GraphCluster)abstractGraph;
                if (uid != null && uid.equals(subGraph.getUid())) continue;
                sb.append(Graph2DotService.subgraph(subGraph, level + 1));
                continue;
            }
            sb.append(Graph2DotService.indent(level)).append("  ").append(Graph2DotService.node(abstractGraph)).append(";\n");
        }
        for (Graph.Edge edge : graph.edges()) {
            sb.append(Graph2DotService.indent(level)).append("  ").append(Graph2DotService.nodeName((AbstractGraph)edge.getSource())).append(" -> ").append(Graph2DotService.nodeName((AbstractGraph)edge.getTarget())).append(" ").append(";\n");
        }
        return sb.toString();
    }

    private static String indent(int level) {
        return " ".repeat(level * 2);
    }

    private static String node(AbstractGraph node) {
        return Graph2DotService.name(node) + Graph2DotService.label(node);
    }

    private static String label(AbstractGraph node) {
        String shape = node instanceof GraphClusterEnd ? "point" : "box";
        String label = node instanceof GraphClusterEnd ? "end" : node.getLabel();
        return "[shape=" + shape + ",label=\"" + label + "\"]";
    }

    private static String nodeName(AbstractGraph node) {
        return "\"" + node.getUid() + "\"";
    }

    private static String name(AbstractGraph node) {
        return "\"" + node.getUid() + "\"";
    }
}

