/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.storages;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import io.kestra.core.annotations.Retryable;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.Input;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.TriggerContext;
import io.kestra.core.storages.FileAttributes;
import io.kestra.core.utils.Slugify;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.Nullable;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@Introspected
public interface StorageInterface {
    @Retryable(includes={IOException.class}, excludes={FileNotFoundException.class})
    public InputStream get(String var1, URI var2) throws IOException;

    @Retryable(includes={IOException.class}, excludes={FileNotFoundException.class})
    public List<FileAttributes> list(String var1, URI var2) throws IOException;

    default public boolean exists(String tenantId, URI uri) {
        boolean bl;
        block8: {
            InputStream ignored = this.get(tenantId, uri);
            try {
                bl = true;
                if (ignored == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ieo) {
                    return false;
                }
            }
            ignored.close();
        }
        return bl;
    }

    @Deprecated
    @Retryable(includes={IOException.class}, excludes={FileNotFoundException.class})
    public Long size(String var1, URI var2) throws IOException;

    @Deprecated
    @Retryable(includes={IOException.class}, excludes={FileNotFoundException.class})
    public Long lastModifiedTime(String var1, URI var2) throws IOException;

    @Retryable(includes={IOException.class}, excludes={FileNotFoundException.class})
    public FileAttributes getAttributes(String var1, URI var2) throws IOException;

    @Retryable(includes={IOException.class})
    public URI put(String var1, URI var2, InputStream var3) throws IOException;

    @Retryable(includes={IOException.class})
    public boolean delete(String var1, URI var2) throws IOException;

    @Retryable(includes={IOException.class})
    public URI createDirectory(String var1, URI var2) throws IOException;

    @Retryable(includes={IOException.class}, excludes={FileNotFoundException.class})
    public URI move(String var1, URI var2, URI var3) throws IOException;

    @Retryable(includes={IOException.class})
    public List<URI> deleteByPrefix(String var1, URI var2) throws IOException;

    default public String executionPrefix(Flow flow, Execution execution) {
        return this.fromParts(flow.getNamespace().replace(".", "/"), Slugify.of(flow.getId()), "executions", execution.getId());
    }

    default public String executionPrefix(Execution execution) {
        return this.fromParts(execution.getNamespace().replace(".", "/"), Slugify.of(execution.getFlowId()), "executions", execution.getId());
    }

    default public String executionPrefix(TaskRun taskRun) {
        return this.fromParts(taskRun.getNamespace().replace(".", "/"), Slugify.of(taskRun.getFlowId()), "executions", taskRun.getExecutionId());
    }

    default public String statePrefix(String namespace, @Nullable String flowId, @Nullable String name, @Nullable String value) {
        String namespacePrefix = namespace.replace(".", "/");
        ArrayList<String> paths = new ArrayList<String>(List.of(namespacePrefix));
        if (flowId != null) {
            paths.add(Slugify.of(flowId));
        }
        paths.add("states");
        if (name != null) {
            paths.add(name);
        }
        if (value != null) {
            paths.add(Hashing.goodFastHash((int)64).hashString((CharSequence)value, Charsets.UTF_8).toString());
        }
        return String.join((CharSequence)"/", paths);
    }

    default public String cachePrefix(String namespace, String flowId, String taskId, @Nullable String value) {
        String namespacePrefix = namespace.replace(".", "/");
        ArrayList<String> paths = new ArrayList<String>(List.of(namespacePrefix, Slugify.of(flowId), Slugify.of(taskId), "cache"));
        if (value != null) {
            paths.add(Hashing.goodFastHash((int)64).hashString((CharSequence)value, Charsets.UTF_8).toString());
        }
        return String.join((CharSequence)"/", paths);
    }

    default public String namespaceFilePrefix(String namespace) {
        return this.fromParts(namespace.replace(".", "/"), "_files");
    }

    default public Optional<String> extractExecutionId(URI path) {
        Pattern pattern = Pattern.compile("^/(.+)/executions/([^/]+)/", 2);
        Matcher matcher = pattern.matcher(path.getPath());
        if (!matcher.find() || matcher.group(2).isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(matcher.group(2));
    }

    default public URI uri(Flow flow, Execution execution, String inputName, String file) throws URISyntaxException {
        return new URI("/" + this.fromParts(this.executionPrefix(flow, execution), "inputs", inputName, file));
    }

    @Retryable(includes={IOException.class})
    default public URI from(Flow flow, Execution execution, String input, File file) throws IOException {
        try {
            return this.put(flow.getTenantId(), this.uri(flow, execution, input, file.getName()), new BufferedInputStream(new FileInputStream(file)));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Retryable(includes={IOException.class})
    default public URI from(Flow flow, Execution execution, Input<?> input, File file) throws IOException {
        return this.from(flow, execution, input.getName(), file);
    }

    default public URI outputPrefix(Flow flow) {
        try {
            return new URI("//" + this.fromParts(flow.getNamespace().replace(".", "/"), Slugify.of(flow.getId())));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    default public URI outputPrefix(Flow flow, Task task, Execution execution, TaskRun taskRun) {
        try {
            return new URI("//" + this.fromParts(flow.getNamespace().replace(".", "/"), Slugify.of(flow.getId()), "executions", execution.getId(), "tasks", Slugify.of(taskRun.getTaskId()), taskRun.getId()));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    default public URI outputPrefix(TriggerContext triggerContext, AbstractTrigger trigger, String triggerExecutionId) {
        try {
            return new URI("//" + this.fromParts(triggerContext.getNamespace().replace(".", "/"), Slugify.of(triggerContext.getFlowId()), "executions", triggerExecutionId, "trigger", Slugify.of(trigger.getId())));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private String fromParts(String ... parts) {
        return "/" + Arrays.stream(parts).filter(part -> part != null).collect(Collectors.joining("/"));
    }
}

