/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.tasks.flows;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.NextTaskRun;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.hierarchies.GraphCluster;
import io.kestra.core.models.hierarchies.RelationType;
import io.kestra.core.models.tasks.FlowableTask;
import io.kestra.core.models.tasks.ResolvedTask;
import io.kestra.core.models.tasks.VoidOutput;
import io.kestra.core.runners.FlowableUtils;
import io.kestra.core.runners.RunContext;
import io.kestra.core.tasks.flows.Parallel;
import io.kestra.core.utils.GraphUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Optional;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.Generated;

@Schema(title="For each value in the list, execute one or more tasks in parallel.", description="The list of `tasks` will be executed for each item in parallel. The value must be a valid JSON string representing an array, e.g. a list of strings `[\"value1\", \"value2\"]` or a list of dictionaries `[{\"key\": \"value1\"}, {\"key\": \"value2\"}]`.\nYou can access the current iteration value using the variable `{{ taskrun.value }}`.\n\nThe task list will be executed in parallel for each item. For example, if you have a list with 3 elements and 2 tasks defined in the list of `tasks`, all 6 tasks will be computed in parallel without any order guarantee.\n\nIf you want to execute a group of sequential tasks for each value in parallel, you can wrap the list of `tasks` with the [Sequential task](https://kestra.io/plugins/core/tasks/flows/io.kestra.core.tasks.flows.sequential).\nIf your list of values is large, you can limit the number of concurrent tasks using the `concurrent` property.\n\nWe highly recommend triggering a subflow for each value instead of specifying many tasks wrapped in a `Sequential` task. This allows much better scalability and modularity. Check the [flow best practices documentation](https://kestra.io/docs/developer-guide/best-practice) and the [following Blueprint](https://demo.kestra.io/ui/blueprints/community/128) for more details.")
@Plugin(examples={@Example(code={"value: '[\"value 1\", \"value 2\", \"value 3\"]'", "tasks:", "  - id: each-value", "    type: io.kestra.core.tasks.debugs.Return", "    format: \"{{ task.id }} with current value '{{ taskrun.value }}'\""}), @Example(code={"value: ", "- value 1", "- value 2", "- value 3", "tasks:", "  - id: each-value", "    type: io.kestra.core.tasks.debugs.Return", "    format: \"{{ task.id }} with current value '{{ taskrun.value }}'\""}), @Example(title="Handling each value in parallel but only 1 child task for each value at the same time.", code={"value: '[\"value 1\", \"value 2\", \"value 3\"]'", "tasks:", "  - id: seq", "    type: io.kestra.core.tasks.flows.Sequential", "    tasks:", "    - id: t1", "      type: io.kestra.plugin.scripts.shell.Commands", "      commands:", "        - 'echo \"{{task.id}} > {{ parents[0].taskrun.value }}", "        - 'sleep 1'", "    - id: t2", "      type: io.kestra.plugin.scripts.shell.Commands", "      commands:", "        - 'echo \"{{task.id}} > {{ parents[0].taskrun.value }}", "        - 'sleep 1'"})})
public class EachParallel
extends Parallel
implements FlowableTask<VoidOutput> {
    @NotNull
    @NotBlank
    @Schema(title="Number of concurrent parallel tasks", description="If the value is `0`, no limit exist and all the tasks will start at the same time")
    @PluginProperty
    private final Integer concurrent;
    @NotNull
    @NotBlank
    @PluginProperty(dynamic=true)
    @Schema(title="The list of values for this task", description="The value car be passed as a String, a list of String, or a list of objects", anyOf={String.class, Object[].class})
    private Object value;

    @Override
    public GraphCluster tasksTree(Execution execution, TaskRun taskRun, List<String> parentValues) throws IllegalVariableEvaluationException {
        GraphCluster subGraph = new GraphCluster(this, taskRun, parentValues, RelationType.DYNAMIC);
        GraphUtils.parallel(subGraph, this.getTasks(), this.errors, taskRun, execution);
        return subGraph;
    }

    @Override
    public List<ResolvedTask> childTasks(RunContext runContext, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        return FlowableUtils.resolveEachTasks(runContext, parentTaskRun, this.getTasks(), this.value);
    }

    @Override
    public Optional<State.Type> resolveState(RunContext runContext, Execution execution, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        List<ResolvedTask> childTasks = this.childTasks(runContext, parentTaskRun);
        if (childTasks.size() == 0) {
            return Optional.of(State.Type.SUCCESS);
        }
        return FlowableUtils.resolveState(execution, childTasks, FlowableUtils.resolveTasks(this.getErrors(), parentTaskRun), parentTaskRun, runContext);
    }

    @Override
    public List<NextTaskRun> resolveNexts(RunContext runContext, Execution execution, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        return FlowableUtils.resolveParallelNexts(execution, FlowableUtils.resolveEachTasks(runContext, parentTaskRun, this.getTasks(), this.value), FlowableUtils.resolveTasks(this.errors, parentTaskRun), parentTaskRun, this.concurrent);
    }

    @Generated
    private static Integer $default$concurrent() {
        return 0;
    }

    @Generated
    protected EachParallel(EachParallelBuilder<?, ?> b) {
        super((Parallel.ParallelBuilder<?, ?>)b);
        this.concurrent = b.concurrent$set ? b.concurrent$value : EachParallel.$default$concurrent();
        this.value = b.value;
    }

    @Generated
    public static EachParallelBuilder<?, ?> builder() {
        return new EachParallelBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "EachParallel(super=" + super.toString() + ", concurrent=" + this.getConcurrent() + ", value=" + this.getValue() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EachParallel)) {
            return false;
        }
        EachParallel other = (EachParallel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$concurrent = this.getConcurrent();
        Integer other$concurrent = other.getConcurrent();
        if (this$concurrent == null ? other$concurrent != null : !((Object)this$concurrent).equals(other$concurrent)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EachParallel;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $concurrent = this.getConcurrent();
        result = result * 59 + ($concurrent == null ? 43 : ((Object)$concurrent).hashCode());
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    @Override
    @Generated
    public Integer getConcurrent() {
        return this.concurrent;
    }

    @Generated
    public Object getValue() {
        return this.value;
    }

    @Generated
    public EachParallel() {
        this.concurrent = EachParallel.$default$concurrent();
    }

    @Generated
    public static abstract class EachParallelBuilder<C extends EachParallel, B extends EachParallelBuilder<C, B>>
    extends Parallel.ParallelBuilder<C, B> {
        @Generated
        private boolean concurrent$set;
        @Generated
        private Integer concurrent$value;
        @Generated
        private Object value;

        @Override
        @Generated
        public B concurrent(Integer concurrent) {
            this.concurrent$value = concurrent;
            this.concurrent$set = true;
            return (B)this.self();
        }

        @Generated
        public B value(Object value) {
            this.value = value;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "EachParallel.EachParallelBuilder(super=" + super.toString() + ", concurrent$value=" + this.concurrent$value + ", value=" + this.value + ")";
        }
    }

    @Generated
    private static final class EachParallelBuilderImpl
    extends EachParallelBuilder<EachParallel, EachParallelBuilderImpl> {
        @Generated
        private EachParallelBuilderImpl() {
        }

        @Override
        @Generated
        protected EachParallelBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public EachParallel build() {
            return new EachParallel(this);
        }
    }
}

