/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.tasks.flows;

import io.kestra.core.exceptions.InternalException;
import io.kestra.core.models.Label;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.executions.TaskRunAttempt;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.tasks.ExecutableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.ExecutableUtils;
import io.kestra.core.runners.FlowExecutorInterface;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.WorkerTaskExecution;
import io.kestra.core.runners.WorkerTaskResult;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import lombok.Generated;

@Schema(title="Create a subflow execution. Subflows offer a modular way to reuse workflow logic by calling other flows just like calling a function in a programming language.")
@Plugin(examples={@Example(title="Run a subflow with custom inputs", code={"namespace: dev", "flowId: subflow", "inputs:", "  user: \"Rick Astley\"", "  favorite_song: \"Never Gonna Give You Up\"", "wait: true", "transmitFailed: true"})})
public class Flow
extends Task
implements ExecutableTask<Output> {
    @NotNull
    @Schema(title="The namespace of the subflow to be executed")
    @PluginProperty(dynamic=true)
    private String namespace;
    @NotNull
    @Schema(title="The identifier of the subflow to be executed")
    @PluginProperty(dynamic=true)
    private String flowId;
    @Schema(title="The revision of the subflow to be executed", description="By default, the last, i.e. the most recent, revision of the subflow is executed.")
    @PluginProperty(dynamic=true)
    private Integer revision;
    @Schema(title="The inputs to pass to the subflow to be executed")
    @PluginProperty(dynamic=true)
    private Map<String, Object> inputs;
    @Schema(title="The labels to pass to the subflow to be executed")
    @PluginProperty(dynamic=true)
    private Map<String, String> labels;
    @Schema(title="Whether to wait for the subflow execution to finish before continuing the current execution.")
    @PluginProperty
    private final Boolean wait;
    @Schema(title="Whether to fail the current execution if the subflow execution fails or is killed", description="Note that this option works only if `wait` is set to `true`.")
    @PluginProperty
    private final Boolean transmitFailed;
    @Schema(title="Whether the subflow should inherit labels from this execution that triggered it.", description="By default, labels are not passed to the subflow execution. If you set this option to `true`, the child flow execution will inherit all labels from the parent execution.")
    @PluginProperty
    private final Boolean inheritLabels;
    @Schema(title="Outputs from the subflow executions.", description="Allows to specify outputs as key-value pairs to extract any outputs from the subflow execution into output of this task execution.")
    @PluginProperty(dynamic=true)
    private Map<String, Object> outputs;

    @Override
    public List<WorkerTaskExecution<?>> createWorkerTaskExecutions(RunContext runContext, FlowExecutorInterface flowExecutorInterface, io.kestra.core.models.flows.Flow currentFlow, Execution currentExecution, TaskRun currentTaskRun) throws InternalException {
        HashMap<String, Object> inputs = new HashMap<String, Object>();
        if (this.inputs != null) {
            inputs.putAll(runContext.render(this.inputs));
        }
        ArrayList<Label> labels = new ArrayList<Label>();
        if (this.inheritLabels.booleanValue()) {
            labels.addAll(currentExecution.getLabels());
        }
        if (this.labels != null) {
            for (Map.Entry<String, String> entry : this.labels.entrySet()) {
                labels.add(new Label(entry.getKey(), runContext.render(entry.getValue())));
            }
        }
        return List.of(ExecutableUtils.workerTaskExecution(runContext, flowExecutorInterface, currentExecution, currentFlow, this, currentTaskRun, inputs, labels, null));
    }

    @Override
    public Optional<WorkerTaskResult> createWorkerTaskResult(RunContext runContext, TaskRun taskRun, io.kestra.core.models.flows.Flow flow, Execution execution) {
        if (!taskRun.getState().isTerminated()) {
            return Optional.empty();
        }
        Output.OutputBuilder builder = Output.builder().executionId(execution.getId()).state(execution.getState().getCurrent());
        if (this.getOutputs() != null) {
            try {
                builder.outputs(runContext.render(this.getOutputs()));
            }
            catch (Exception e) {
                runContext.logger().warn("Failed to extract outputs with the error: '" + e.getMessage() + "'", (Throwable)e);
                taskRun = taskRun.withState(State.Type.FAILED).withAttempts(Collections.singletonList(TaskRunAttempt.builder().state(new State().withState(State.Type.FAILED)).build())).withOutputs(builder.build().toMap());
                return Optional.of(WorkerTaskResult.builder().taskRun(taskRun).build());
            }
        }
        taskRun = taskRun.withOutputs(builder.build().toMap());
        State.Type finalState = ExecutableUtils.guessState(execution, this.transmitFailed, State.Type.SUCCESS);
        if (taskRun.getState().getCurrent() != finalState) {
            taskRun = taskRun.withState(finalState);
        }
        return Optional.of(ExecutableUtils.workerTaskResult(taskRun));
    }

    @Override
    public boolean waitForExecution() {
        return this.wait;
    }

    @Override
    public ExecutableTask.SubflowId subflowId() {
        return new ExecutableTask.SubflowId(this.namespace, this.flowId, Optional.ofNullable(this.revision));
    }

    @Generated
    private static Boolean $default$wait() {
        return false;
    }

    @Generated
    private static Boolean $default$transmitFailed() {
        return false;
    }

    @Generated
    private static Boolean $default$inheritLabels() {
        return false;
    }

    @Generated
    protected Flow(FlowBuilder<?, ?> b) {
        super((Task.TaskBuilder)b);
        this.namespace = b.namespace;
        this.flowId = b.flowId;
        this.revision = b.revision;
        this.inputs = b.inputs;
        this.labels = b.labels;
        this.wait = b.wait$set ? b.wait$value : Flow.$default$wait();
        this.transmitFailed = b.transmitFailed$set ? b.transmitFailed$value : Flow.$default$transmitFailed();
        this.inheritLabels = b.inheritLabels$set ? b.inheritLabels$value : Flow.$default$inheritLabels();
        this.outputs = b.outputs;
    }

    @Generated
    public static FlowBuilder<?, ?> builder() {
        return new FlowBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Flow(super=" + super.toString() + ", namespace=" + this.getNamespace() + ", flowId=" + this.getFlowId() + ", revision=" + this.getRevision() + ", inputs=" + this.getInputs() + ", labels=" + this.getLabels() + ", wait=" + this.getWait() + ", transmitFailed=" + this.getTransmitFailed() + ", inheritLabels=" + this.getInheritLabels() + ", outputs=" + this.getOutputs() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Flow)) {
            return false;
        }
        Flow other = (Flow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$revision = this.getRevision();
        Integer other$revision = other.getRevision();
        if (this$revision == null ? other$revision != null : !((Object)this$revision).equals(other$revision)) {
            return false;
        }
        Boolean this$wait = this.getWait();
        Boolean other$wait = other.getWait();
        if (this$wait == null ? other$wait != null : !((Object)this$wait).equals(other$wait)) {
            return false;
        }
        Boolean this$transmitFailed = this.getTransmitFailed();
        Boolean other$transmitFailed = other.getTransmitFailed();
        if (this$transmitFailed == null ? other$transmitFailed != null : !((Object)this$transmitFailed).equals(other$transmitFailed)) {
            return false;
        }
        Boolean this$inheritLabels = this.getInheritLabels();
        Boolean other$inheritLabels = other.getInheritLabels();
        if (this$inheritLabels == null ? other$inheritLabels != null : !((Object)this$inheritLabels).equals(other$inheritLabels)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$flowId = this.getFlowId();
        String other$flowId = other.getFlowId();
        if (this$flowId == null ? other$flowId != null : !this$flowId.equals(other$flowId)) {
            return false;
        }
        Map<String, Object> this$inputs = this.getInputs();
        Map<String, Object> other$inputs = other.getInputs();
        if (this$inputs == null ? other$inputs != null : !((Object)this$inputs).equals(other$inputs)) {
            return false;
        }
        Map<String, String> this$labels = this.getLabels();
        Map<String, String> other$labels = other.getLabels();
        if (this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels)) {
            return false;
        }
        Map<String, Object> this$outputs = this.getOutputs();
        Map<String, Object> other$outputs = other.getOutputs();
        return !(this$outputs == null ? other$outputs != null : !((Object)this$outputs).equals(other$outputs));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Flow;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $revision = this.getRevision();
        result = result * 59 + ($revision == null ? 43 : ((Object)$revision).hashCode());
        Boolean $wait = this.getWait();
        result = result * 59 + ($wait == null ? 43 : ((Object)$wait).hashCode());
        Boolean $transmitFailed = this.getTransmitFailed();
        result = result * 59 + ($transmitFailed == null ? 43 : ((Object)$transmitFailed).hashCode());
        Boolean $inheritLabels = this.getInheritLabels();
        result = result * 59 + ($inheritLabels == null ? 43 : ((Object)$inheritLabels).hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $flowId = this.getFlowId();
        result = result * 59 + ($flowId == null ? 43 : $flowId.hashCode());
        Map<String, Object> $inputs = this.getInputs();
        result = result * 59 + ($inputs == null ? 43 : ((Object)$inputs).hashCode());
        Map<String, String> $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        Map<String, Object> $outputs = this.getOutputs();
        result = result * 59 + ($outputs == null ? 43 : ((Object)$outputs).hashCode());
        return result;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public String getFlowId() {
        return this.flowId;
    }

    @Generated
    public Integer getRevision() {
        return this.revision;
    }

    @Generated
    public Map<String, Object> getInputs() {
        return this.inputs;
    }

    @Generated
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @Generated
    public Boolean getWait() {
        return this.wait;
    }

    @Generated
    public Boolean getTransmitFailed() {
        return this.transmitFailed;
    }

    @Generated
    public Boolean getInheritLabels() {
        return this.inheritLabels;
    }

    @Generated
    public Map<String, Object> getOutputs() {
        return this.outputs;
    }

    @Generated
    public Flow() {
        this.wait = Flow.$default$wait();
        this.transmitFailed = Flow.$default$transmitFailed();
        this.inheritLabels = Flow.$default$inheritLabels();
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The id of the subflow execution.")
        private final String executionId;
        @Schema(title="The final state of the subflow execution.", description="This output is only available if `wait` is set to `true`.")
        private final State.Type state;
        @Schema(title="The extracted outputs from the subflow execution.")
        private final Map<String, Object> outputs;

        @ConstructorProperties(value={"executionId", "state", "outputs"})
        @Generated
        Output(String executionId, State.Type state, Map<String, Object> outputs) {
            this.executionId = executionId;
            this.state = state;
            this.outputs = outputs;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public String getExecutionId() {
            return this.executionId;
        }

        @Generated
        public State.Type getState() {
            return this.state;
        }

        @Generated
        public Map<String, Object> getOutputs() {
            return this.outputs;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private String executionId;
            @Generated
            private State.Type state;
            @Generated
            private Map<String, Object> outputs;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder executionId(String executionId) {
                this.executionId = executionId;
                return this;
            }

            @Generated
            public OutputBuilder state(State.Type state) {
                this.state = state;
                return this;
            }

            @Generated
            public OutputBuilder outputs(Map<String, Object> outputs) {
                this.outputs = outputs;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.executionId, this.state, this.outputs);
            }

            @Generated
            public String toString() {
                return "Flow.Output.OutputBuilder(executionId=" + this.executionId + ", state=" + this.state + ", outputs=" + this.outputs + ")";
            }
        }
    }

    @Generated
    public static abstract class FlowBuilder<C extends Flow, B extends FlowBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private String namespace;
        @Generated
        private String flowId;
        @Generated
        private Integer revision;
        @Generated
        private Map<String, Object> inputs;
        @Generated
        private Map<String, String> labels;
        @Generated
        private boolean wait$set;
        @Generated
        private Boolean wait$value;
        @Generated
        private boolean transmitFailed$set;
        @Generated
        private Boolean transmitFailed$value;
        @Generated
        private boolean inheritLabels$set;
        @Generated
        private Boolean inheritLabels$value;
        @Generated
        private Map<String, Object> outputs;

        @Generated
        public B namespace(String namespace) {
            this.namespace = namespace;
            return (B)this.self();
        }

        @Generated
        public B flowId(String flowId) {
            this.flowId = flowId;
            return (B)this.self();
        }

        @Generated
        public B revision(Integer revision) {
            this.revision = revision;
            return (B)this.self();
        }

        @Generated
        public B inputs(Map<String, Object> inputs) {
            this.inputs = inputs;
            return (B)this.self();
        }

        @Generated
        public B labels(Map<String, String> labels) {
            this.labels = labels;
            return (B)this.self();
        }

        @Generated
        public B wait(Boolean wait) {
            this.wait$value = wait;
            this.wait$set = true;
            return (B)this.self();
        }

        @Generated
        public B transmitFailed(Boolean transmitFailed) {
            this.transmitFailed$value = transmitFailed;
            this.transmitFailed$set = true;
            return (B)this.self();
        }

        @Generated
        public B inheritLabels(Boolean inheritLabels) {
            this.inheritLabels$value = inheritLabels;
            this.inheritLabels$set = true;
            return (B)this.self();
        }

        @Generated
        public B outputs(Map<String, Object> outputs) {
            this.outputs = outputs;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Flow.FlowBuilder(super=" + super.toString() + ", namespace=" + this.namespace + ", flowId=" + this.flowId + ", revision=" + this.revision + ", inputs=" + this.inputs + ", labels=" + this.labels + ", wait$value=" + this.wait$value + ", transmitFailed$value=" + this.transmitFailed$value + ", inheritLabels$value=" + this.inheritLabels$value + ", outputs=" + this.outputs + ")";
        }
    }

    @Generated
    private static final class FlowBuilderImpl
    extends FlowBuilder<Flow, FlowBuilderImpl> {
        @Generated
        private FlowBuilderImpl() {
        }

        @Override
        @Generated
        protected FlowBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Flow build() {
            return new Flow(this);
        }
    }
}

