/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.tasks.flows;

import com.google.common.collect.ImmutableMap;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.NextTaskRun;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.hierarchies.GraphCluster;
import io.kestra.core.models.hierarchies.RelationType;
import io.kestra.core.models.tasks.FlowableTask;
import io.kestra.core.models.tasks.ResolvedTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.FlowableUtils;
import io.kestra.core.runners.RunContext;
import io.kestra.core.utils.GraphUtils;
import io.kestra.core.utils.Rethrow;
import io.kestra.core.validations.SwitchTaskValidation;
import io.micronaut.core.annotation.Introspected;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.Generated;

@Schema(title="Run tasks conditionally, i.e. decide which branch of tasks should be executed based on a given value", description="This task runs a set of tasks based on a given value.\nThe value is evaluated at runtime and compared to the list of cases.\nIf the value matches a case, the corresponding tasks are executed.\nIf the value does not match any case, the default tasks are executed.")
@Plugin(examples={@Example(full=true, code={"id: switch", "namespace: io.kestra.tests", "", "inputs:", "  - name: string", "    type: STRING", "    required: true", "", "tasks:", "  - id: switch", "    type: io.kestra.core.tasks.flows.Switch", "    value: \"{{inputs.string}}\"", "    cases:", "      FIRST:", "        - id: 1st", "          type: io.kestra.core.tasks.debugs.Return", "          format: \"{{task.id}} > {{taskrun.startDate}}\"", "      SECOND:", "        - id: 2nd", "          type: io.kestra.core.tasks.debugs.Return", "          format: \"{{task.id}} > {{taskrun.startDate}}\"", "      THIRD:", "        - id: 3th", "          type: io.kestra.core.tasks.debugs.Return", "          format: \"{{task.id}} > {{taskrun.startDate}}\"", "    defaults:", "      - id: default", "        type: io.kestra.core.tasks.debugs.Return", "        format: \"{{task.id}} > {{taskrun.startDate}}\""})})
@Introspected
@SwitchTaskValidation
public class Switch
extends Task
implements FlowableTask<Output> {
    @NotBlank
    @NotNull
    @Schema(title="The value to be evaluated")
    @PluginProperty(dynamic=true)
    private String value;
    @Schema(title="The map of keys and a list of tasks to be executed if the conditional `value` matches the key.")
    @PluginProperty
    private Map<String, List<Task>> cases;
    @Valid
    @PluginProperty
    private List<Task> defaults;
    @Valid
    @PluginProperty
    protected List<Task> errors;

    private String rendererValue(RunContext runContext) throws IllegalVariableEvaluationException {
        return runContext.render(this.value);
    }

    @Override
    public List<Task> allChildTasks() {
        return Stream.concat(this.defaults != null ? this.defaults.stream() : Stream.empty(), Stream.concat(this.cases != null ? this.cases.values().stream().flatMap(Collection::stream) : Stream.empty(), this.errors != null ? this.errors.stream() : Stream.empty())).collect(Collectors.toList());
    }

    @Override
    public GraphCluster tasksTree(Execution execution, TaskRun taskRun, List<String> parentValues) throws IllegalVariableEvaluationException {
        GraphCluster subGraph = new GraphCluster(this, taskRun, parentValues, RelationType.CHOICE);
        GraphUtils.switchCase(subGraph, Stream.concat(this.defaults != null ? ImmutableMap.of((Object)"defaults", this.defaults).entrySet().stream() : Stream.empty(), this.cases != null ? this.cases.entrySet().stream() : Stream.empty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)), this.errors, taskRun, execution);
        return subGraph;
    }

    @Override
    public List<ResolvedTask> childTasks(RunContext runContext, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        return this.cases.entrySet().stream().filter(Rethrow.throwPredicate(entry -> ((String)entry.getKey()).equals(this.rendererValue(runContext)))).map(Map.Entry::getValue).map(tasks -> FlowableUtils.resolveTasks(tasks, parentTaskRun)).findFirst().orElse(FlowableUtils.resolveTasks(this.defaults, parentTaskRun));
    }

    @Override
    public Optional<State.Type> resolveState(RunContext runContext, Execution execution, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        return FlowableUtils.resolveState(execution, this.childTasks(runContext, parentTaskRun), FlowableUtils.resolveTasks(this.getErrors(), parentTaskRun), parentTaskRun, runContext);
    }

    @Override
    public List<NextTaskRun> resolveNexts(RunContext runContext, Execution execution, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        return FlowableUtils.resolveSequentialNexts(execution, this.childTasks(runContext, parentTaskRun), FlowableUtils.resolveTasks(this.errors, parentTaskRun), parentTaskRun);
    }

    @Override
    public Output outputs(RunContext runContext, Execution execution, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        return Output.builder().value(this.rendererValue(runContext)).defaults(this.cases.entrySet().stream().noneMatch(Rethrow.throwPredicate(entry -> ((String)entry.getKey()).equals(this.rendererValue(runContext))))).build();
    }

    @Generated
    protected Switch(SwitchBuilder<?, ?> b) {
        super(b);
        this.value = b.value;
        this.cases = b.cases;
        this.defaults = b.defaults;
        this.errors = b.errors;
    }

    @Generated
    public static SwitchBuilder<?, ?> builder() {
        return new SwitchBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Switch(super=" + super.toString() + ", value=" + this.getValue() + ", cases=" + this.getCases() + ", defaults=" + this.getDefaults() + ", errors=" + this.getErrors() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Switch)) {
            return false;
        }
        Switch other = (Switch)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        Map<String, List<Task>> this$cases = this.getCases();
        Map<String, List<Task>> other$cases = other.getCases();
        if (this$cases == null ? other$cases != null : !((Object)this$cases).equals(other$cases)) {
            return false;
        }
        List<Task> this$defaults = this.getDefaults();
        List<Task> other$defaults = other.getDefaults();
        if (this$defaults == null ? other$defaults != null : !((Object)this$defaults).equals(other$defaults)) {
            return false;
        }
        List<Task> this$errors = this.getErrors();
        List<Task> other$errors = other.getErrors();
        return !(this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Switch;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        Map<String, List<Task>> $cases = this.getCases();
        result = result * 59 + ($cases == null ? 43 : ((Object)$cases).hashCode());
        List<Task> $defaults = this.getDefaults();
        result = result * 59 + ($defaults == null ? 43 : ((Object)$defaults).hashCode());
        List<Task> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        return result;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public Map<String, List<Task>> getCases() {
        return this.cases;
    }

    @Generated
    public List<Task> getDefaults() {
        return this.defaults;
    }

    @Override
    @Generated
    public List<Task> getErrors() {
        return this.errors;
    }

    @Generated
    public Switch() {
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        private String value;
        private boolean defaults;

        @ConstructorProperties(value={"value", "defaults"})
        @Generated
        Output(String value, boolean defaults) {
            this.value = value;
            this.defaults = defaults;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        public boolean isDefaults() {
            return this.defaults;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private String value;
            @Generated
            private boolean defaults;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder value(String value) {
                this.value = value;
                return this;
            }

            @Generated
            public OutputBuilder defaults(boolean defaults) {
                this.defaults = defaults;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.value, this.defaults);
            }

            @Generated
            public String toString() {
                return "Switch.Output.OutputBuilder(value=" + this.value + ", defaults=" + this.defaults + ")";
            }
        }
    }

    @Generated
    public static abstract class SwitchBuilder<C extends Switch, B extends SwitchBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private String value;
        @Generated
        private Map<String, List<Task>> cases;
        @Generated
        private List<Task> defaults;
        @Generated
        private List<Task> errors;

        @Generated
        public B value(String value) {
            this.value = value;
            return (B)this.self();
        }

        @Generated
        public B cases(Map<String, List<Task>> cases) {
            this.cases = cases;
            return (B)this.self();
        }

        @Generated
        public B defaults(List<Task> defaults) {
            this.defaults = defaults;
            return (B)this.self();
        }

        @Generated
        public B errors(List<Task> errors) {
            this.errors = errors;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Switch.SwitchBuilder(super=" + super.toString() + ", value=" + this.value + ", cases=" + this.cases + ", defaults=" + this.defaults + ", errors=" + this.errors + ")";
        }
    }

    @Generated
    private static final class SwitchBuilderImpl
    extends SwitchBuilder<Switch, SwitchBuilderImpl> {
        @Generated
        private SwitchBuilderImpl() {
        }

        @Override
        @Generated
        protected SwitchBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Switch build() {
            return new Switch(this);
        }
    }
}

