/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.tasks.storages;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.kestra.core.services.StorageService;
import io.kestra.core.storages.StorageSplitInterface;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.List;
import lombok.Generated;

@Schema(title="Split a file from the internal storage onto multiple files.")
@Plugin(examples={@Example(title="Split a file by size.", code={"from: \"kestra://long/url/file1.txt\"", "bytes: 10MB"}), @Example(title="Split a file by rows count.", code={"from: \"kestra://long/url/file1.txt\"", "rows: 1000"}), @Example(title="Split a file in a defined number of partitions.", code={"from: \"kestra://long/url/file1.txt\"", "partitions: 8"})})
public class Split
extends Task
implements RunnableTask<Output>,
StorageSplitInterface {
    @Schema(title="The file to be split.")
    @PluginProperty(dynamic=true)
    private String from;
    private String bytes;
    private Integer partitions;
    private Integer rows;
    private String separator;

    @Override
    public Output run(RunContext runContext) throws Exception {
        URI from = new URI(runContext.render(this.from));
        return Output.builder().uris(StorageService.split(runContext, this, from)).build();
    }

    @Generated
    private static String $default$separator() {
        return "\n";
    }

    @Generated
    protected Split(SplitBuilder<?, ?> b) {
        super((Task.TaskBuilder)b);
        this.from = b.from;
        this.bytes = b.bytes;
        this.partitions = b.partitions;
        this.rows = b.rows;
        this.separator = b.separator$set ? b.separator$value : Split.$default$separator();
    }

    @Generated
    public static SplitBuilder<?, ?> builder() {
        return new SplitBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Split(super=" + super.toString() + ", from=" + this.getFrom() + ", bytes=" + this.getBytes() + ", partitions=" + this.getPartitions() + ", rows=" + this.getRows() + ", separator=" + this.getSeparator() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Split)) {
            return false;
        }
        Split other = (Split)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$partitions = this.getPartitions();
        Integer other$partitions = other.getPartitions();
        if (this$partitions == null ? other$partitions != null : !((Object)this$partitions).equals(other$partitions)) {
            return false;
        }
        Integer this$rows = this.getRows();
        Integer other$rows = other.getRows();
        if (this$rows == null ? other$rows != null : !((Object)this$rows).equals(other$rows)) {
            return false;
        }
        String this$from = this.getFrom();
        String other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
            return false;
        }
        String this$bytes = this.getBytes();
        String other$bytes = other.getBytes();
        if (this$bytes == null ? other$bytes != null : !this$bytes.equals(other$bytes)) {
            return false;
        }
        String this$separator = this.getSeparator();
        String other$separator = other.getSeparator();
        return !(this$separator == null ? other$separator != null : !this$separator.equals(other$separator));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Split;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $partitions = this.getPartitions();
        result = result * 59 + ($partitions == null ? 43 : ((Object)$partitions).hashCode());
        Integer $rows = this.getRows();
        result = result * 59 + ($rows == null ? 43 : ((Object)$rows).hashCode());
        String $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        String $bytes = this.getBytes();
        result = result * 59 + ($bytes == null ? 43 : $bytes.hashCode());
        String $separator = this.getSeparator();
        result = result * 59 + ($separator == null ? 43 : $separator.hashCode());
        return result;
    }

    @Generated
    public String getFrom() {
        return this.from;
    }

    @Override
    @Generated
    public String getBytes() {
        return this.bytes;
    }

    @Override
    @Generated
    public Integer getPartitions() {
        return this.partitions;
    }

    @Override
    @Generated
    public Integer getRows() {
        return this.rows;
    }

    @Override
    @Generated
    public String getSeparator() {
        return this.separator;
    }

    @Generated
    public Split() {
        this.separator = Split.$default$separator();
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The splitted file uris ")
        private final List<URI> uris;

        @ConstructorProperties(value={"uris"})
        @Generated
        Output(List<URI> uris) {
            this.uris = uris;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public List<URI> getUris() {
            return this.uris;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private List<URI> uris;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder uris(List<URI> uris) {
                this.uris = uris;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.uris);
            }

            @Generated
            public String toString() {
                return "Split.Output.OutputBuilder(uris=" + this.uris + ")";
            }
        }
    }

    @Generated
    public static abstract class SplitBuilder<C extends Split, B extends SplitBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private String from;
        @Generated
        private String bytes;
        @Generated
        private Integer partitions;
        @Generated
        private Integer rows;
        @Generated
        private boolean separator$set;
        @Generated
        private String separator$value;

        @Generated
        public B from(String from) {
            this.from = from;
            return (B)this.self();
        }

        @Generated
        public B bytes(String bytes) {
            this.bytes = bytes;
            return (B)this.self();
        }

        @Generated
        public B partitions(Integer partitions) {
            this.partitions = partitions;
            return (B)this.self();
        }

        @Generated
        public B rows(Integer rows) {
            this.rows = rows;
            return (B)this.self();
        }

        @Generated
        public B separator(String separator) {
            this.separator$value = separator;
            this.separator$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Split.SplitBuilder(super=" + super.toString() + ", from=" + this.from + ", bytes=" + this.bytes + ", partitions=" + this.partitions + ", rows=" + this.rows + ", separator$value=" + this.separator$value + ")";
        }
    }

    @Generated
    private static final class SplitBuilderImpl
    extends SplitBuilder<Split, SplitBuilderImpl> {
        @Generated
        private SplitBuilderImpl() {
        }

        @Override
        @Generated
        protected SplitBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Split build() {
            return new Split(this);
        }
    }
}

