/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.topologies;

import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.conditions.types.DateTimeBetweenCondition;
import io.kestra.core.models.conditions.types.DayWeekCondition;
import io.kestra.core.models.conditions.types.ExecutionStatusCondition;
import io.kestra.core.models.conditions.types.HasRetryAttemptCondition;
import io.kestra.core.models.conditions.types.MultipleCondition;
import io.kestra.core.models.conditions.types.VariableCondition;
import io.kestra.core.models.conditions.types.WeekendCondition;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.hierarchies.Graph;
import io.kestra.core.models.tasks.ExecutableTask;
import io.kestra.core.models.topologies.FlowNode;
import io.kestra.core.models.topologies.FlowRelation;
import io.kestra.core.models.topologies.FlowTopology;
import io.kestra.core.models.topologies.FlowTopologyGraph;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.types.Flow;
import io.kestra.core.repositories.FlowRepositoryInterface;
import io.kestra.core.repositories.FlowTopologyRepositoryInterface;
import io.kestra.core.runners.RunnerUtils;
import io.kestra.core.services.ConditionService;
import io.kestra.core.utils.ListUtils;
import io.micronaut.core.annotation.Nullable;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class FlowTopologyService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FlowTopologyService.class);
    @Inject
    protected ConditionService conditionService;
    @Inject
    protected RunnerUtils runnerUtils;
    @Inject
    private FlowRepositoryInterface flowRepository;
    @Inject
    private FlowTopologyRepositoryInterface flowTopologyRepository;

    public FlowTopologyGraph graph(Stream<FlowTopology> flows, Function<FlowNode, FlowNode> anonymize) {
        Graph<FlowNode, FlowRelation> graph = new Graph<FlowNode, FlowRelation>();
        flows.forEach(flowTopology -> {
            FlowNode source = (FlowNode)anonymize.apply(flowTopology.getSource());
            FlowNode destination = (FlowNode)anonymize.apply(flowTopology.getDestination());
            if (!graph.nodes().contains(source)) {
                graph.addNode(source);
            }
            if (!graph.nodes().contains(destination)) {
                graph.addNode(destination);
            }
            if (!source.getUid().equals(destination.getUid())) {
                graph.addEdge(source, destination, flowTopology.getRelation());
            }
        });
        return FlowTopologyGraph.of(graph);
    }

    public FlowTopologyGraph namespaceGraph(String tenantId, String namespace) {
        List<FlowTopology> flowTopologies = this.flowTopologyRepository.findByNamespace(tenantId, namespace);
        FlowTopologyGraph graph = this.graph(flowTopologies.stream(), flowNode -> flowNode);
        List<String> flowInGraph = graph.getNodes().stream().map(FlowNode::getId).distinct().toList();
        HashSet existingNodes = new HashSet(graph.getNodes().stream().collect(Collectors.toMap(node -> node.getId() + "_" + node.getNamespace(), Function.identity(), (node1, node2) -> node1)).values());
        HashSet newNodes = new HashSet();
        this.flowRepository.findByNamespace(tenantId, namespace).forEach(flow -> {
            if (flowInGraph.contains(flow.getId())) {
                return;
            }
            Object flowNode = ((FlowNode.FlowNodeBuilder)((FlowNode.FlowNodeBuilder)((FlowNode.FlowNodeBuilder)FlowNode.builder().id(flow.getId())).uid(flow.getNamespace() + "_" + flow.getId())).namespace(flow.getNamespace())).build();
            newNodes.add(flowNode);
        });
        HashSet<FlowNode> updatedNodes = new HashSet<FlowNode>(existingNodes);
        updatedNodes.addAll(newNodes);
        return FlowTopologyGraph.builder().nodes(updatedNodes).edges(graph.getEdges()).build();
    }

    public Stream<FlowTopology> topology(io.kestra.core.models.flows.Flow child, Stream<io.kestra.core.models.flows.Flow> allFlows) {
        return allFlows.flatMap(parent -> Stream.concat(Stream.ofNullable(this.map((io.kestra.core.models.flows.Flow)parent, child)), Stream.ofNullable(this.map(child, (io.kestra.core.models.flows.Flow)parent)))).filter(Objects::nonNull);
    }

    protected FlowTopology map(io.kestra.core.models.flows.Flow parent, io.kestra.core.models.flows.Flow child) {
        if (child.uidWithoutRevision().equals(parent.uidWithoutRevision())) {
            return null;
        }
        FlowRelation relation = this.isChild(parent, child);
        if (relation == null) {
            return null;
        }
        FlowNode parentTopology = FlowNode.of(parent);
        FlowNode childTopology = FlowNode.of(child);
        return FlowTopology.builder().source(parentTopology).destination(childTopology).relation(relation).build();
    }

    @Nullable
    public FlowRelation isChild(io.kestra.core.models.flows.Flow parent, io.kestra.core.models.flows.Flow child) {
        if (this.isFlowTaskChild(parent, child)) {
            return FlowRelation.FLOW_TASK;
        }
        if (this.isTriggerChild(parent, child)) {
            return FlowRelation.FLOW_TRIGGER;
        }
        return null;
    }

    protected boolean isFlowTaskChild(io.kestra.core.models.flows.Flow parent, io.kestra.core.models.flows.Flow child) {
        try {
            return parent.allTasksWithChilds().stream().filter(t -> t instanceof ExecutableTask).map(t -> (ExecutableTask)((Object)t)).anyMatch(t -> t.subflowId() != null && t.subflowId().namespace().equals(child.getNamespace()) && t.subflowId().flowId().equals(child.getId()));
        }
        catch (Exception e) {
            log.warn("Failed to detect flow task on namespace:'" + parent.getNamespace() + "', flowId:'" + parent.getId() + "'", (Throwable)e);
            return false;
        }
    }

    protected boolean isTriggerChild(io.kestra.core.models.flows.Flow parent, io.kestra.core.models.flows.Flow child) {
        List<AbstractTrigger> triggers = ListUtils.emptyOnNull(child.getTriggers());
        Execution execution = this.runnerUtils.newExecution(parent, (f, e) -> null, null);
        List flowTriggers = triggers.stream().filter(t -> t instanceof Flow).map(t -> (Flow)t).collect(Collectors.toList());
        if (flowTriggers.size() == 0) {
            return false;
        }
        return flowTriggers.stream().flatMap(flow -> ListUtils.emptyOnNull(flow.getConditions()).stream()).allMatch(condition -> this.validateCondition((Condition)condition, parent, execution));
    }

    protected boolean validateCondition(Condition condition, io.kestra.core.models.flows.Flow child, Execution execution) {
        if (this.isFilterCondition(condition)) {
            return true;
        }
        if (condition instanceof MultipleCondition) {
            List multipleConditions = ((MultipleCondition)condition).getConditions().values().stream().filter(c -> !this.isFilterCondition((Condition)c)).collect(Collectors.toList());
            return multipleConditions.stream().filter(c -> !this.isMandatoryMultipleCondition((Condition)c)).anyMatch(c -> this.validateCondition((Condition)c, child, execution)) && multipleConditions.stream().filter(this::isMandatoryMultipleCondition).allMatch(c -> this.validateCondition((Condition)c, child, execution));
        }
        return this.conditionService.isValid(condition, child, execution);
    }

    protected boolean isMandatoryMultipleCondition(Condition condition) {
        return Stream.of(VariableCondition.class).anyMatch(aClass -> condition.getClass().isAssignableFrom((Class<?>)aClass));
    }

    protected boolean isFilterCondition(Condition condition) {
        return Stream.of(ExecutionStatusCondition.class, DateTimeBetweenCondition.class, DayWeekCondition.class, HasRetryAttemptCondition.class, WeekendCondition.class).anyMatch(aClass -> condition.getClass().isAssignableFrom((Class<?>)aClass));
    }
}

