/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class MapUtils {
    public static Map<String, Object> merge(Map<String, Object> a, Map<String, Object> b) {
        if (a == null && b == null) {
            return null;
        }
        if (a == null || a.isEmpty()) {
            return MapUtils.copyMap(b);
        }
        if (b == null || b.isEmpty()) {
            return MapUtils.copyMap(a);
        }
        Map copy = MapUtils.copyMap(a);
        Map copyMap = b.entrySet().stream().collect(HashMap::new, (m, v) -> {
            Object found;
            Object original = copy.get(v.getKey());
            Object value = v.getValue();
            if (value == null && original == null) {
                found = null;
            } else if (value == null) {
                found = original;
            } else if (original == null) {
                found = value;
            } else if (value instanceof Map && original instanceof Map) {
                found = MapUtils.merge((Map)original, (Map)value);
            } else if (value instanceof Collection && original instanceof Collection) {
                try {
                    Collection merge = MapUtils.copyCollection((Collection)original, Lists.newArrayList((Object[])new Collection[]{(Collection)original, (Collection)value}).stream().flatMap(Collection::stream).collect(Collectors.toList()));
                    found = merge;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else {
                found = value;
            }
            m.put((String)v.getKey(), found);
        }, HashMap::putAll);
        copy.putAll(copyMap);
        return copy;
    }

    private static Map copyMap(Map original) {
        return original.entrySet().stream().collect(HashMap::new, (map, entry) -> {
            Object value = entry.getValue();
            Object found = value instanceof Map ? MapUtils.copyMap((Map)value) : (value instanceof Collection ? MapUtils.copyCollection((Collection)value, (Collection)value) : value);
            map.put(entry.getKey(), found);
        }, Map::putAll);
    }

    private static Collection copyCollection(Collection collection, Collection elements) {
        try {
            Collection newInstance = (Collection)collection.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            newInstance.addAll(elements);
            return newInstance;
        }
        catch (Exception e) {
            return new ArrayList(elements);
        }
    }
}

