/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.contexts;

import io.kestra.core.plugins.PluginRegistry;
import io.micronaut.context.ApplicationContextConfiguration;
import io.micronaut.context.DefaultApplicationContext;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.io.service.SoftServiceLoader;
import io.micronaut.inject.BeanDefinitionReference;
import java.util.Collection;
import java.util.List;

public class KestraApplicationContext
extends DefaultApplicationContext {
    private final PluginRegistry pluginRegistry;

    public PluginRegistry getPluginRegistry() {
        return this.pluginRegistry;
    }

    public KestraApplicationContext(@NonNull ApplicationContextConfiguration configuration, PluginRegistry pluginRegistry) {
        super(configuration);
        this.pluginRegistry = pluginRegistry;
    }

    @NonNull
    protected List<BeanDefinitionReference> resolveBeanDefinitionReferences() {
        List resolvedBeanReferences = super.resolveBeanDefinitionReferences();
        if (this.pluginRegistry != null) {
            this.pluginRegistry.getPlugins().forEach(plugin -> {
                SoftServiceLoader definitions = SoftServiceLoader.load(BeanDefinitionReference.class, (ClassLoader)plugin.getClassLoader());
                definitions.collectAll((Collection)resolvedBeanReferences, BeanDefinitionReference::isPresent);
            });
        }
        return resolvedBeanReferences;
    }
}

