/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.docs;

import com.google.common.base.CaseFormat;
import io.kestra.core.docs.JsonSchemaGenerator;
import java.beans.ConstructorProperties;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;

public abstract class AbstractClassDocumentation<T> {
    protected Boolean deprecated;
    protected String cls;
    protected String shortName;
    protected String docDescription;
    protected String docBody;
    protected List<ExampleDoc> docExamples;
    protected Map<String, Object> defs = new TreeMap<String, Object>();
    protected Map<String, Object> inputs = new TreeMap<String, Object>();
    protected Map<String, Object> propertiesSchema;

    protected AbstractClassDocumentation(JsonSchemaGenerator jsonSchemaGenerator, Class<? extends T> cls, Class<T> baseCls) {
        this.cls = cls.getName();
        this.shortName = cls.getSimpleName();
        this.propertiesSchema = jsonSchemaGenerator.properties(baseCls, cls);
        if (this.propertiesSchema.containsKey("$defs")) {
            this.defs.putAll((Map)this.propertiesSchema.get("$defs"));
            this.propertiesSchema.remove("$defs");
        }
        this.defs = this.getDefs().entrySet().stream().filter(entry -> !((String)entry.getKey()).equals("io.kestra.core.models.tasks.Task")).map(entry -> {
            Map value = (Map)entry.getValue();
            value.put("properties", AbstractClassDocumentation.flatten(AbstractClassDocumentation.properties(value), AbstractClassDocumentation.required(value)));
            return new AbstractMap.SimpleEntry<String, Map>((String)entry.getKey(), value);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.docDescription = this.propertiesSchema.containsKey("title") ? (String)this.propertiesSchema.get("title") : null;
        this.docBody = this.propertiesSchema.containsKey("description") ? (String)this.propertiesSchema.get("description") : null;
        this.deprecated = this.propertiesSchema.containsKey("$deprecated");
        if (this.propertiesSchema.containsKey("$examples")) {
            List examples = (List)this.propertiesSchema.get("$examples");
            this.docExamples = examples.stream().map(r -> new ExampleDoc((String)r.get("title"), String.join((CharSequence)"\n", (CharSequence[])ArrayUtils.addAll((Object[])((Boolean)r.get("full") != false ? new ArrayList() : Arrays.asList("id: \"" + CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, cls.getSimpleName()) + "\"", "type: \"" + cls.getName() + "\"")).toArray(new String[0]), (Object[])new String[]{(String)r.get("code")})))).collect(Collectors.toList());
        }
        if (this.propertiesSchema.containsKey("properties")) {
            this.inputs = AbstractClassDocumentation.flatten(AbstractClassDocumentation.properties(this.propertiesSchema), AbstractClassDocumentation.required(this.propertiesSchema));
        }
    }

    protected static Map<String, Object> flatten(Map<String, Object> map, List<String> required) {
        map.remove("type");
        return AbstractClassDocumentation.flatten(map, required, null);
    }

    protected static Map<String, Object> flatten(Map<String, Object> map, List<String> required, String parentName) {
        TreeMap<String, Object> result = new TreeMap<String, Object>((key1, key2) -> {
            boolean key2Required;
            boolean key1Required = required.contains(key1);
            if (key1Required == (key2Required = required.contains(key2))) {
                return key1.compareTo((String)key2);
            }
            return key1Required ? -1 : 1;
        });
        for (Map.Entry<String, Object> current : map.entrySet()) {
            Map value;
            Map finalValue = (Map)current.getValue();
            if (required.contains(current.getKey())) {
                finalValue.put("$required", true);
            }
            result.put(AbstractClassDocumentation.flattenKey(current.getKey(), parentName), finalValue);
            if (!(current.getValue() instanceof Map) || !(value = (Map)current.getValue()).containsKey("properties")) continue;
            result.putAll(AbstractClassDocumentation.flatten(AbstractClassDocumentation.properties(value), AbstractClassDocumentation.required(value), current.getKey()));
        }
        return result;
    }

    protected static String flattenKey(String current, String parent) {
        return (String)(parent != null ? parent + "." : "") + current;
    }

    protected static Map<String, Object> properties(Map<String, Object> props) {
        Map properties = (Map)props.get("properties");
        return properties != null ? properties : new HashMap();
    }

    protected static List<String> required(Map<String, Object> props) {
        if (!props.containsKey("required")) {
            return Collections.emptyList();
        }
        return (List)props.get("required");
    }

    @Generated
    public Boolean getDeprecated() {
        return this.deprecated;
    }

    @Generated
    public String getCls() {
        return this.cls;
    }

    @Generated
    public String getShortName() {
        return this.shortName;
    }

    @Generated
    public String getDocDescription() {
        return this.docDescription;
    }

    @Generated
    public String getDocBody() {
        return this.docBody;
    }

    @Generated
    public List<ExampleDoc> getDocExamples() {
        return this.docExamples;
    }

    @Generated
    public Map<String, Object> getDefs() {
        return this.defs;
    }

    @Generated
    public Map<String, Object> getInputs() {
        return this.inputs;
    }

    @Generated
    public Map<String, Object> getPropertiesSchema() {
        return this.propertiesSchema;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractClassDocumentation)) {
            return false;
        }
        AbstractClassDocumentation other = (AbstractClassDocumentation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$deprecated = this.getDeprecated();
        Boolean other$deprecated = other.getDeprecated();
        if (this$deprecated == null ? other$deprecated != null : !((Object)this$deprecated).equals(other$deprecated)) {
            return false;
        }
        String this$cls = this.getCls();
        String other$cls = other.getCls();
        if (this$cls == null ? other$cls != null : !this$cls.equals(other$cls)) {
            return false;
        }
        String this$shortName = this.getShortName();
        String other$shortName = other.getShortName();
        if (this$shortName == null ? other$shortName != null : !this$shortName.equals(other$shortName)) {
            return false;
        }
        String this$docDescription = this.getDocDescription();
        String other$docDescription = other.getDocDescription();
        if (this$docDescription == null ? other$docDescription != null : !this$docDescription.equals(other$docDescription)) {
            return false;
        }
        String this$docBody = this.getDocBody();
        String other$docBody = other.getDocBody();
        if (this$docBody == null ? other$docBody != null : !this$docBody.equals(other$docBody)) {
            return false;
        }
        List<ExampleDoc> this$docExamples = this.getDocExamples();
        List<ExampleDoc> other$docExamples = other.getDocExamples();
        if (this$docExamples == null ? other$docExamples != null : !((Object)this$docExamples).equals(other$docExamples)) {
            return false;
        }
        Map<String, Object> this$defs = this.getDefs();
        Map<String, Object> other$defs = other.getDefs();
        if (this$defs == null ? other$defs != null : !((Object)this$defs).equals(other$defs)) {
            return false;
        }
        Map<String, Object> this$inputs = this.getInputs();
        Map<String, Object> other$inputs = other.getInputs();
        if (this$inputs == null ? other$inputs != null : !((Object)this$inputs).equals(other$inputs)) {
            return false;
        }
        Map<String, Object> this$propertiesSchema = this.getPropertiesSchema();
        Map<String, Object> other$propertiesSchema = other.getPropertiesSchema();
        return !(this$propertiesSchema == null ? other$propertiesSchema != null : !((Object)this$propertiesSchema).equals(other$propertiesSchema));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractClassDocumentation;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $deprecated = this.getDeprecated();
        result = result * 59 + ($deprecated == null ? 43 : ((Object)$deprecated).hashCode());
        String $cls = this.getCls();
        result = result * 59 + ($cls == null ? 43 : $cls.hashCode());
        String $shortName = this.getShortName();
        result = result * 59 + ($shortName == null ? 43 : $shortName.hashCode());
        String $docDescription = this.getDocDescription();
        result = result * 59 + ($docDescription == null ? 43 : $docDescription.hashCode());
        String $docBody = this.getDocBody();
        result = result * 59 + ($docBody == null ? 43 : $docBody.hashCode());
        List<ExampleDoc> $docExamples = this.getDocExamples();
        result = result * 59 + ($docExamples == null ? 43 : ((Object)$docExamples).hashCode());
        Map<String, Object> $defs = this.getDefs();
        result = result * 59 + ($defs == null ? 43 : ((Object)$defs).hashCode());
        Map<String, Object> $inputs = this.getInputs();
        result = result * 59 + ($inputs == null ? 43 : ((Object)$inputs).hashCode());
        Map<String, Object> $propertiesSchema = this.getPropertiesSchema();
        result = result * 59 + ($propertiesSchema == null ? 43 : ((Object)$propertiesSchema).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AbstractClassDocumentation(deprecated=" + this.getDeprecated() + ", cls=" + this.getCls() + ", shortName=" + this.getShortName() + ", docDescription=" + this.getDocDescription() + ", docBody=" + this.getDocBody() + ", docExamples=" + this.getDocExamples() + ", defs=" + this.getDefs() + ", inputs=" + this.getInputs() + ", propertiesSchema=" + this.getPropertiesSchema() + ")";
    }

    public static class ExampleDoc {
        String title;
        String task;

        @ConstructorProperties(value={"title", "task"})
        @Generated
        public ExampleDoc(String title, String task) {
            this.title = title;
            this.task = task;
        }

        @Generated
        public String getTitle() {
            return this.title;
        }

        @Generated
        public String getTask() {
            return this.task;
        }
    }
}

