/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.conditions.types;

import io.kestra.core.exceptions.InternalException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.conditions.ScheduleCondition;
import io.kestra.core.utils.DateUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.DayOfWeek;
import java.time.LocalDate;
import javax.validation.constraints.NotNull;
import lombok.Generated;

@Schema(title="Condition for allows events on weekend")
@Plugin(examples={@Example(full=true, code={"- conditions:", "    - type: io.kestra.core.models.conditions.types.WeekendCondition"})})
public class WeekendCondition
extends Condition
implements ScheduleCondition {
    @NotNull
    @Schema(title="The date to test", description="Can be any variable or any valid ISO 8601 datetime, default will use `{{ now(format=\"iso_local_date\") }}`")
    @PluginProperty(dynamic=true)
    private final String date;

    @Override
    public boolean test(ConditionContext conditionContext) throws InternalException {
        String render = conditionContext.getRunContext().render(this.date, conditionContext.getVariables());
        LocalDate currentDate = DateUtils.parseLocalDate(render);
        return currentDate.getDayOfWeek().equals(DayOfWeek.SATURDAY) || currentDate.getDayOfWeek().equals(DayOfWeek.SUNDAY);
    }

    @Generated
    private static String $default$date() {
        return "{{ now(format(\"iso_local_date\") }}";
    }

    @Generated
    protected WeekendCondition(WeekendConditionBuilder<?, ?> b) {
        super((Condition.ConditionBuilder)b);
        this.date = b.date$set ? b.date$value : WeekendCondition.$default$date();
    }

    @Generated
    public static WeekendConditionBuilder<?, ?> builder() {
        return new WeekendConditionBuilderImpl();
    }

    @Generated
    public String toString() {
        return "WeekendCondition(super=" + super.toString() + ", date=" + this.getDate() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WeekendCondition)) {
            return false;
        }
        WeekendCondition other = (WeekendCondition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$date = this.getDate();
        String other$date = other.getDate();
        return !(this$date == null ? other$date != null : !this$date.equals(other$date));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WeekendCondition;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : $date.hashCode());
        return result;
    }

    @Generated
    public String getDate() {
        return this.date;
    }

    @Generated
    public WeekendCondition() {
        this.date = WeekendCondition.$default$date();
    }

    @Generated
    public static abstract class WeekendConditionBuilder<C extends WeekendCondition, B extends WeekendConditionBuilder<C, B>>
    extends Condition.ConditionBuilder<C, B> {
        @Generated
        private boolean date$set;
        @Generated
        private String date$value;

        @Generated
        public B date(String date) {
            this.date$value = date;
            this.date$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "WeekendCondition.WeekendConditionBuilder(super=" + super.toString() + ", date$value=" + this.date$value + ")";
        }
    }

    @Generated
    private static final class WeekendConditionBuilderImpl
    extends WeekendConditionBuilder<WeekendCondition, WeekendConditionBuilderImpl> {
        @Generated
        private WeekendConditionBuilderImpl() {
        }

        @Override
        @Generated
        protected WeekendConditionBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public WeekendCondition build() {
            return new WeekendCondition(this);
        }
    }
}

