/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.executions;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.collect.ImmutableMap;
import io.kestra.core.metrics.MetricRegistry;
import io.kestra.core.models.executions.metrics.Counter;
import io.kestra.core.models.executions.metrics.Timer;
import io.micronaut.core.annotation.Introspected;
import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;
import lombok.Generated;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", visible=true, include=JsonTypeInfo.As.EXISTING_PROPERTY)
@JsonSubTypes(value={@JsonSubTypes.Type(value=Counter.class, name="counter"), @JsonSubTypes.Type(value=Timer.class, name="timer")})
@Introspected
public abstract class AbstractMetricEntry<T> {
    @NotNull
    protected String name;
    protected Map<String, String> tags;
    protected Instant timestamp = Instant.now();

    public abstract String getType();

    protected AbstractMetricEntry(@NotNull String name, String[] tags) {
        this.name = name;
        this.tags = AbstractMetricEntry.tagsAsMap(tags);
    }

    private static Map<String, String> tagsAsMap(String ... keyValues) {
        if (keyValues == null || keyValues.length == 0) {
            return ImmutableMap.of();
        }
        if (keyValues.length % 2 == 1) {
            throw new IllegalArgumentException("size must be even, it is a set of key=value pairs");
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < keyValues.length; i += 2) {
            builder.put((Object)keyValues[i], (Object)keyValues[i + 1]);
        }
        return builder.build();
    }

    protected String[] tagsAsArray(Map<String, String> others) {
        return (String[])Stream.concat(Optional.ofNullable(this.tags).map(Map::entrySet).stream().flatMap(Collection::stream), others.entrySet().stream()).flatMap(e -> Stream.of((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList()).toArray(String[]::new);
    }

    protected String metricName(String prefix) {
        return prefix == null ? this.name : prefix + "." + this.name;
    }

    public abstract T getValue();

    public abstract void register(MetricRegistry var1, String var2, Map<String, String> var3);

    public abstract void increment(T var1);

    @Generated
    public String toString() {
        return "AbstractMetricEntry(name=" + this.getName() + ", tags=" + this.getTags() + ", timestamp=" + this.getTimestamp() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractMetricEntry)) {
            return false;
        }
        AbstractMetricEntry other = (AbstractMetricEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Map<String, String> this$tags = this.getTags();
        Map<String, String> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractMetricEntry;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Map<String, String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Map<String, String> getTags() {
        return this.tags;
    }

    @Generated
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public AbstractMetricEntry() {
    }
}

