/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.executions.metrics;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.kestra.core.metrics.MetricRegistry;
import io.kestra.core.models.executions.AbstractMetricEntry;
import java.time.Duration;
import java.util.Map;
import javax.validation.constraints.NotNull;
import lombok.Generated;

public class Timer
extends AbstractMetricEntry<Duration> {
    public static final String TYPE = "timer";
    @NotNull
    @JsonInclude
    private final String type = "timer";
    @NotNull
    private Duration value;

    private Timer(@NotNull String name, @NotNull Duration value, String ... tags) {
        super(name, tags);
        this.value = value;
    }

    public static Timer of(@NotNull String name, @NotNull Duration value, String ... tags) {
        return new Timer(name, value, tags);
    }

    @Override
    public void register(MetricRegistry meterRegistry, String prefix, Map<String, String> tags) {
        meterRegistry.timer(this.metricName(prefix), this.tagsAsArray(tags)).record(this.value);
    }

    @Override
    public void increment(Duration value) {
        this.value = this.value.plus(value);
    }

    @Override
    @Generated
    public String toString() {
        return "Timer(super=" + super.toString() + ", type=" + this.getType() + ", value=" + this.getValue() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Timer)) {
            return false;
        }
        Timer other = (Timer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Timer;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getType() {
        return this.type;
    }

    @Override
    @Generated
    public Duration getValue() {
        return this.value;
    }

    @Generated
    public Timer() {
    }
}

