/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.validations;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.micronaut.core.annotation.Introspected;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Introspected
public class ValidateConstraintViolation {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ValidateConstraintViolation.class);
    private String flow;
    private String namespace;
    @NotNull
    private int index;
    private String constraints;
    private List<String> deprecationPaths;

    @JsonIgnore
    public String getIdentity() {
        return this.flow != null && this.namespace != null ? this.getFlowId() : (this.flow != null ? this.flow : String.valueOf(this.index));
    }

    @JsonIgnore
    public String getIdentity(Path directory) throws IOException {
        return this.flow != null && this.namespace != null ? this.getFlowId() : (this.flow != null ? this.flow : this.getPath(directory));
    }

    private String getPath(Path directory) throws IOException {
        try (Stream<Path> files = Files.walk(directory, new FileVisitOption[0]);){
            String string = String.valueOf(files.toList().get(this.index));
            return string;
        }
    }

    @JsonIgnore
    public String getFlowId() {
        return this.namespace + "." + this.flow;
    }

    @Generated
    protected ValidateConstraintViolation(ValidateConstraintViolationBuilder<?, ?> b) {
        this.flow = b.flow;
        this.namespace = b.namespace;
        this.index = b.index;
        this.constraints = b.constraints;
        this.deprecationPaths = b.deprecationPaths;
    }

    @Generated
    public static ValidateConstraintViolationBuilder<?, ?> builder() {
        return new ValidateConstraintViolationBuilderImpl();
    }

    @Generated
    public ValidateConstraintViolationBuilder<?, ?> toBuilder() {
        return new ValidateConstraintViolationBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getFlow() {
        return this.flow;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public int getIndex() {
        return this.index;
    }

    @Generated
    public String getConstraints() {
        return this.constraints;
    }

    @Generated
    public List<String> getDeprecationPaths() {
        return this.deprecationPaths;
    }

    @ConstructorProperties(value={"flow", "namespace", "index", "constraints", "deprecationPaths"})
    @Generated
    public ValidateConstraintViolation(String flow, String namespace, int index, String constraints, List<String> deprecationPaths) {
        this.flow = flow;
        this.namespace = namespace;
        this.index = index;
        this.constraints = constraints;
        this.deprecationPaths = deprecationPaths;
    }

    @Generated
    public ValidateConstraintViolation() {
    }

    @Generated
    public String toString() {
        return "ValidateConstraintViolation(flow=" + this.getFlow() + ", namespace=" + this.getNamespace() + ", index=" + this.getIndex() + ", constraints=" + this.getConstraints() + ", deprecationPaths=" + this.getDeprecationPaths() + ")";
    }

    @Generated
    public static abstract class ValidateConstraintViolationBuilder<C extends ValidateConstraintViolation, B extends ValidateConstraintViolationBuilder<C, B>> {
        @Generated
        private String flow;
        @Generated
        private String namespace;
        @Generated
        private int index;
        @Generated
        private String constraints;
        @Generated
        private List<String> deprecationPaths;

        @Generated
        protected B $fillValuesFrom(C instance) {
            ValidateConstraintViolationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(ValidateConstraintViolation instance, ValidateConstraintViolationBuilder<?, ?> b) {
            b.flow(instance.flow);
            b.namespace(instance.namespace);
            b.index(instance.index);
            b.constraints(instance.constraints);
            b.deprecationPaths(instance.deprecationPaths);
        }

        @Generated
        public B flow(String flow) {
            this.flow = flow;
            return this.self();
        }

        @Generated
        public B namespace(String namespace) {
            this.namespace = namespace;
            return this.self();
        }

        @Generated
        public B index(int index) {
            this.index = index;
            return this.self();
        }

        @Generated
        public B constraints(String constraints) {
            this.constraints = constraints;
            return this.self();
        }

        @Generated
        public B deprecationPaths(List<String> deprecationPaths) {
            this.deprecationPaths = deprecationPaths;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "ValidateConstraintViolation.ValidateConstraintViolationBuilder(flow=" + this.flow + ", namespace=" + this.namespace + ", index=" + this.index + ", constraints=" + this.constraints + ", deprecationPaths=" + this.deprecationPaths + ")";
        }
    }

    @Generated
    private static final class ValidateConstraintViolationBuilderImpl
    extends ValidateConstraintViolationBuilder<ValidateConstraintViolation, ValidateConstraintViolationBuilderImpl> {
        @Generated
        private ValidateConstraintViolationBuilderImpl() {
        }

        @Override
        @Generated
        protected ValidateConstraintViolationBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ValidateConstraintViolation build() {
            return new ValidateConstraintViolation(this);
        }
    }
}

