/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.repositories;

import io.kestra.core.models.SearchResult;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowWithSource;
import io.kestra.core.repositories.ArrayListTotal;
import io.micronaut.data.model.Pageable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.validation.ConstraintViolationException;

public interface FlowRepositoryInterface {
    public Optional<Flow> findById(String var1, String var2, String var3, Optional<Integer> var4, Boolean var5);

    default public Optional<Flow> findById(String tenantId, String namespace, String id, Optional<Integer> revision) {
        return this.findById(tenantId, namespace, id, revision, false);
    }

    default public Flow findByExecution(Execution execution) {
        Optional<Flow> find = this.findById(execution.getTenantId(), execution.getNamespace(), execution.getFlowId(), Optional.of(execution.getFlowRevision()));
        if (find.isEmpty()) {
            throw new IllegalStateException("Unable to find flow '" + execution.getNamespace() + "." + execution.getFlowId() + "' with revision " + execution.getFlowRevision() + " on execution " + execution.getId());
        }
        return find.get();
    }

    default public Optional<Flow> findById(String tenantId, String namespace, String id) {
        return this.findById(tenantId, namespace, id, Optional.empty(), false);
    }

    public Optional<FlowWithSource> findByIdWithSource(String var1, String var2, String var3, Optional<Integer> var4, Boolean var5);

    default public Optional<FlowWithSource> findByIdWithSource(String tenantId, String namespace, String id, Optional<Integer> revision) {
        return this.findByIdWithSource(tenantId, namespace, id, revision, false);
    }

    default public Optional<FlowWithSource> findByIdWithSource(String tenantId, String namespace, String id) {
        return this.findByIdWithSource(tenantId, namespace, id, Optional.empty(), false);
    }

    public List<FlowWithSource> findRevisions(String var1, String var2, String var3);

    public List<Flow> findAll(String var1);

    public List<Flow> findAllForAllTenants();

    public List<Flow> findByNamespace(String var1, String var2);

    public ArrayListTotal<Flow> find(Pageable var1, @Nullable String var2, @Nullable String var3, @Nullable String var4, @Nullable Map<String, String> var5);

    public List<FlowWithSource> findWithSource(@Nullable String var1, @Nullable String var2, @Nullable String var3, @Nullable Map<String, String> var4);

    public ArrayListTotal<SearchResult<Flow>> findSourceCode(Pageable var1, @Nullable String var2, @Nullable String var3, @Nullable String var4);

    public List<String> findDistinctNamespace(String var1);

    public FlowWithSource create(Flow var1, String var2, Flow var3);

    public FlowWithSource update(Flow var1, Flow var2, String var3, Flow var4) throws ConstraintViolationException;

    public Flow delete(Flow var1);
}

