/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.runners.RunContext;
import io.kestra.core.tasks.PluginUtilsService;
import io.kestra.core.utils.ListUtils;
import io.kestra.core.utils.Rethrow;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public abstract class FilesService {
    public static Map<String, String> inputFiles(RunContext runContext, Object inputs) throws Exception {
        Logger logger = runContext.logger();
        Map<String, String> inputFiles = inputs == null ? Map.of() : PluginUtilsService.transformInputFiles(runContext, inputs);
        inputFiles.forEach(Rethrow.throwBiConsumer((fileName, input) -> {
            block14: {
                String fileContent;
                File file = new File(runContext.tempDir().toString(), (String)fileName);
                if (file.exists()) {
                    throw new IllegalVariableEvaluationException("File '" + fileName + "' already exist!");
                }
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                if ((fileContent = runContext.render((String)input)).startsWith("kestra://")) {
                    try (InputStream is = runContext.uriToInputStream(URI.create(fileContent));
                         FileOutputStream out = new FileOutputStream(file);){
                        IOUtils.copyLarge((InputStream)is, (OutputStream)out);
                        break block14;
                    }
                }
                Files.write(file.toPath(), fileContent.getBytes(), new OpenOption[0]);
            }
        }));
        logger.info("Provided {} input(s).", (Object)inputFiles.size());
        return inputFiles;
    }

    public static Map<String, URI> outputFiles(RunContext runContext, List<String> outputs) throws Exception {
        Map<String, URI> outputFiles = ListUtils.emptyOnNull(outputs).stream().flatMap(Rethrow.throwFunction(output -> FilesService.outputMatcher(runContext, output))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        runContext.logger().info("Captured {} output(s).", (Object)outputFiles.size());
        return outputFiles;
    }

    private static Stream<AbstractMap.SimpleEntry<String, URI>> outputMatcher(RunContext runContext, String output) throws IllegalVariableEvaluationException, IOException {
        String glob = runContext.render(output);
        PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:" + glob);
        try (Stream<Path> walk = Files.walk(runContext.tempDir(), new FileVisitOption[0]);){
            Stream<AbstractMap.SimpleEntry<String, URI>> stream = walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> pathMatcher.matches(runContext.tempDir().relativize((Path)path))).map(Rethrow.throwFunction(path -> new AbstractMap.SimpleEntry<String, URI>(runContext.tempDir().relativize((Path)path).toString(), runContext.putTempFile(path.toFile())))).toList().stream();
            return stream;
        }
    }
}

